/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.cache.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.core.cache.Cache;
import com.flipkart.foxtrot.core.cache.CacheFactory;
import com.flipkart.foxtrot.core.cache.impl.DistributedCache;
import com.flipkart.foxtrot.core.querystore.impl.CacheConfig;
import com.flipkart.foxtrot.core.querystore.impl.HazelcastConnection;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;

public class DistributedCacheFactory
implements CacheFactory {
    private final HazelcastConnection connection;
    private final ObjectMapper mapper;
    private static final int DEFAULT_TIME_TO_LIVE_SECONDS = 15;
    private static final int DEFAULT_MAX_IDLE_SECONDS = 15;
    private static final int DEFAULT_SIZE = 70;

    public DistributedCacheFactory(HazelcastConnection connection, ObjectMapper mapper, CacheConfig cacheConfig) {
        this.connection = connection;
        this.mapper = mapper;
        this.connection.getHazelcastConfig().addMapConfig(this.getDefaultMapConfig(cacheConfig));
    }

    @Override
    public Cache create(String name) {
        return new DistributedCache(this.connection, name, this.mapper);
    }

    private MapConfig getDefaultMapConfig(CacheConfig cacheConfig) {
        MapConfig mapConfig = new MapConfig("cache-for-*");
        mapConfig.setInMemoryFormat(InMemoryFormat.BINARY);
        mapConfig.setBackupCount(0);
        mapConfig.setEvictionPolicy(EvictionPolicy.LRU);
        if (cacheConfig.getMaxIdleSeconds() == 0) {
            mapConfig.setMaxIdleSeconds(15);
        } else {
            mapConfig.setMaxIdleSeconds(cacheConfig.getMaxIdleSeconds());
        }
        if (cacheConfig.getTimeToLiveSeconds() == 0) {
            mapConfig.setTimeToLiveSeconds(15);
        } else {
            mapConfig.setTimeToLiveSeconds(cacheConfig.getTimeToLiveSeconds());
        }
        MaxSizeConfig maxSizeConfig = new MaxSizeConfig();
        maxSizeConfig.setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.USED_HEAP_PERCENTAGE);
        if (cacheConfig.getSize() == 0) {
            maxSizeConfig.setSize(70);
        } else {
            maxSizeConfig.setSize(cacheConfig.getSize());
        }
        mapConfig.setMaxSizeConfig(maxSizeConfig);
        return mapConfig;
    }
}

