/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.exception;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.exception.ActionExecutionException;
import com.flipkart.foxtrot.core.exception.ActionResolutionException;
import com.flipkart.foxtrot.core.exception.BadRequestException;
import com.flipkart.foxtrot.core.exception.CardinalityOverflowException;
import com.flipkart.foxtrot.core.exception.DataCleanupException;
import com.flipkart.foxtrot.core.exception.DocumentMissingException;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.exception.QueryCreationException;
import com.flipkart.foxtrot.core.exception.StoreConnectionException;
import com.flipkart.foxtrot.core.exception.StoreExecutionException;
import com.flipkart.foxtrot.core.exception.TableExistsException;
import com.flipkart.foxtrot.core.exception.TableInitializationException;
import com.flipkart.foxtrot.core.exception.TableMissingException;
import com.flipkart.foxtrot.core.exception.UnresolvableActionException;
import java.util.Collections;
import java.util.List;

public class FoxtrotExceptions {
    public static TableInitializationException createTableInitializationException(Table table, String message) {
        return new TableInitializationException(table.getName(), message);
    }

    public static TableMissingException createTableMissingException(String table) {
        return new TableMissingException(table);
    }

    public static StoreConnectionException createConnectionException(Table table, Exception e) {
        return new StoreConnectionException(table.getName(), (Throwable)e);
    }

    public static BadRequestException createBadRequestException(String table, String reason) {
        return FoxtrotExceptions.createBadRequestException(table, Collections.singletonList(reason));
    }

    public static BadRequestException createBadRequestException(String table, List<String> reasons) {
        return new BadRequestException(table, reasons);
    }

    public static BadRequestException createBadRequestException(Table table, Exception e) {
        return FoxtrotExceptions.createBadRequestException(table.getName(), e);
    }

    public static BadRequestException createBadRequestException(String table, Exception e) {
        return new BadRequestException(table, e);
    }

    public static MalformedQueryException createMalformedQueryException(ActionRequest actionRequest, List<String> reasons) {
        return new MalformedQueryException(actionRequest, reasons);
    }

    public static CardinalityOverflowException createCardinalityOverflow(ActionRequest actionRequest, String field, double probability) {
        return new CardinalityOverflowException(actionRequest, field, probability);
    }

    public static DocumentMissingException createMissingDocumentException(Table table, String id) {
        return new DocumentMissingException(table.getName(), Collections.singletonList(id));
    }

    public static DocumentMissingException createMissingDocumentsException(Table table, List<String> ids) {
        return new DocumentMissingException(table.getName(), ids);
    }

    public static StoreExecutionException createExecutionException(String table, Exception e) {
        return new StoreExecutionException(table, (Throwable)e);
    }

    public static ActionExecutionException createQueryExecutionException(ActionRequest actionRequest, Exception e) {
        return new ActionExecutionException(actionRequest, (Throwable)e);
    }

    public static TableExistsException createTableExistsException(String table) {
        return new TableExistsException(table);
    }

    public static DataCleanupException createDataCleanupException(String message, Exception e) {
        return new DataCleanupException(message, (Throwable)e);
    }

    public static QueryCreationException queryCreationException(ActionRequest actionRequest, Exception e) {
        return new QueryCreationException(actionRequest, (Throwable)e);
    }

    public static ActionResolutionException createActionResolutionException(ActionRequest actionRequest, Exception e) {
        return new ActionResolutionException(actionRequest, (Throwable)e);
    }

    public static UnresolvableActionException createUnresolvableActionException(ActionRequest actionRequest) {
        return new UnresolvableActionException(actionRequest);
    }
}

