/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.stats.BucketResponse;
import com.flipkart.foxtrot.common.stats.StatsRequest;
import com.flipkart.foxtrot.common.stats.StatsResponse;
import com.flipkart.foxtrot.common.stats.StatsValue;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;

@AnalyticsProvider(opcode="stats", request=StatsRequest.class, response=StatsResponse.class, cacheable=false)
public class StatsAction
extends Action<StatsRequest> {
    public StatsAction(StatsRequest parameter, TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection connection, String cacheToken, CacheManager cacheManager, ObjectMapper objectMapper) {
        super(parameter, tableMetadataManager, dataStore, queryStore, connection, cacheToken, cacheManager, objectMapper);
    }

    @Override
    protected void preprocess() {
        ((StatsRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((StatsRequest)this.getParameter()).getTable()));
    }

    @Override
    public String getMetricKey() {
        return ((StatsRequest)this.getParameter()).getTable();
    }

    @Override
    protected String getRequestCacheKey() {
        long statsHashKey = 0L;
        StatsRequest statsRequest = (StatsRequest)this.getParameter();
        if (null != statsRequest.getFilters()) {
            for (Filter filter : statsRequest.getFilters()) {
                statsHashKey += (long)(31 * filter.hashCode());
            }
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)statsRequest.getNesting())) {
            for (String nestingKey : statsRequest.getNesting()) {
                statsHashKey += (long)(31 * nestingKey.hashCode());
            }
        }
        return String.format("%s-%s-%d", statsRequest.getTable(), statsRequest.getField(), statsHashKey);
    }

    @Override
    public void validateImpl(StatsRequest parameter) throws MalformedQueryException {
        ArrayList validationErrors = Lists.newArrayList();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getField())) {
            validationErrors.add("field name cannot be null or empty");
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public ActionResponse execute(StatsRequest parameter) throws FoxtrotException {
        SearchRequestBuilder searchRequestBuilder;
        try {
            searchRequestBuilder = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setTypes(new String[]{"document"}).setIndicesOptions(Utils.indicesOptions()).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSize(0);
            AbstractAggregationBuilder percentiles = Utils.buildPercentileAggregation(((StatsRequest)this.getParameter()).getField());
            AbstractAggregationBuilder extendedStats = Utils.buildExtendedStatsAggregation(((StatsRequest)this.getParameter()).getField());
            searchRequestBuilder.addAggregation(percentiles);
            searchRequestBuilder.addAggregation(extendedStats);
            if (!CollectionUtils.isNullOrEmpty((Collection)((StatsRequest)this.getParameter()).getNesting())) {
                TermsBuilder rootBuilder = null;
                TermsBuilder termsBuilder = null;
                for (String field : ((StatsRequest)this.getParameter()).getNesting()) {
                    if (null == termsBuilder) {
                        termsBuilder = (TermsBuilder)AggregationBuilders.terms((String)Utils.sanitizeFieldForAggregation(field)).field(field);
                    } else {
                        TermsBuilder tempBuilder = (TermsBuilder)AggregationBuilders.terms((String)Utils.sanitizeFieldForAggregation(field)).field(field);
                        termsBuilder.subAggregation((AbstractAggregationBuilder)tempBuilder);
                        termsBuilder = tempBuilder;
                    }
                    termsBuilder.size(0);
                    if (null != rootBuilder) continue;
                    rootBuilder = termsBuilder;
                }
                termsBuilder.subAggregation(percentiles);
                termsBuilder.subAggregation(extendedStats);
                searchRequestBuilder.addAggregation(rootBuilder);
            }
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        try {
            Aggregations aggregations = ((SearchResponse)searchRequestBuilder.execute().actionGet(this.getGetQueryTimeout())).getAggregations();
            if (aggregations != null) {
                return this.buildResponse(parameter, aggregations);
            }
            return null;
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    private StatsResponse buildResponse(StatsRequest request, Aggregations aggregations) {
        StatsValue statsValue = StatsAction.buildStatsValue(request.getField(), aggregations);
        List<BucketResponse<StatsValue>> buckets = null;
        if (!CollectionUtils.isNullOrEmpty((Collection)request.getNesting())) {
            buckets = this.buildNestedStats(request.getNesting(), aggregations);
        }
        StatsResponse statsResponse = new StatsResponse();
        statsResponse.setResult(statsValue);
        statsResponse.setBuckets(buckets);
        return statsResponse;
    }

    private List<BucketResponse<StatsValue>> buildNestedStats(List<String> nesting, Aggregations aggregations) {
        String field = nesting.get(0);
        ArrayList<String> remainingFields = nesting.size() > 1 ? nesting.subList(1, nesting.size()) : new ArrayList<String>();
        Terms terms = (Terms)aggregations.get(Utils.sanitizeFieldForAggregation(field));
        ArrayList bucketResponses = Lists.newArrayList();
        for (Terms.Bucket bucket : terms.getBuckets()) {
            BucketResponse bucketResponse = new BucketResponse();
            bucketResponse.setKey(String.valueOf(bucket.getKey()));
            if (nesting.size() == 1) {
                bucketResponse.setResult((Object)StatsAction.buildStatsValue(((StatsRequest)this.getParameter()).getField(), bucket.getAggregations()));
            } else {
                bucketResponse.setBuckets(this.buildNestedStats(remainingFields, bucket.getAggregations()));
            }
            bucketResponses.add(bucketResponse);
        }
        return bucketResponses;
    }

    private static StatsValue buildStatsValue(String field, Aggregations aggregations) {
        String metricKey = Utils.getExtendedStatsAggregationKey(field);
        String percentileMetricKey = Utils.getPercentileAggregationKey(field);
        StatsValue statsValue = new StatsValue();
        InternalExtendedStats extendedStats = (InternalExtendedStats)InternalExtendedStats.class.cast(aggregations.getAsMap().get(metricKey));
        statsValue.setStats(Utils.createExtendedStatsResponse(extendedStats));
        Percentiles internalPercentile = (Percentiles)Percentiles.class.cast(aggregations.getAsMap().get(percentileMetricKey));
        statsValue.setPercentiles(Utils.createPercentilesResponse(internalPercentile));
        return statsValue;
    }
}

