/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.ActionResponse;
import com.flipkart.foxtrot.common.Period;
import com.flipkart.foxtrot.common.query.Filter;
import com.flipkart.foxtrot.common.query.datetime.LastFilter;
import com.flipkart.foxtrot.common.query.general.InFilter;
import com.flipkart.foxtrot.common.trend.TrendRequest;
import com.flipkart.foxtrot.common.trend.TrendResponse;
import com.flipkart.foxtrot.common.util.CollectionUtils;
import com.flipkart.foxtrot.core.cache.CacheManager;
import com.flipkart.foxtrot.core.common.Action;
import com.flipkart.foxtrot.core.datastore.DataStore;
import com.flipkart.foxtrot.core.exception.FoxtrotException;
import com.flipkart.foxtrot.core.exception.FoxtrotExceptions;
import com.flipkart.foxtrot.core.exception.MalformedQueryException;
import com.flipkart.foxtrot.core.querystore.QueryStore;
import com.flipkart.foxtrot.core.querystore.actions.Utils;
import com.flipkart.foxtrot.core.querystore.actions.spi.AnalyticsProvider;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConnection;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchUtils;
import com.flipkart.foxtrot.core.querystore.query.ElasticSearchQueryGenerator;
import com.flipkart.foxtrot.core.table.TableMetadataManager;
import com.google.common.collect.Lists;
import io.dropwizard.util.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.joda.time.DateTime;

@AnalyticsProvider(opcode="trend", request=TrendRequest.class, response=TrendResponse.class, cacheable=true)
public class TrendAction
extends Action<TrendRequest> {
    public TrendAction(TrendRequest parameter, TableMetadataManager tableMetadataManager, DataStore dataStore, QueryStore queryStore, ElasticsearchConnection connection, String cacheToken, CacheManager cacheManager, ObjectMapper objectMapper) {
        super(parameter, tableMetadataManager, dataStore, queryStore, connection, cacheToken, cacheManager, objectMapper);
    }

    @Override
    protected void preprocess() {
        ((TrendRequest)this.getParameter()).setTable(ElasticsearchUtils.getValidTableName(((TrendRequest)this.getParameter()).getTable()));
        if (null != ((TrendRequest)this.getParameter()).getValues() && ((TrendRequest)this.getParameter()).getValues().size() != 0) {
            List values = ((TrendRequest)this.getParameter()).getValues();
            InFilter filter = new InFilter(((TrendRequest)this.getParameter()).getField(), values);
            ((TrendRequest)this.getParameter()).getFilters().add(filter);
        }
    }

    @Override
    public String getMetricKey() {
        return ((TrendRequest)this.getParameter()).getTable();
    }

    @Override
    protected String getRequestCacheKey() {
        TrendRequest query = (TrendRequest)this.getParameter();
        long filterHashKey = 0L;
        if (query.getFilters() != null) {
            for (Filter filter : query.getFilters()) {
                filterHashKey += (long)(31 * filter.hashCode());
            }
        }
        if (query.getValues() != null) {
            for (String value : query.getValues()) {
                filterHashKey += (long)(31 * value.hashCode());
            }
        }
        if (null != query.getUniqueCountOn()) {
            filterHashKey += (long)(31 * query.getUniqueCountOn().hashCode());
        }
        filterHashKey += (long)(31 * query.getPeriod().name().hashCode());
        filterHashKey += (long)(31 * query.getTimestamp().hashCode());
        return String.format("%s-%s-%s-%d", query.getTable(), query.getField(), query.getPeriod(), filterHashKey += (long)(31 * (query.getField() != null ? query.getField().hashCode() : "FIELD".hashCode())));
    }

    @Override
    public void validateImpl(TrendRequest parameter) throws MalformedQueryException {
        ArrayList validationErrors = Lists.newArrayList();
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTable())) {
            validationErrors.add("table name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getField())) {
            validationErrors.add("field name cannot be null or empty");
        }
        if (CollectionUtils.isNullOrEmpty((String)parameter.getTimestamp())) {
            validationErrors.add("timestamp field cannot be null or empty");
        }
        if (parameter.getPeriod() == null) {
            validationErrors.add(String.format("specify time period (%s)", StringUtils.join((Object[])Period.values())));
        }
        if (parameter.getUniqueCountOn() != null && parameter.getUniqueCountOn().isEmpty()) {
            validationErrors.add("unique field cannot be empty (can be null)");
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)validationErrors)) {
            throw FoxtrotExceptions.createMalformedQueryException((ActionRequest)parameter, validationErrors);
        }
    }

    @Override
    public ActionResponse execute(TrendRequest parameter) throws FoxtrotException {
        SearchRequestBuilder searchRequestBuilder;
        try {
            AbstractAggregationBuilder aggregationBuilder = this.buildAggregation(parameter);
            searchRequestBuilder = this.getConnection().getClient().prepareSearch(ElasticsearchUtils.getIndices(parameter.getTable(), (ActionRequest)parameter)).setIndicesOptions(Utils.indicesOptions()).setQuery(new ElasticSearchQueryGenerator().genFilter(parameter.getFilters())).setSize(0).addAggregation(aggregationBuilder);
        }
        catch (Exception e) {
            throw FoxtrotExceptions.queryCreationException((ActionRequest)parameter, e);
        }
        try {
            SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet(this.getGetQueryTimeout());
            Aggregations aggregations = searchResponse.getAggregations();
            if (aggregations != null) {
                return this.buildResponse(parameter, aggregations);
            }
            return new TrendResponse(Collections.emptyMap());
        }
        catch (ElasticsearchException e) {
            throw FoxtrotExceptions.createQueryExecutionException((ActionRequest)parameter, (Exception)((Object)e));
        }
    }

    @Override
    protected Filter getDefaultTimeSpan() {
        LastFilter lastFilter = new LastFilter();
        lastFilter.setField("_timestamp");
        lastFilter.setDuration(Duration.days((long)1L));
        return lastFilter;
    }

    private AbstractAggregationBuilder buildAggregation(TrendRequest request) {
        DateHistogramInterval interval = Utils.getHistogramInterval(request.getPeriod());
        String field = request.getField();
        DateHistogramBuilder histogramBuilder = Utils.buildDateHistogramAggregation(request.getTimestamp(), interval);
        if (!CollectionUtils.isNullOrEmpty((String)((TrendRequest)this.getParameter()).getUniqueCountOn())) {
            histogramBuilder.subAggregation((AbstractAggregationBuilder)Utils.buildCardinalityAggregation(((TrendRequest)this.getParameter()).getUniqueCountOn()));
        }
        return ((TermsBuilder)AggregationBuilders.terms((String)Utils.sanitizeFieldForAggregation(field)).field(field)).size(0).subAggregation((AbstractAggregationBuilder)histogramBuilder);
    }

    private TrendResponse buildResponse(TrendRequest request, Aggregations aggregations) {
        String field = request.getField();
        TreeMap<String, ArrayList> trendCounts = new TreeMap<String, ArrayList>();
        Terms terms = (Terms)aggregations.get(Utils.sanitizeFieldForAggregation(field));
        for (Terms.Bucket bucket : terms.getBuckets()) {
            String key = String.valueOf(bucket.getKey());
            ArrayList counts = Lists.newArrayList();
            Aggregations subAggregations = bucket.getAggregations();
            Histogram histogram = (Histogram)subAggregations.get(Utils.getDateHistogramKey(request.getTimestamp()));
            for (Histogram.Bucket histogramBucket : histogram.getBuckets()) {
                if (!CollectionUtils.isNullOrEmpty((String)((TrendRequest)this.getParameter()).getUniqueCountOn())) {
                    String uniqueCountKey = Utils.sanitizeFieldForAggregation(((TrendRequest)this.getParameter()).getUniqueCountOn());
                    Cardinality cardinality = (Cardinality)histogramBucket.getAggregations().get(uniqueCountKey);
                    counts.add(new TrendResponse.Count((Number)((DateTime)histogramBucket.getKey()).getMillis(), cardinality.getValue()));
                    continue;
                }
                counts.add(new TrendResponse.Count((Number)((DateTime)histogramBucket.getKey()).getMillis(), histogramBucket.getDocCount()));
            }
            trendCounts.put(key, counts);
        }
        return new TrendResponse(trendCounts);
    }
}

