/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.actions;

import com.flipkart.foxtrot.common.Period;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.joda.time.DateTimeZone;

public class Utils {
    public static AbstractAggregationBuilder buildExtendedStatsAggregation(String field) {
        String metricKey = Utils.getExtendedStatsAggregationKey(field);
        return AggregationBuilders.extendedStats((String)metricKey).field(field);
    }

    public static AbstractAggregationBuilder buildPercentileAggregation(String field) {
        String metricKey = Utils.getPercentileAggregationKey(field);
        return AggregationBuilders.percentiles((String)metricKey).field(field);
    }

    public static DateHistogramBuilder buildDateHistogramAggregation(String field, DateHistogramInterval interval) {
        String metricKey = Utils.getDateHistogramKey(field);
        return ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)metricKey).minDocCount(0L).field(field)).timeZone(DateTimeZone.getDefault().getID()).interval(interval);
    }

    public static CardinalityBuilder buildCardinalityAggregation(String field) {
        return (CardinalityBuilder)AggregationBuilders.cardinality((String)Utils.sanitizeFieldForAggregation(field)).precisionThreshold(500L).field(field);
    }

    public static String sanitizeFieldForAggregation(String field) {
        return field.replaceAll("[^a-zA-Z0-9\\-_]", "_");
    }

    public static DateHistogramInterval getHistogramInterval(Period period) {
        DateHistogramInterval interval;
        switch (period) {
            case seconds: {
                interval = DateHistogramInterval.SECOND;
                break;
            }
            case minutes: {
                interval = DateHistogramInterval.MINUTE;
                break;
            }
            case hours: {
                interval = DateHistogramInterval.HOUR;
                break;
            }
            case days: {
                interval = DateHistogramInterval.DAY;
                break;
            }
            default: {
                interval = DateHistogramInterval.HOUR;
            }
        }
        return interval;
    }

    public static String getExtendedStatsAggregationKey(String field) {
        return Utils.sanitizeFieldForAggregation(field) + "_extended_stats";
    }

    public static String getPercentileAggregationKey(String field) {
        return Utils.sanitizeFieldForAggregation(field) + "_percentile";
    }

    public static String getDateHistogramKey(String field) {
        return Utils.sanitizeFieldForAggregation(field) + "_date_histogram";
    }

    public static IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public static Map<String, Number> createExtendedStatsResponse(InternalExtendedStats extendedStats) {
        HashMap stats = Maps.newHashMap();
        stats.put("avg", extendedStats.getAvg());
        stats.put("sum", extendedStats.getSum());
        stats.put("count", extendedStats.getCount());
        stats.put("min", extendedStats.getMin());
        stats.put("max", extendedStats.getMax());
        stats.put("sum_of_squares", extendedStats.getSumOfSquares());
        stats.put("variance", extendedStats.getVariance());
        stats.put("std_deviation", extendedStats.getStdDeviation());
        return stats;
    }

    public static Map<Number, Number> createPercentilesResponse(Percentiles internalPercentiles) {
        HashMap percentiles = Maps.newHashMap();
        for (Percentile percentile : internalPercentiles) {
            percentiles.put(percentile.getPercent(), percentile.getValue());
        }
        return percentiles;
    }

    public static double ensurePositive(long number) {
        return (double)number <= 0.0 ? 0.0 : (double)number;
    }

    public static double ensureOne(long number) {
        return number <= 0L ? 1.0 : (double)number;
    }
}

