/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.flipkart.foxtrot.common.ActionRequest;
import com.flipkart.foxtrot.common.Table;
import com.flipkart.foxtrot.core.common.PeriodSelector;
import com.flipkart.foxtrot.core.querystore.impl.ElasticsearchConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)ElasticsearchUtils.class.getSimpleName());
    private static String TABLENAME_PREFIX = "foxtrot";
    public static final String DOCUMENT_TYPE_NAME = "document";
    public static final String DOCUMENT_META_TYPE_NAME = "metadata";
    public static final String DOCUMENT_META_FIELD_NAME = "__FOXTROT_METADATA__";
    public static final String DOCUMENT_META_ID_FIELD_NAME = String.format("%s.id", "__FOXTROT_METADATA__");
    public static final String TABLENAME_POSTFIX = "table";
    public static final String TIME_FIELD = "time";
    public static final int DEFAULT_SUB_LIST_SIZE = 50;
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"dd-M-yyyy");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"dd-M-yyyy");

    public static void setTableNamePrefix(ElasticsearchConfig config) {
        TABLENAME_PREFIX = config.getTableNamePrefix();
    }

    public static String getIndexPrefix(String table) {
        return String.format("%s-%s-%s-", TABLENAME_PREFIX, table, TABLENAME_POSTFIX);
    }

    public static String getIndices(String table) {
        return String.format("%s-%s-%s-*", TABLENAME_PREFIX, table, TABLENAME_POSTFIX);
    }

    public static String[] getIndices(String table, ActionRequest request) throws Exception {
        return ElasticsearchUtils.getIndices(table, request, new PeriodSelector(request.getFilters()).analyze());
    }

    @VisibleForTesting
    public static String[] getIndices(String table, ActionRequest request, Interval interval) {
        DateTime start = interval.getStart().toLocalDate().toDateTimeAtStartOfDay();
        if (start.getYear() <= 1970) {
            logger.warn("Request of type {} running on all indices", (Object)request.getClass().getSimpleName());
            return new String[]{ElasticsearchUtils.getIndices(table)};
        }
        ArrayList indices = Lists.newArrayList();
        DateTime end = interval.getEnd().plusDays(1).toLocalDate().toDateTimeAtStartOfDay();
        while (start.getMillis() < end.getMillis()) {
            String index = ElasticsearchUtils.getCurrentIndex(table, start.getMillis());
            indices.add(index);
            start = start.plusDays(1);
        }
        logger.info("Request of type {} on indices: {}", (Object)request.getClass().getSimpleName(), (Object)indices);
        return indices.toArray(new String[indices.size()]);
    }

    public static String getCurrentIndex(String table, long timestamp) {
        String datePostfix = FORMATTER.print(timestamp);
        return String.format("%s-%s-%s-%s", TABLENAME_PREFIX, table, TABLENAME_POSTFIX, datePostfix);
    }

    public static PutIndexTemplateRequest getClusterTemplateMapping() {
        try {
            return new PutIndexTemplateRequest().name("template_foxtrot_mappings").template(String.format("%s-*", TABLENAME_PREFIX)).mapping(DOCUMENT_TYPE_NAME, ElasticsearchUtils.getDocumentMapping());
        }
        catch (IOException ex) {
            logger.error("TEMPLATE_CREATION_FAILED", (Throwable)ex);
            return null;
        }
    }

    public static XContentBuilder getDocumentMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().field(DOCUMENT_TYPE_NAME).startObject().field("_source").startObject().field("enabled", false).endObject().field("_all").startObject().field("enabled", false).endObject().field("_timestamp").startObject().field("enabled", true).endObject().field("dynamic_templates").startArray().startObject().field("template_metadata_fields").startObject().field("path_match", "__FOXTROT_METADATA__.*").field("mapping").startObject().field("store", true).field("doc_values", true).field("index", "not_analyzed").field("fielddata").startObject().field("format", "doc_values").endObject().endObject().endObject().endObject().startObject().field("template_timestamp").startObject().field("match", "timestamp").field("mapping").startObject().field("store", false).field("index", "not_analyzed").field("fielddata").startObject().field("format", "doc_values").endObject().field("type", "date").endObject().endObject().endObject().startObject().field("template_no_store_analyzed").startObject().field("match", "*").field("match_mapping_type", "string").field("mapping").startObject().field("store", false).field("index", "not_analyzed").field("fielddata").startObject().field("format", "doc_values").endObject().field("fields").startObject().field("analyzed").startObject().field("store", false).field("type", "string").field("index", "analyzed").endObject().endObject().endObject().endObject().endObject().startObject().field("template_no_store").startObject().field("match_mapping_type", "date|boolean|double|long|integer").field("match_pattern", "regex").field("path_match", ".*").field("mapping").startObject().field("store", false).field("index", "not_analyzed").field("fielddata").startObject().field("format", "doc_values").endObject().endObject().endObject().endObject().endArray().field("properties").startObject().field(TIME_FIELD).startObject().field("type", "long").field("fields").startObject().field("date").startObject().field("index", "not_analyzed").field("store", true).field("type", "date").field("format", "epoch_millis").endObject().endObject().field("fielddata").startObject().field("format", "doc_values").endObject().endObject().endObject().endObject().endObject();
    }

    public static void initializeMappings(Client client) {
        PutIndexTemplateRequest templateRequest = ElasticsearchUtils.getClusterTemplateMapping();
        client.admin().indices().putTemplate(templateRequest).actionGet();
    }

    public static String getValidTableName(String table) {
        if (table == null) {
            return null;
        }
        return table.trim().toLowerCase();
    }

    public static boolean isIndexValidForTable(String index, String table) {
        String indexPrefix = ElasticsearchUtils.getIndexPrefix(table);
        return index.startsWith(indexPrefix);
    }

    public static boolean isIndexEligibleForDeletion(String index, Table table) {
        if (index == null || table == null || !ElasticsearchUtils.isIndexValidForTable(index, table.getName())) {
            return false;
        }
        DateTime creationDate = ElasticsearchUtils.parseIndexDate(index, table.getName());
        DateTime startTime = new DateTime(0L);
        DateTime endTime = new DateTime().minusDays(table.getTtl()).toDateMidnight().toDateTime();
        return creationDate.isAfter((ReadableInstant)startTime) && creationDate.isBefore((ReadableInstant)endTime);
    }

    public static DateTime parseIndexDate(String index, String table) {
        String indexPrefix = ElasticsearchUtils.getIndexPrefix(table);
        String creationDateString = index.substring(index.indexOf(indexPrefix) + indexPrefix.length());
        return DATE_TIME_FORMATTER.parseDateTime(creationDateString);
    }

    public static String getTableNameFromIndex(String currentIndex) {
        if (currentIndex.contains(TABLENAME_PREFIX) && currentIndex.contains(TABLENAME_POSTFIX)) {
            String tempIndex = currentIndex.substring(currentIndex.indexOf(TABLENAME_PREFIX) + TABLENAME_PREFIX.length() + 1);
            int position = tempIndex.lastIndexOf(String.format("-%s", TABLENAME_POSTFIX));
            return tempIndex.substring(0, position);
        }
        return null;
    }

    public static String getAllIndicesPattern() {
        return String.format("%s-*-%s-*", TABLENAME_PREFIX, TABLENAME_POSTFIX);
    }
}

