/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.foxtrot.core.querystore.impl;

import com.flipkart.foxtrot.core.querystore.impl.AwsClusterDiscoveryConfig;
import com.flipkart.foxtrot.core.querystore.impl.ClusterConfig;
import com.flipkart.foxtrot.core.querystore.impl.MarathonClusterDiscoveryConfig;
import com.flipkart.foxtrot.core.querystore.impl.SimpleClusterDiscoveryConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastProperty;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.marathon.hazelcast.servicediscovery.MarathonDiscoveryStrategyFactory;
import io.dropwizard.lifecycle.Managed;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastConnection
implements Managed {
    private static final Logger logger = LoggerFactory.getLogger((String)HazelcastConnection.class.getSimpleName());
    private HazelcastInstance hazelcast;
    private Config hazelcastConfig;

    public HazelcastConnection(ClusterConfig clusterConfig) throws Exception {
        Config hzConfig = new Config();
        hzConfig.getGroupConfig().setName(clusterConfig.getName());
        switch (clusterConfig.getDiscovery().getType()) {
            case foxtrot_simple: {
                String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                hzConfig.setInstanceName(String.format("foxtrot-%s-%d", hostName, System.currentTimeMillis()));
                SimpleClusterDiscoveryConfig simpleClusterDiscoveryConfig = (SimpleClusterDiscoveryConfig)clusterConfig.getDiscovery();
                if (!simpleClusterDiscoveryConfig.isDisableMulticast()) break;
                hzConfig.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
                for (String member : simpleClusterDiscoveryConfig.getMembers()) {
                    hzConfig.getNetworkConfig().getJoin().getTcpIpConfig().addMember(member);
                }
                hzConfig.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
                break;
            }
            case foxtrot_marathon: {
                MarathonClusterDiscoveryConfig marathonClusterDiscoveryConfig = (MarathonClusterDiscoveryConfig)clusterConfig.getDiscovery();
                String appId = marathonClusterDiscoveryConfig.getApp().replace("/", "").trim();
                hzConfig.getGroupConfig().setName("foxtrot");
                hzConfig.getGroupConfig().setPassword("foxtrot");
                hzConfig.setProperty((HazelcastProperty)GroupProperty.DISCOVERY_SPI_ENABLED, "true");
                hzConfig.setProperty((HazelcastProperty)GroupProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED, "true");
                hzConfig.setProperty((HazelcastProperty)GroupProperty.SOCKET_CLIENT_BIND_ANY, "true");
                hzConfig.setProperty((HazelcastProperty)GroupProperty.SOCKET_BIND_ANY, "true");
                NetworkConfig networkConfig = hzConfig.getNetworkConfig();
                networkConfig.setPublicAddress(System.getenv("HOST") + ":" + System.getenv("PORT_5701"));
                JoinConfig joinConfig = networkConfig.getJoin();
                joinConfig.getTcpIpConfig().setEnabled(false);
                joinConfig.getMulticastConfig().setEnabled(false);
                joinConfig.getAwsConfig().setEnabled(false);
                DiscoveryConfig discoveryConfig = joinConfig.getDiscoveryConfig();
                DiscoveryStrategyConfig discoveryStrategyConfig = new DiscoveryStrategyConfig((DiscoveryStrategyFactory)new MarathonDiscoveryStrategyFactory());
                discoveryStrategyConfig.addProperty("marathon-endpoint", (Comparable)((Object)marathonClusterDiscoveryConfig.getEndpoint()));
                discoveryStrategyConfig.addProperty("app-id", (Comparable)((Object)appId));
                discoveryStrategyConfig.addProperty("port-index", (Comparable)((Object)marathonClusterDiscoveryConfig.getPortIndex()));
                discoveryConfig.addDiscoveryStrategyConfig(discoveryStrategyConfig);
                break;
            }
            case foxtrot_aws: {
                AwsClusterDiscoveryConfig awsClusterDiscoveryConfig = (AwsClusterDiscoveryConfig)clusterConfig.getDiscovery();
                NetworkConfig hazelcastConfigNetworkConfig = hzConfig.getNetworkConfig();
                JoinConfig hazelcastConfigNetworkConfigJoin = hazelcastConfigNetworkConfig.getJoin();
                hazelcastConfigNetworkConfigJoin.getTcpIpConfig().setEnabled(false);
                hazelcastConfigNetworkConfigJoin.getMulticastConfig().setEnabled(false);
                AwsConfig awsConfig = new AwsConfig();
                awsConfig.setAccessKey(awsClusterDiscoveryConfig.getAccessKey());
                awsConfig.setConnectionTimeoutSeconds(awsClusterDiscoveryConfig.getConnectionTimeoutSeconds());
                awsConfig.setHostHeader(awsClusterDiscoveryConfig.getHostHeader());
                awsConfig.setIamRole(awsClusterDiscoveryConfig.getIamRole());
                awsConfig.setRegion(awsClusterDiscoveryConfig.getRegion());
                awsConfig.setSecurityGroupName(awsClusterDiscoveryConfig.getSecurityGroupName());
                awsConfig.setSecretKey(awsClusterDiscoveryConfig.getSecretKey());
                awsConfig.setTagKey(awsClusterDiscoveryConfig.getTagKey());
                awsConfig.setTagValue(awsClusterDiscoveryConfig.getTagValue());
                hazelcastConfigNetworkConfigJoin.setAwsConfig(awsConfig);
                hazelcastConfigNetworkConfigJoin.getAwsConfig().setEnabled(true);
            }
            default: {
                logger.warn("Invalid discovery config");
            }
        }
        this.hazelcastConfig = hzConfig;
    }

    public void start() throws Exception {
        logger.info("Starting Hazelcast Instance");
        this.hazelcast = Hazelcast.newHazelcastInstance((Config)this.hazelcastConfig);
        logger.info("Started Hazelcast Instance");
    }

    public void stop() throws Exception {
        this.hazelcast.shutdown();
    }

    public HazelcastInstance getHazelcast() {
        return this.hazelcast;
    }

    public Config getHazelcastConfig() {
        return this.hazelcastConfig;
    }
}

