/*
 * Decompiled with CFR 0.152.
 */
package com.foxtrot.flipkart.translator;

import com.collections.CollectionUtils;
import com.flipkart.foxtrot.common.Document;
import com.foxtrot.flipkart.translator.config.SegregationConfiguration;
import com.foxtrot.flipkart.translator.config.TableSegregationConfig;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTranslator {
    private static final Logger log = LoggerFactory.getLogger(TableTranslator.class);
    private static final String EVENT_TYPE = "eventType";
    private final Map<String, TableSegregationConfig> tableVsSegregationConfig = Maps.newHashMap();
    private final Map<String, String> eventTypeVsNewTable = Maps.newHashMap();

    @Inject
    public TableTranslator(SegregationConfiguration segregationConfiguration) {
        if (segregationConfiguration != null) {
            segregationConfiguration.getTableSegregationConfigs().forEach(tableSegregationConfig -> {
                this.tableVsSegregationConfig.putIfAbsent(tableSegregationConfig.getOldTable(), (TableSegregationConfig)tableSegregationConfig);
                tableSegregationConfig.getNewTableVsEventTypes().forEach((newTable, eventTypes) -> {
                    if (CollectionUtils.isNotEmpty((Collection)eventTypes)) {
                        eventTypes.forEach(s -> this.eventTypeVsNewTable.putIfAbsent((String)s, (String)newTable));
                    }
                });
            });
        }
    }

    public String getTable(String table, Document document) {
        if (!this.isTransformableTable(table)) {
            return table;
        }
        if (document.getData().has(EVENT_TYPE)) {
            String eventType = document.getData().get(EVENT_TYPE).asText();
            return this.getSegregatedTableName(table, eventType);
        }
        return table;
    }

    public boolean isTransformableTable(String table) {
        return this.tableVsSegregationConfig.get(table) != null;
    }

    private String getSegregatedTableName(String table, String eventType) {
        return this.eventTypeVsNewTable.getOrDefault(eventType, table);
    }
}

