/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.NamespaceRegistry;
import com.franz.agbase.impl.TriplesIteratorImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGConnInternals;
import java.io.IOException;
import java.util.prefs.Preferences;

public class AllegroGraphConnection
extends AGConnInternals {
    private Process agp;

    public static NamespaceRegistry getInitialNamespaceRegistry() {
        return initialns.promote();
    }

    public static void setInitialNamespaceRegistry(NamespaceRegistry ns) {
        initialns = new NamespaceRegistry(ns);
    }

    public static int getDefaultPollCount() {
        return defaultPollCount;
    }

    public static int getDefaultPollInterval() {
        return defaultPollInterval;
    }

    public int getPollCount() {
        return this.pollCount;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public static void setDefaultPolling(int count, int interval) {
        if (count > 0) {
            defaultPollCount = count;
        }
        if (interval > 0) {
            defaultPollInterval = interval;
        }
    }

    public void setPolling(int count, int interval) {
        if (count >= 0) {
            int n = this.pollCount = count > 0 ? count : defaultPollCount;
        }
        if (interval >= 0) {
            this.pollInterval = interval > 0 ? interval : defaultPollInterval;
        }
    }

    protected AGConnector getAgc(AllegroGraphConnection ags) {
        return ags.agc;
    }

    public static String getDefaultMode() {
        return defaultMode;
    }

    public String getMode() {
        return this.mode;
    }

    public static int getDefaultPort() {
        return defaultPort;
    }

    public static void setDefaultPort(int port) {
        defaultPort = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public static int getDefaultPort2() {
        return defaultPort2;
    }

    public static void setDefaultPort2(int port) {
        defaultPort2 = port;
    }

    public int getPort2() {
        return this.port2;
    }

    public void setPort2(int p) {
        this.port2 = p;
    }

    public static String getDefaultHost() {
        return defaultHost;
    }

    public static void setDefaultHost(String host) {
        defaultHost = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String newhost) {
        this.host = newhost;
    }

    public static int getDefaultDebug() {
        return defaultDebug;
    }

    public static void setDefaultDebug(int db) {
        defaultDebug = db;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int db) {
        this.debug = db;
    }

    public static String getDefaultCommand() {
        return defaultLispCommand;
    }

    public static void setDefaultCommand(String cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        defaultLispCommand = cmd;
    }

    public String getCommand() {
        return this.lispCommand;
    }

    public void setCommand(String cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("command cannot be null");
        }
        this.lispCommand = cmd;
    }

    public static boolean getDefaultServerKeep() {
        return defaultServerKeep;
    }

    public void setDefaultServerKeep(boolean v) {
        defaultServerKeep = v;
    }

    public boolean getServerKeep() {
        return this.keep;
    }

    public void setServerKeep(boolean v) {
        this.keep = v;
    }

    public boolean enable() throws IOException, AllegroGraphException {
        if (this.agc == null) {
            this.agc = AGConnector.createConnector(this.mode);
        } else if (-1 < this.agc.query()) {
            return false;
        }
        this.agc.init(this.port, this.port2, this.host, this.pollCount, this.pollInterval, this.debug, this.timeout);
        this.agc.enable();
        if (this.debug > 0) {
            this.serverTrace(true);
        }
        Object v = null;
        int db = 0;
        Object w = null;
        try {
            w = this.agc.serverOptionOne("client-debug", "");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (v != null) {
            db = AGConnector.toInt(w);
        }
        int l = 0;
        try {
            w = this.agc.serverOptionOne("client-batch", "");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (w != null) {
            l = AGConnector.toInt(w);
        }
        if (l > 0) {
            TriplesIteratorImpl.defaultLookAhead = l;
        }
        int pr = 0;
        try {
            w = this.agc.serverOptionOne("server-level", 9);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (w != null) {
            pr = AGConnector.toInt(w);
        }
        if (pr < 7) {
            throw new AllegroGraphException("AllegroGraph server is out of date: " + pr + "<" + 7);
        }
        if (pr > 7) {
            throw new AllegroGraphException("Library agraph.jar is out of date: " + pr + ">" + 7);
        }
        try {
            this.agc.serverOptionOne("client-level", 7);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.debugMask = db | 0x40000000;
        this.serverId = this.agc.serverId();
        if (this.serverId < 101L) {
            throw new AllegroGraphException("AllegroGraph server is out of date serverId: " + this.serverId);
        }
        this.freshState();
        return true;
    }

    public int interrupt() throws AllegroGraphException, IOException {
        long id = this.serverId;
        if (id < 0L) {
            return -10;
        }
        if (id == 0L) {
            return -9;
        }
        if (id < 101L) {
            return -8;
        }
        if (!this.isEnabled()) {
            return -7;
        }
        int r = 0;
        if (this.isBusy()) {
            AllegroGraphConnection temp = new AllegroGraphConnection();
            temp.setHost(this.getHost());
            temp.setPort(this.getPort());
            temp.enable();
            r = temp.agc.interruptServer(id);
            temp.disable(false);
        }
        return r;
    }

    public void disable() {
        this.disable(true);
    }

    public synchronized void disable(boolean close) {
        if (this.agc == null) {
            return;
        }
        Object[] all = this.arrayOfTS();
        if (close) {
            for (int i = 0; i < all.length; ++i) {
                AGBase s = (AGBase)all[i];
                if (s.tsx < 0) continue;
                try {
                    this.agc.closeTripleStore(s, true);
                    s.tsx = -1;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.agc != null && -1 < this.agc.query()) {
            this.agc.disable();
        }
        this.reset();
    }

    protected void finalize() throws AllegroGraphException, IOException {
        this.disable(true);
        if (!this.keep) {
            this.stopServer();
        }
    }

    public boolean isEnabled() {
        if (this.agc == null) {
            return false;
        }
        return -1 < this.agc.query();
    }

    public boolean isBusy() {
        if (this.agc == null) {
            return false;
        }
        return 0 < this.agc.query();
    }

    public AllegroGraph create(String name, String directory) throws AllegroGraphException {
        return new AllegroGraph(this, "create", name, directory);
    }

    public AllegroGraph create(AllegroGraph ag) throws AllegroGraphException {
        ag.connect(this, "create");
        return ag;
    }

    public AllegroGraph open(String name, String directory) throws AllegroGraphException {
        return new AllegroGraph(this, "open", name, directory);
    }

    public AllegroGraph open(AllegroGraph ag) throws AllegroGraphException {
        ag.connect(this, "open");
        return ag;
    }

    public boolean exists(String name, String directory) throws AllegroGraphException {
        return this.getServer().exists(name, directory);
    }

    public AllegroGraph access(String name, String directory) throws AllegroGraphException {
        return new AllegroGraph(this, "access", name, directory);
    }

    public AllegroGraph access(AllegroGraph ag) throws AllegroGraphException {
        ag.connect(this, "access");
        return ag;
    }

    public AllegroGraph renew(String name, String directory) throws AllegroGraphException {
        return new AllegroGraph(this, "renew", name, directory);
    }

    public AllegroGraph renew(AllegroGraph ag) throws AllegroGraphException {
        ag.connect(this, "renew");
        return ag;
    }

    public AllegroGraph replace(String name, String directory) throws AllegroGraphException {
        return new AllegroGraph(this, "replace", name, directory);
    }

    public AllegroGraph replace(AllegroGraph ag) throws AllegroGraphException {
        ag.connect(this, "replace");
        return ag;
    }

    public long getChunkSize() throws AllegroGraphException {
        Object w = this.getServer().serverOptionOne("chunk-size", -1);
        if (w != null) {
            return AGConnector.longValue(w);
        }
        throw new AllegroGraphException("Cannot get chunk size.");
    }

    public void setChunkSize(long s) throws AllegroGraphException {
        if (s < 1L) {
            throw new IllegalArgumentException("ChunkSize must be positive.");
        }
        this.getServer().serverOptionOne("chunk-size", s);
    }

    public long getChunkCountWarningLimit() throws AllegroGraphException {
        Object w = this.getServer().serverOptionOne("chunk-limit", -1);
        if (w != null) {
            return AGConnector.longValue(w);
        }
        throw new AllegroGraphException("Cannot get chunk count warning limit.");
    }

    public void setChunkCountWarningLimit(long s) throws AllegroGraphException {
        if (s < 1L) {
            throw new IllegalArgumentException("Chunk count warning limit must be positive.");
        }
        this.getServer().serverOptionOne("chunk-limit", s);
    }

    public long getDefaultExpectedResources() throws AllegroGraphException {
        Object w = this.getServer().serverOptionOne("expected", -1);
        if (w != null) {
            return AGConnector.longValue(w);
        }
        throw new AllegroGraphException("Cannot get expected resource number.");
    }

    public void setDefaultExpectedResources(long s) throws AllegroGraphException {
        if (s < 1L) {
            throw new IllegalArgumentException("ExpectedResources must be positive.");
        }
        this.getServer().serverOptionOne("expected", s);
    }

    public Object[] evalInServer(String expression) throws AllegroGraphException {
        return this.getServer().evalInServer(expression);
    }

    public int serverTrace(boolean onoff) {
        try {
            this.getServer().serverTrace(onoff, null);
            return 0;
        }
        catch (AllegroGraphException e) {
            return -1;
        }
    }

    public boolean serverLevel(int level) throws AllegroGraphException {
        return this.getServer().serverLevel(level);
    }

    public String getServerVersion() throws AllegroGraphException {
        return this.getServer().getVersion();
    }

    public int serverTrace(String outFile) {
        try {
            this.getServer().serverTrace(true, outFile);
            return 0;
        }
        catch (AllegroGraphException e) {
            return -1;
        }
    }

    public void serverTimers(boolean onOff, boolean perStore) throws AllegroGraphException {
        this.getServer().serverTimers(null, onOff, perStore);
    }

    public long[] getTimers() throws AllegroGraphException {
        return this.getServer().getTimers(null);
    }

    public String[] getNamespaces() {
        if (this.nsregs == null) {
            return null;
        }
        return this.nsregs.toArray();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        if (null == this.nsregs) {
            return null;
        }
        return new NamespaceRegistry(this.nsregs);
    }

    private NamespaceRegistry nsregsInit() {
        if (this.nsregs != null) {
            return this.nsregs;
        }
        if (initialns == null) {
            throw new IllegalStateException("The default NamespaceRegistry is suppressed in this instance of AllegroGraphConnection");
        }
        this.nsregs = new NamespaceRegistry(initialns);
        return this.nsregs;
    }

    public void registerNamespace(String prefix, String full) {
        this.nsregsInit().register(prefix, full);
    }

    public void registerNamespaces(String[] defs) {
        this.nsregsInit();
        for (int i = 0; i < defs.length; i += 2) {
            this.nsregs.register(defs[i], defs[i + 1]);
        }
    }

    public void registerNamespaces(com.franz.ag.NamespaceRegistry ns) {
        this.nsregsInit().register(ns);
    }

    public void setNamespaceRegistry(NamespaceRegistry ns) {
        this.nsregs = ns == null ? null : new NamespaceRegistry(ns);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "<" + this.serverId + " " + this.mode + ">";
    }

    public void startServer() throws IOException {
        this.startServer(null);
    }

    public void startServer(String log) throws IOException {
        if (this.lispCommand == null) {
            this.lispCommand = "";
        }
        String c = System.getProperty("com.franz.ag.exec", this.lispCommand);
        if ("".equals(this.lispCommand)) {
            this.lispCommand = c;
        }
        if (" ".equals(this.lispCommand)) {
            Preferences ag;
            Preferences p;
            if (c.equals("")) {
                p = Preferences.userRoot();
                ag = p.node("franz.com/allegrograph/java");
                c = ag.get("lispcommand", "");
            }
            if (c.equals("")) {
                p = Preferences.systemRoot();
                ag = p.node("franz.com/allegrograph/java");
                c = ag.get("lispcommand", "");
            }
            defaultLispCommand = c;
            this.lispCommand = c;
        }
        if (this.agp != null) {
            throw new IllegalStateException("Already started");
        }
        if (null == this.lispCommand || "".equals(this.lispCommand) || " ".equals(this.lispCommand)) {
            throw new IllegalStateException("ACL command must be set");
        }
        String options1 = "";
        String options2 = "";
        if (log != null) {
            options1 = "--log-file";
            options2 = log;
        }
        String[] cmd = new String[]{this.lispCommand, "--port", "" + this.port, options1, options2};
        if (this.debug > 0) {
            String m = "";
            for (int i = 0; i < cmd.length; ++i) {
                m = m + " " + cmd[i];
            }
            System.out.println("startServer command:" + m);
        }
        this.agp = Runtime.getRuntime().exec(cmd);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public int stopServer() throws IOException {
        return this.stopServer(false);
    }

    public int stopServer(boolean killNotStarted) throws IOException {
        int rc = 0;
        if (this.debug > 0) {
            System.out.println("stopServer: " + this.agp + " " + this.agc);
        }
        if (this.agp == null && !killNotStarted) {
            return -1;
        }
        if (this.agc == null) {
            try {
                if (this.debug > 0) {
                    System.out.println("stopServer calling enable");
                }
                boolean en = this.enable();
                if (this.debug > 0) {
                    System.out.println("stopServer enable returned " + en);
                }
            }
            catch (Exception e) {
                if (this.debug > 0) {
                    System.out.println("connect " + e);
                }
                this.agc = null;
                ++rc;
            }
        }
        if (this.agc != null) {
            if (0 > this.agc.query()) {
                if (this.debug > 0) {
                    System.out.println("stopServer calling re-enable");
                }
                this.agc.enable();
            }
            if (-1 < this.agc.query()) {
                Object rv;
                if (this.debug > 0) {
                    System.out.println("stopServer calling stop-agj-application");
                }
                String r = "";
                try {
                    rv = this.agc.serverOptionOne("stop-app", "");
                }
                catch (Exception e) {
                    rv = "ERROR: " + e;
                    ++rc;
                }
                if (rv instanceof String) {
                    r = (String)rv;
                } else if (null != rv) {
                    r = "ERROR: odd type " + rv;
                    ++rc;
                }
                if (this.debug > 0) {
                    System.out.println("stopServer stop-agj-ap => " + r);
                }
                if (this.debug > 0) {
                    System.out.println("stopServer calling disable");
                }
                this.disable();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {}
            } else if (this.debug > 0) {
                System.out.println("stopServer re-enable failed");
            }
        }
        if (this.agp != null) {
            if (this.debug > 0) {
                System.out.println("stopServer calling destroy");
            }
            this.agp.destroy();
            try {
                this.agp.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return rc;
    }

    public static void main(String[] args) {
        String sys = "";
        String usr = "";
        for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            if (string.equalsIgnoreCase("-system")) {
                sys = args[++i];
                continue;
            }
            if (!string.equalsIgnoreCase("-user")) continue;
            usr = args[++i];
        }
        Preferences ps = Preferences.systemRoot();
        Preferences ags = ps.node("franz.com/allegrograph/java");
        String agcs = ags.get("lispcommand", "");
        String pms = "System value of franz.com/allegrograph/java/lispcommand";
        if (agcs.equals("")) {
            System.out.println("Current " + pms + " is unset.");
        } else {
            System.out.println("Current " + pms + " is " + agcs);
        }
        Preferences pu = Preferences.userRoot();
        Preferences agu = pu.node("franz.com/allegrograph/java");
        String agcu = agu.get("lispcommand", "");
        String pmu = "User value of franz.com/allegrograph/java/lispcommand";
        if (agcu.equals("")) {
            System.out.println("Current " + pmu + " is unset.");
        } else {
            System.out.println("Current " + pmu + " is " + agcu);
        }
        if (!sys.equals("")) {
            ags.put("lispcommand", sys);
            System.out.println("Modified " + pms + " to " + sys);
        }
        if (!usr.equals("")) {
            agu.put("lispcommand", usr);
            System.out.println("Modified " + pmu + " to " + usr);
        }
    }

    public AllegroGraph federate(String name, AllegroGraph[] parts, boolean supersede) throws AllegroGraphException {
        return new AllegroGraph(this, name, parts, supersede);
    }

    public AllegroGraph findStore(String name) throws AllegroGraphException {
        return new AllegroGraph(this, name, null);
    }

    public AllegroGraph findStore(String name, String directory) throws AllegroGraphException {
        return new AllegroGraph(this, name, directory);
    }

    public void deleteStore(String name) throws AllegroGraphException {
        this.deleteStore(name, null);
    }

    public void deleteStore(String name, String directory) throws AllegroGraphException {
        this.getServer().findStore(name, directory, "delete");
    }

    public static int getDefaultTimeout() {
        return defaultTimeout;
    }

    public static void setDefaultTimeout(int defaultTimeout) {
        AllegroGraphConnection.defaultTimeout = defaultTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public long getDefaultSPOGICacheSize() throws AllegroGraphException {
        Object v = AllegroGraphConnection.serverOption(this, "spogi-cache-size", -1);
        return AGConnector.longValue(v);
    }

    public void setDefaultSPOGICacheSize(long size) throws AllegroGraphException {
        AllegroGraphConnection.serverOption(this, "spogi-cache-size", size);
    }

    public String[] getPrologFunctors() throws AllegroGraphException {
        return (String[])AllegroGraphConnection.serverOption(this, "prolog", "functors");
    }

    public String[] getPrologFunctors(String regExp) throws AllegroGraphException {
        return (String[])AllegroGraphConnection.serverOption(this, "prolog", "functors", regExp);
    }

    public String[] getPrologRules() throws AllegroGraphException {
        return (String[])AllegroGraphConnection.serverOption(this, "prolog", "rules");
    }

    public String getPrologRules(String functorName) throws AllegroGraphException {
        return (String)AllegroGraphConnection.serverOption(this, "prolog", "rules", functorName);
    }

    public String[] getPrologRules(String[] functorNames) throws AllegroGraphException {
        return (String[])AllegroGraphConnection.serverOption(this, "prolog", "rules", functorNames);
    }

    public void addPrologRule(String ruleInString) throws AllegroGraphException {
        AllegroGraphConnection.serverOption(this, "prolog", "add", ruleInString);
    }

    public void addPrologFile(String nameOfFile) throws AllegroGraphException {
        AllegroGraphConnection.serverOption(this, "prolog", "add", "file", nameOfFile);
    }

    public void addPrologRules(String[] arrayOfRules) throws AllegroGraphException {
        AllegroGraphConnection.serverOption(this, "prolog", "add", arrayOfRules);
    }

    public String reportMemoryUsage(String to, String tempDir) throws AllegroGraphException {
        return (String)AllegroGraphConnection.serverOption(this, "memory", to, tempDir);
    }
}

