/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.ag.UPI;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.GeospatialSubtype;
import com.franz.agbase.impl.GeospatialSubtypeImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGInternals;

public class Polygon {
    private AGInternals pag = null;
    private double[] points;
    private int i = 0;
    private UPI subject = null;
    private boolean modified = true;
    private GeospatialSubtypeImpl subtype;

    public GeospatialSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(GeospatialSubtype subtype2) {
        this.modified = true;
        this.subtype = (GeospatialSubtypeImpl)subtype2;
    }

    public double[] getPoints() {
        return (double[])this.points.clone();
    }

    public boolean getModified() {
        return this.modified;
    }

    public UPI getSubject() {
        return this.subject;
    }

    public void setSubject(UPI subject) {
        this.modified = true;
        this.subject = subject;
    }

    public Polygon(int vertices) {
        this.points = new double[2 * vertices];
    }

    public void addVertex(double x, double y) {
        this.modified = true;
        this.points[this.i] = x;
        ++this.i;
        this.points[this.i] = y;
        ++this.i;
    }

    public UPI add(AllegroGraph ag) throws AllegroGraphException {
        if (this.pag != null) {
            throw new IllegalStateException("Already added to store " + this.pag);
        }
        if (this.i < this.points.length) {
            throw new IllegalStateException("Incomplete Polygon");
        }
        if (null == this.subtype) {
            throw new IllegalStateException("Cannot add Polygon without a subtype");
        }
        this.pag = ag;
        Object[] v = ag.verifyEnabled().applyAGFn(this.pag, "ag-add-polygon", new Object[]{this.subject, new Long(this.subtype.getLocal(ag.ags)), this.points});
        this.subject = (UPI)v[0];
        this.modified = false;
        return this.subject;
    }

    public void get(AllegroGraph ag) throws AllegroGraphException {
        if (null == this.subject) {
            throw new IllegalStateException("Cannot locate Polygon with null subject");
        }
        this.pag = ag;
        Object[] v = ag.verifyEnabled().applyAGFn(this.pag, "ag-get-polygon", new Object[]{this.subject});
        this.points = (double[])v[0];
        this.i = this.points.length;
        this.modified = false;
    }

    public boolean pointInside(double x, double y) throws AllegroGraphException {
        Object[] v = this.pag.verifyEnabled().applyAGFn(this.pag, "ag-points-inside-poly", new Object[]{this.points, new Double(x), new Double(y)});
        return 1L == AGConnector.longValue(v[0]);
    }

    public boolean[] pointsInside(double[] xy) throws AllegroGraphException {
        Object[] v = this.pag.verifyEnabled().applyAGFn(this.pag, "ag-points-inside-poly", new Object[]{this.points, xy});
        long[] w = AGConnector.longArray(v[0]);
        boolean[] r = new boolean[w.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = 1L == w[i];
        }
        return r;
    }

    public boolean[] pointsInside(double[] x, double[] y) throws AllegroGraphException {
        Object[] v = this.pag.verifyEnabled().applyAGFn(this.pag, "ag-points-inside-poly", new Object[]{this.points, x, y});
        long[] w = AGConnector.longArray(v[0]);
        boolean[] r = new boolean[w.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = 1L == w[i];
        }
        return r;
    }
}

