/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.ValueSetIterator;
import com.franz.agbase.impl.NamedAttributeList;
import com.franz.agbase.impl.ValueSetIteratorImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.QueryBase;
import java.util.ArrayList;

public class PrologSelectQuery
extends QueryBase {
    private boolean distinct = false;
    private ArrayList<String> invars = null;
    private ArrayList<Object> invals = null;
    private ValueSetIteratorImpl result = null;
    private String template = "()";
    private String[] vars = null;
    private Object planToken;
    private NamedAttributeList queryAttributes = new NamedAttributeList(queryOptions);
    private static final String REORDER = "reorder";
    private static final String USE_MAPS = "use-maps";
    private static final String USE_TRANSFORMS = "use-transforms";
    private static final String REMOVE_RTF = "remove-redundant-type-filters";
    private static final String LIMIT = "limit";
    private static final String COUNT_ONLY = "count-only";
    private static final String PLAN_TOKEN = "plan-token";
    private static final String PLAN_ACTION = "plan-action";
    private static final String PLAN_ACTION_SAVE = "save";
    private static final String PLAN_ACTION_PLAN = "plan";
    private static final String PLAN_ACTION_SHOW = "show";
    private static final String PLAN_ACTION_RUN = "run";
    private static final String TEMPLATE = "template";
    private static final String HASVALUE = "has-value";
    protected static final Object[] queryOptions = new Object[]{"reorder", Boolean.class, "use-maps", Boolean.class, "use-transforms", Boolean.class, "remove-redundant-type-filters", Boolean.class, "plan-token", String.class, "plan-action", String.class, "template", String.class, "count-only", Boolean.class, "limit", Long.class, "has-value", Boolean.class};

    private String listToString(ArrayList<String> a) {
        if (a == null) {
            return null;
        }
        String r = "";
        for (String s : a) {
            if (0 != s.indexOf("?")) {
                s = "?" + s;
            }
            r = r + " " + s;
        }
        return r;
    }

    private void freshState(boolean keepPlan) {
        this.result = null;
        if (!keepPlan) {
            this.planToken = null;
        }
    }

    public void bind(String var, Object val) {
        int i;
        if (var == null) {
            if (val != null) {
                throw new IllegalArgumentException("When var name is null, value must also be null.");
            }
            this.invars = null;
            this.invals = null;
            return;
        }
        if (this.invars == null) {
            if (val == null) {
                return;
            }
            this.invars = new ArrayList();
            this.invals = new ArrayList();
        }
        if ((i = this.invars.indexOf(var)) < 0) {
            if (val == null) {
                return;
            }
            this.freshState(false);
            this.invars.add(var);
            this.invals.add(val);
        } else {
            this.freshState(true);
            if (val == null) {
                this.invars.remove(i);
                this.invals.remove(i);
                if (0 == this.invars.size()) {
                    this.invars = null;
                    this.invals = null;
                    return;
                }
            }
            this.invars.set(i, var);
            this.invals.set(i, val);
        }
    }

    @Override
    public boolean isIncludeInferred() {
        return super.isIncludeInferred();
    }

    @Override
    public void setIncludeInferred(boolean includeInferred) {
        this.freshState(false);
        super.setIncludeInferred(includeInferred);
    }

    public int getHasValue() {
        Object v = this.queryAttributes.getAttribute(HASVALUE);
        if (v == null) {
            return -1;
        }
        if (((Boolean)v).booleanValue()) {
            return 1;
        }
        return 0;
    }

    public void setHasValue(boolean v) {
        this.freshState(false);
        this.queryAttributes.setAttribute(HASVALUE, new Boolean(v));
    }

    @Override
    public AGBase getTripleStore() {
        return super.getTripleStore();
    }

    @Override
    public String getQuery() {
        return super.getQuery();
    }

    @Override
    public void setQuery(String newQuery) {
        this.freshState(false);
        super.setQuery(newQuery);
    }

    public void setQuery(String[] vars, String query) {
        this.setVariables(vars);
        this.setQuery(query);
    }

    @Override
    public void setTripleStore(AllegroGraph ag) {
        this.freshState(false);
        super.setTripleStore(ag);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean onoff) {
        this.freshState(false);
        this.distinct = onoff;
    }

    public long getLimit() {
        Object v = this.queryAttributes.getAttribute(LIMIT);
        if (v == null) {
            return 0L;
        }
        return (Long)v;
    }

    public void setLimit(long limit) {
        this.queryAttributes.setAttribute(LIMIT, limit < 1L ? null : Long.valueOf(limit));
    }

    public String[] getVariables() {
        return (String[])this.vars.clone();
    }

    public void setVariables(String[] vars) {
        this.freshState(false);
        this.vars = (String[])vars.clone();
        this.template = "(";
        block4: for (int i = 0; i < vars.length; ++i) {
            int p = vars[i].indexOf("?");
            switch (p) {
                case -1: {
                    this.template = this.template + " ?" + vars[i];
                    continue block4;
                }
                case 0: {
                    this.template = this.template + " " + vars[i];
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Ill-formed variable " + vars[i]);
                }
            }
        }
        this.template = this.template + ")";
    }

    public void setVariables(String vars) {
        this.setVariables(vars.split("\\s+", 0));
    }

    public ValueSetIterator run() throws AllegroGraphException {
        this.runBody(null);
        return this.result;
    }

    public ValueSetIterator getResult() {
        return this.result;
    }

    public ValueSetIterator run(AllegroGraph ag) throws AllegroGraphException {
        this.validate(ag);
        return this.run();
    }

    public ValueSetIterator run(String[] vars, String newQuery) throws AllegroGraphException {
        this.setVariables(vars);
        super.setQuery(newQuery);
        return this.run();
    }

    public ValueSetIterator run(AllegroGraph ag, String[] vars, String newQuery) throws AllegroGraphException {
        this.setVariables(vars);
        super.setQuery(newQuery);
        this.validate(ag);
        return this.run();
    }

    private void setRunOptions(String action) {
        this.queryAttributes.setAttribute(PLAN_TOKEN, null);
        this.queryAttributes.setAttribute(PLAN_ACTION, action);
    }

    public Boolean isReorder() throws AllegroGraphException {
        return this.isPlannerOption(REORDER);
    }

    public void setReorder(Boolean reorder) {
        this.freshState(false);
        this.queryAttributes.setAttribute(REORDER, reorder);
    }

    public Boolean isUseMaps() throws AllegroGraphException {
        return this.isPlannerOption(USE_MAPS);
    }

    public void setUseMaps(Boolean useMaps) {
        this.freshState(false);
        this.queryAttributes.setAttribute(USE_MAPS, useMaps);
    }

    public Boolean isUseTransforms() throws AllegroGraphException {
        return this.isPlannerOption(USE_TRANSFORMS);
    }

    public void setUseTransforms(Boolean useTransforms) {
        this.freshState(false);
        this.queryAttributes.setAttribute(USE_TRANSFORMS, useTransforms);
    }

    public Boolean isRemoveRTF() throws AllegroGraphException {
        return this.isPlannerOption(REMOVE_RTF);
    }

    Boolean isPlannerOption(String option) throws AllegroGraphException {
        Object v = this.queryAttributes.getAttribute(option);
        if (v != null) {
            return (Boolean)v;
        }
        if (this.ag == null) {
            return null;
        }
        Object[] d = ((AllegroGraph)this.ag).getConnection().selectPlannerOptions;
        if (d == null) {
            d = ((AllegroGraph)this.ag).verifyEnabled().clientOption(this.ag, "select-planner-options");
            if (d == null) {
                return null;
            }
            ((AllegroGraph)this.ag).getConnection().selectPlannerOptions = d;
        }
        v = this;
        for (int i = 0; i < d.length; i += 2) {
            String opt;
            if (v != this || !option.equalsIgnoreCase(opt = (String)d[i])) continue;
            v = d[i + 1];
        }
        if (v == this) {
            return null;
        }
        if (v == null) {
            return false;
        }
        return true;
    }

    public void setRemoveRTF(Boolean removeRTF) {
        this.freshState(false);
        this.queryAttributes.setAttribute(REMOVE_RTF, removeRTF);
    }

    public boolean runAndSavePlan() throws AllegroGraphException {
        this.runBody(PLAN_ACTION_SAVE);
        return this.isSavedPlan();
    }

    private void runBody(String action) throws AllegroGraphException {
        if (this.vars == null) {
            throw new IllegalStateException("Cannot run without query variables.");
        }
        this.validate(this.ag);
        boolean level12 = ((AllegroGraph)this.ag).ags.serverLevel(12);
        if (level12) {
            this.queryAttributes.setAttribute(TEMPLATE, this.template);
        }
        this.setRunOptions(action);
        Object[] more = this.queryAttributes.getList();
        this.setRunOptions(null);
        this.queryAttributes.setAttribute(TEMPLATE, null);
        if (more != null && 0 < more.length && !level12) {
            throw new UnsupportedOperationException("This version of the AllegroGraph server does not support planner options.");
        }
        Object[] rv = this.ag.verifyEnabled().selectValues(this.ag, level12 ? this.query : this.template + this.query, this.invals == null ? null : this.invals.toArray(), this.listToString(this.invars), this.includeInferred, this.distinct, more);
        this.result = new ValueSetIteratorImpl(this.ag, rv);
        this.result.savedExtra = this.vars;
        if (rv != null && 9 < rv.length) {
            this.planToken = rv[9];
        }
    }

    public long count() throws AllegroGraphException {
        this.validate(this.ag);
        boolean level16 = ((AllegroGraph)this.ag).ags.serverLevel(16);
        if (!level16) {
            throw new UnsupportedOperationException("This version of the AllegroGraph server does not support the count option.");
        }
        this.queryAttributes.setAttribute(TEMPLATE, this.template);
        this.setRunOptions(null);
        this.queryAttributes.setAttribute(COUNT_ONLY, true);
        Object[] more = this.queryAttributes.getList();
        this.setRunOptions(null);
        this.queryAttributes.setAttribute(TEMPLATE, null);
        this.queryAttributes.setAttribute(COUNT_ONLY, null);
        Object[] rv = this.ag.verifyEnabled().selectValues(this.ag, this.query, this.invals == null ? null : this.invals.toArray(), this.listToString(this.invars), this.includeInferred, this.distinct, more);
        return AGConnector.longValue(rv[0]);
    }

    public long count(AllegroGraph ag) throws AllegroGraphException {
        this.validate(ag);
        return this.count();
    }

    public long count(String[] vars, String newQuery) throws AllegroGraphException {
        this.freshState(false);
        if (null != vars) {
            this.setVariables(vars);
        }
        super.setQuery(newQuery);
        return this.count();
    }

    public long count(AllegroGraph ag, String[] vars, String newQuery) throws AllegroGraphException {
        this.freshState(false);
        if (null != vars) {
            this.setVariables(vars);
        }
        super.setQuery(newQuery);
        this.validate(ag);
        return this.count();
    }

    public boolean isSavedPlan() {
        return null != this.planToken;
    }

    public String showPlan() throws AllegroGraphException {
        boolean level12 = ((AllegroGraph)this.ag).ags.serverLevel(12);
        if (!level12) {
            throw new UnsupportedOperationException("This version of the AllegroGraph server does not support planner options.");
        }
        if (!this.isSavedPlan()) {
            throw new IllegalStateException("Cannot run without a plan.");
        }
        this.setRunOptions(PLAN_ACTION_SHOW);
        this.queryAttributes.setAttribute(PLAN_TOKEN, this.planToken);
        Object[] more = this.queryAttributes.getList();
        this.setRunOptions(null);
        this.queryAttributes.setAttribute(TEMPLATE, null);
        Object[] rv = this.ag.verifyEnabled().selectValues(this.ag, null, this.invals == null ? null : this.invals.toArray(), this.listToString(this.invars), this.includeInferred, this.distinct, more);
        if (rv != null && 9 < rv.length) {
            return (String)rv[9];
        }
        return "";
    }

    public boolean preparePlan() throws AllegroGraphException {
        boolean level12 = ((AllegroGraph)this.ag).ags.serverLevel(12);
        if (!level12) {
            throw new UnsupportedOperationException("This version of the AllegroGraph server does not support planner options.");
        }
        if (this.vars == null) {
            throw new IllegalStateException("Cannot run without query variables.");
        }
        this.validate(this.ag);
        this.setRunOptions(PLAN_ACTION_PLAN);
        this.queryAttributes.setAttribute(TEMPLATE, this.template);
        Object[] more = this.queryAttributes.getList();
        this.setRunOptions(null);
        this.queryAttributes.setAttribute(TEMPLATE, null);
        Object[] rv = this.ag.verifyEnabled().selectValues(this.ag, level12 ? this.query : this.template + this.query, this.invals == null ? null : this.invals.toArray(), this.listToString(this.invars), this.includeInferred, this.distinct, more);
        if (rv != null && 9 < rv.length) {
            this.planToken = rv[9];
        }
        return this.isSavedPlan();
    }

    public ValueSetIterator runPlan() throws AllegroGraphException {
        boolean level12 = ((AllegroGraph)this.ag).ags.serverLevel(12);
        if (!level12) {
            throw new UnsupportedOperationException("This version of the AllegroGraph server does not support planner options.");
        }
        if (!this.isSavedPlan()) {
            throw new IllegalStateException("Cannot run without a plan.");
        }
        this.setRunOptions(PLAN_ACTION_RUN);
        this.queryAttributes.setAttribute(PLAN_TOKEN, this.planToken);
        Object[] more = this.queryAttributes.getList();
        this.setRunOptions(null);
        this.queryAttributes.setAttribute(TEMPLATE, null);
        Object[] rv = this.ag.verifyEnabled().selectValues(this.ag, null, this.invals == null ? null : this.invals.toArray(), this.listToString(this.invars), this.includeInferred, this.distinct, more);
        this.result = new ValueSetIteratorImpl(this.ag, rv);
        this.result.savedExtra = this.vars;
        return this.result;
    }
}

