/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.UPI;
import com.franz.agbase.transport.AGConnector;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class SNAExtension {
    private AllegroGraph ag = null;

    SNAExtension(AllegroGraph ag) {
        this.ag = ag;
    }

    public void copyGeneratorsFrom(SNAExtension from) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-copy-generators", new Object[]{new Integer(from.ag.tsx)});
    }

    private UPI[] getUPIArray(Object[] v) {
        if (null == v) {
            return new UPI[0];
        }
        if (0 == v.length) {
            return new UPI[0];
        }
        return AGConnector.toUPIArray(v[0]);
    }

    public void registerGenerator(String name, Object[] parts) throws AllegroGraphException {
        if (null == parts) {
            this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-generator", new Object[0]);
            return;
        }
        if (0 == parts.length) {
            return;
        }
        Object part = parts[0];
        ArrayList<Object> decoded = new ArrayList<Object>();
        decoded.add(name);
        if (part instanceof String) {
            this.decodePart(parts, decoded);
        } else if (part instanceof Object[]) {
            for (int i = 0; i < parts.length; ++i) {
                this.decodePart((Object[])parts[i], decoded);
            }
        } else {
            throw new IllegalArgumentException("Generator parts array is not well-formed.");
        }
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-generator", decoded.toArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodePart(Object[] part, ArrayList<Object> decoded) {
        if (part == null) {
            return;
        }
        decoded.add(new Integer(part.length));
        boolean refParts = false;
        for (int i = 0; i < part.length; ++i) {
            Object item = part[i];
            if (0 == i) {
                if (!(item instanceof String)) {
                    throw new IllegalArgumentException("First item in generator part must be a string.");
                }
                String key = (String)item;
                if ("objects-of".equalsIgnoreCase(key) || "subjects-of".equalsIgnoreCase(key) || "undirected".equalsIgnoreCase(key)) {
                    refParts = true;
                } else {
                    if (!"select".equalsIgnoreCase(key)) throw new IllegalArgumentException("Unknown generator part " + key);
                    refParts = false;
                }
            } else if (refParts) {
                item = this.ag.validRef(item);
            }
            decoded.add(item);
        }
    }

    public UPI[] breadthFirstSearch(Object start, Object end, String generator, int depth) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-breadth-first-search", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, new Integer(depth)}));
    }

    public void mapBreadthFirstSearch(Object start, Object end, String generator, String fn, int depth) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-breadth-first-map", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, fn, new Integer(depth)});
    }

    private UPI[][] toPathArray(Object[] w) {
        Object w0 = w[0];
        if (w0 == null) {
            return new UPI[0][0];
        }
        if (!(w0 instanceof UPI[])) {
            if (w0.getClass().isArray()) {
                if (AGConnector.hasLongValue(w0 = Array.get(w0, 0)) && 0L == AGConnector.longValue(w0)) {
                    return new UPI[0][0];
                }
                throw new IllegalStateException("Unexpected path array " + w0);
            }
            throw new IllegalStateException("Unexpected path array " + w0);
        }
        Object[] v = (Object[])w0;
        int len = (int)AGConnector.longValue(v[0]);
        UPI[][] r = new UPI[len][];
        int row = 0;
        int i = 1;
        while (i < v.length) {
            int width = (int)AGConnector.longValue(v[i]);
            ++i;
            UPI[] p = new UPI[width];
            for (int j = 0; j < width; ++j) {
                p[j] = (UPI)v[i];
                ++i;
            }
            r[row] = p;
            ++row;
        }
        return r;
    }

    public UPI[][] allBreadthFirstSearchPaths(Object start, Object end, String generator, int depth) throws AllegroGraphException {
        return this.toPathArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-breadth-first-all", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, new Integer(depth)}));
    }

    public UPI[] depthFirstSearch(Object start, Object end, String generator, int depth) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-depth-first-search", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, new Integer(depth)}));
    }

    public void mapDepthFirstSearch(Object start, Object end, String generator, String fn, int depth) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-depth-first-map", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, fn, new Integer(depth)});
    }

    public UPI[][] allDepthFirstSearchPaths(Object start, Object end, String generator, int depth) throws AllegroGraphException {
        return this.toPathArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-depth-first-all", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, new Integer(depth)}));
    }

    public UPI[] bidirectionalSearch(Object start, Object end, String generator, int depth) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-bidirectional-search", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, new Integer(depth)}));
    }

    public void mapBidirectionalSearch(Object start, Object end, String generator, String fn, int depth) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-bidirectional-map", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, fn, new Integer(depth)});
    }

    public UPI[][] allBidirectionalSearchPaths(Object start, Object end, String generator, int depth) throws AllegroGraphException {
        return this.toPathArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-bidirectional-all", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator, new Integer(depth)}));
    }

    public void mapBreadthFirstSearchPathsBipartite(Object start, Object end, String generator1, String generator2, String fn, int depth) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-breadth-first-bipartite", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator1, generator2, fn, new Integer(depth)});
    }

    public void mapDepthFirstSearchPathsBipartite(Object start, Object end, String generator1, String generator2, String fn, int depth) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-depth-first-bipartite", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator1, generator2, fn, new Integer(depth)});
    }

    public void mapBidirectionalSearchPathsBipartite(Object start, Object end, String generator1, String generator2, String fn, int depth) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-bidirectional-bipartite", new Object[]{this.ag.validRef(start), this.ag.validRef(end), generator1, generator2, fn, new Integer(depth)});
    }

    public UPI[] getNodalNeighbors(Object node, String generator) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-nodal-neighbors", new Object[]{this.ag.validRef(node), generator}));
    }

    public long getNodalDegree(Object node, String generator) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-nodal-degree", new Object[]{this.ag.validRef(node), generator});
        if (v == null) {
            return 0L;
        }
        if (0 == v.length) {
            return 0L;
        }
        return AGConnector.longValue(v[0]);
    }

    public UPI[] getEgoGroup(Object node, String generator, int depth) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-ego-group", new Object[]{this.ag.validRef(node), new Integer(depth), generator}));
    }

    public double getDensity(Object subgraph, String generator) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-density", new Object[]{this.ag.validRefs(subgraph), generator});
        if (v == null) {
            return 0.0;
        }
        if (0 == v.length) {
            return 0.0;
        }
        return AGConnector.doubleValue(v[0]);
    }

    public double getDegreeCentrality(Object actor, Object group, String generator) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-degree-centrality", new Object[]{this.ag.validRef(actor, null), this.ag.validRefs(group), generator});
        if (v == null) {
            return 0.0;
        }
        if (0 == v.length) {
            return 0.0;
        }
        return AGConnector.doubleValue(v[0]);
    }

    public double getClosenessCentrality(Object actor, Object group, String generator) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-closeness-centrality", new Object[]{this.ag.validRef(actor, null), this.ag.validRefs(group), generator});
        if (v == null) {
            return 0.0;
        }
        if (0 == v.length) {
            return 0.0;
        }
        return AGConnector.doubleValue(v[0]);
    }

    public double getBetweennessCentrality(Object actor, Object group, String generator) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-betweenness-centrality", new Object[]{this.ag.validRef(actor, null), this.ag.validRefs(group), generator});
        if (v == null) {
            return 0.0;
        }
        if (0 == v.length) {
            return 0.0;
        }
        return AGConnector.doubleValue(v[0]);
    }

    public boolean isClique(Object subgraph, String generator) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-is-clique", new Object[]{this.ag.validRefs(subgraph), generator});
        if (null == v) {
            return false;
        }
        if (0 == v.length) {
            return false;
        }
        return null != v[0];
    }

    public UPI[][] getCliques(Object node, String generator, int minSize) throws AllegroGraphException {
        return this.toPathArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-cliques", new Object[]{this.ag.validRef(node), generator, new Integer(minSize)}));
    }

    public void mapCliques(Object node, String generator, String fn, int minSize) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-map-cliques", new Object[]{this.ag.validRef(node), generator, fn, new Integer(minSize)});
    }
}

