/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import java.util.ArrayList;

public class NamedAttributeList {
    Object[] attributeDefs;
    Object[] attributeStates;
    ArrayList<Object> attributeList = new ArrayList();

    public NamedAttributeList(Object[] defs) {
        this.attributeDefs = defs;
        this.attributeStates = new Object[this.attributeDefs.length];
        for (int i = 0; i < this.attributeStates.length; ++i) {
            this.attributeStates[i] = null;
        }
    }

    int attributeIndex(String name) {
        int index = -1;
        for (int i = 0; i < this.attributeDefs.length; i += 2) {
            if (!name.equalsIgnoreCase((String)this.attributeDefs[i])) continue;
            index = i;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Not an attribute name: " + name);
        }
        return index;
    }

    public Object getAttribute(String name) {
        return this.attributeStates[this.attributeIndex(name) + 1];
    }

    boolean queryAttribute(String name) {
        return null != this.attributeStates[this.attributeIndex(name)];
    }

    public synchronized void setAttribute(String name, Object value) {
        int index = this.attributeIndex(name);
        Class<?> vclass = null;
        if (value != null) {
            vclass = value.getClass();
        }
        if (vclass != null && vclass != this.attributeDefs[index + 1]) {
            throw new IllegalArgumentException("Value of attribute " + name + " is not of class " + ((Class)this.attributeDefs[index + 1]).getName() + ": " + value);
        }
        boolean found = false;
        for (int i = 0; i < this.attributeList.size(); i += 2) {
            if (!name.equalsIgnoreCase((String)this.attributeList.get(i))) continue;
            this.attributeList.set(i + 1, value);
            found = true;
            break;
        }
        if (!found) {
            this.attributeList.add(name);
            this.attributeList.add(value);
        }
        this.attributeStates[index] = "";
        this.attributeStates[index + 1] = value;
    }

    public Object[] getList() {
        return this.attributeList.toArray();
    }
}

