/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.ValueNode;
import com.franz.agbase.ValueObject;
import com.franz.agbase.impl.TripleImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGInternals;

public class TriplesIteratorImpl
implements TriplesIterator {
    public static int defaultLookAhead = 1000;
    static final long NO_VALUE = -1L;
    private AllegroGraph ag;
    private Object source;
    int lookAhead = defaultLookAhead;
    long id = -1L;
    UPIImpl s = null;
    UPIImpl p = null;
    UPIImpl o = null;
    UPIImpl c = null;
    String sVal = null;
    int sType = 0;
    String sMod = null;
    String pVal = null;
    int pType = 0;
    String pMod = null;
    String oVal = null;
    int oType = 0;
    String oMod = null;
    String cVal = null;
    int cType = 0;
    String cMod = null;
    boolean nextp = false;
    boolean truncated = false;
    int cacheIndex = -1;
    UPI[] cache = null;
    static final int CACHE_CYCLE = 5;
    int[] cTypes = null;
    String[] cVals = null;
    String[] cMods = null;
    boolean withParts;
    public static final TriplesIterator emptyCursor = new TriplesIteratorImpl(null, null);

    public static int getDefaultLookAhead() {
        return defaultLookAhead;
    }

    public static void setDefaultLookAhead(int lh) {
        defaultLookAhead = lh < 1 ? 1000 : lh;
    }

    @Override
    public int getLookAhead() {
        return this.lookAhead;
    }

    @Override
    public void setLookAhead(int lh) {
        this.lookAhead = lh < 1 ? defaultLookAhead : lh;
    }

    public AllegroGraph getAG() {
        return this.ag;
    }

    public Object getSource() {
        return this.source;
    }

    public AGInternals getStore() {
        return this.ag;
    }

    public static TriplesIterator emptyCursor() {
        return emptyCursor;
    }

    static int initLookAhead(AGInternals rts) {
        if (rts == null) {
            return 0;
        }
        if (0 == rts.defaultLookAhead) {
            return defaultLookAhead;
        }
        return rts.defaultLookAhead;
    }

    TriplesIteratorImpl(AllegroGraph rts, Object cursor) {
        this.lookAhead = TriplesIteratorImpl.initLookAhead(rts);
        this.source = cursor;
        this.ag = rts;
        this.withParts = false;
    }

    TriplesIteratorImpl(AllegroGraph rts, Object cursor, UPIImpl[] newts) {
        this.lookAhead = TriplesIteratorImpl.initLookAhead(rts);
        this.source = cursor;
        this.ag = rts;
        this.setCache((UPI[])newts, true);
        this.withParts = false;
    }

    TriplesIteratorImpl(AllegroGraph rts, Object cursor, UPIImpl[] newts, String[] newdefs) {
        this.lookAhead = TriplesIteratorImpl.initLookAhead(rts);
        this.source = cursor;
        this.ag = rts;
        this.setCache((UPI[])newts, newdefs);
        this.withParts = true;
    }

    void setCache(UPI[] newts, boolean setNext) {
        if (setNext) {
            this.cacheIndex = -1;
        }
        if (newts == null) {
            if (setNext) {
                this.nextp = false;
            }
            return;
        }
        this.cacheIndex = -1;
        this.cTypes = null;
        this.cVals = null;
        this.cMods = null;
        if (0 == newts.length) {
            if (setNext) {
                this.nextp = false;
            }
            return;
        }
        if (1 == newts.length) {
            if (0L < ((UPIImpl)newts[0]).getCode()) {
                this.nextp = true;
            }
            return;
        }
        this.cache = (UPI[])newts.clone();
        this.cacheIndex = 0;
        this.nextp = true;
    }

    void setCache(UPI[] newts, String[] newdefs) {
        this.cacheIndex = -1;
        this.cTypes = null;
        this.cVals = null;
        this.cMods = null;
        if (0 == newts.length) {
            this.nextp = false;
            return;
        }
        if (1 == newts.length) {
            this.cacheIndex = 0;
            if (0L < ((UPIImpl)newts[0]).getCode()) {
                this.nextp = true;
            }
            return;
        }
        this.cache = (UPI[])newts.clone();
        this.cacheIndex = 0;
        this.nextp = true;
        int clen = this.cache.length;
        this.cTypes = new int[clen];
        this.cVals = new String[clen];
        this.cMods = new String[clen];
        int sx = 0;
        int cy = 0;
        for (int i = 0; i < clen; ++i) {
            UPI ce = this.cache[i];
            long cen = ((UPIImpl)ce).getCode();
            if (((UPIImpl)ce).getUpi() == null && cen < 0L) {
                int cx = i + (int)cen;
                this.cache[i] = this.cache[cx];
                this.cTypes[i] = this.cTypes[cx];
                this.cVals[i] = this.cVals[cx];
                this.cMods[i] = this.cMods[cx];
            } else {
                switch (cy) {
                    case 0: {
                        this.cTypes[i] = 6;
                        this.cVals[i] = null;
                        this.cMods[i] = null;
                        break;
                    }
                    default: {
                        sx = TriplesIteratorImpl.decodeDef(newdefs, sx, i, this.cTypes, this.cVals, this.cMods);
                    }
                }
            }
            if (cy == 4) {
                cy = 0;
                continue;
            }
            ++cy;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int decodeDef(String[] defs, int sx, int i, int[] types, String[] vals, String[] mods) {
        String def = defs[sx];
        int dl = def.length();
        if (!def.startsWith("%") || dl < 2) {
            throw new IllegalArgumentException("Ill-formed node ref(a) " + def);
        }
        if (def.regionMatches(true, 1, "P", 0, 1)) {
            return TriplesIteratorImpl.decodeDef(defs, sx + 1, i, types, vals, mods);
        }
        if (def.regionMatches(true, 1, "B", 0, 1)) {
            types[i] = 1;
            vals[i] = def.substring(2);
            mods[i] = null;
            return sx + 1;
        } else if (def.regionMatches(true, 1, "N", 0, 1)) {
            types[i] = 2;
            vals[i] = def.substring(2);
            mods[i] = null;
            return sx + 1;
        } else if (def.regionMatches(true, 1, "L", 0, 1)) {
            types[i] = 3;
            vals[i] = def.substring(2);
            mods[i] = null;
            return sx + 1;
        } else if (def.regionMatches(true, 1, "G", 0, 1)) {
            types[i] = 4;
            TriplesIteratorImpl.decodeBaseFifty(def, i, mods, vals);
            return sx + 1;
        } else if (def.regionMatches(true, 1, "T", 0, 1)) {
            types[i] = 5;
            TriplesIteratorImpl.decodeBaseFifty(def, i, vals, mods);
            return sx + 1;
        } else if (def.regionMatches(true, 1, "M", 0, 1)) {
            types[i] = 2;
            TriplesIteratorImpl.decodeNodeWithPrefix(defs, sx, i, vals, mods);
            return sx + 1;
        } else if (def.regionMatches(true, 1, "XD", 0, 2)) {
            types[i] = 7;
            vals[i] = "default graph";
            mods[i] = null;
            return sx + 1;
        } else {
            if (!def.regionMatches(true, 1, "E", 0, 1)) throw new IllegalArgumentException("Ill-formed node ref(e) " + def);
            int br = def.indexOf(";", 2);
            if (br < 4) {
                throw new IllegalArgumentException("Ill-formed node ref(c) " + def);
            }
            mods[i] = def.substring(2, br);
            vals[i] = def.substring(br + 2);
            if (def.regionMatches(true, br + 1, "S", 0, 1)) {
                types[i] = 8;
                return sx + 1;
            } else if (def.regionMatches(true, br + 1, "N", 0, 1)) {
                types[i] = 9;
                return sx + 1;
            } else {
                if (!def.regionMatches(true, br + 1, "D", 0, 1)) throw new IllegalArgumentException("Ill-formed node ref(d) " + def);
                types[i] = 10;
            }
        }
        return sx + 1;
    }

    static int baseFiftyDigit(String def, int j, int d) {
        char digitChar = def.charAt(j);
        int digit = "0123456789abcdefghijklmnopqrstABCDEFGHIJKLMNOPQRST".indexOf(digitChar);
        return d * 50 + digit;
    }

    static void decodeBaseFifty(String def, int i, String[] s1, String[] s2) {
        int d = 0;
        for (int j = 2; j < def.length(); ++j) {
            if (def.regionMatches(true, j, "X", 0, 1)) {
                s1[i] = def.substring(j + 1, j + 1 + d);
                s2[i] = def.substring(j + 1 + d);
                return;
            }
            d = TriplesIteratorImpl.baseFiftyDigit(def, j, d);
        }
        throw new IllegalArgumentException("Ill-formed node ref(b) " + def);
    }

    static void decodeNodeWithPrefix(String[] defs, int cx, int i, String[] s1, String[] s2) {
        String def = defs[cx];
        int d = 0;
        for (int j = 2; j < def.length(); ++j) {
            if (def.regionMatches(true, j, "X", 0, 1)) {
                s1[i] = defs[d].substring(2) + def.substring(j + 1);
                s2[i] = null;
                return;
            }
            d = TriplesIteratorImpl.baseFiftyDigit(def, j, d);
        }
        throw new IllegalArgumentException("Ill-formed node ref(d) " + def);
    }

    @Override
    public long get_id() {
        return this.id;
    }

    @Override
    public synchronized UPI getS() {
        if (this.atTriple()) {
            return this.s;
        }
        return null;
    }

    @Override
    public String querySubject() {
        return this.sVal;
    }

    @Override
    public String queryObject() {
        return this.oVal;
    }

    @Override
    public String queryPredicate() {
        return this.pVal;
    }

    @Override
    public String queryContext() {
        return this.cVal;
    }

    @Override
    public synchronized String getSubjectLabel() throws AllegroGraphException {
        this.sVal = this.getPartLabel(this.s, 1, this.sType, this.sVal);
        return this.sVal;
    }

    @Override
    public ValueNode getSubject() throws AllegroGraphException {
        return (ValueNode)this.getTripleComponent(this.s, 1);
    }

    @Override
    public ValueNode getContext() throws AllegroGraphException {
        return (ValueNode)this.getTripleComponent(this.s, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueObject getTripleComponent(UPIImpl part, int partIndex) throws AllegroGraphException {
        UPIImpl sb = null;
        int tp = 0;
        String val = null;
        String mod = null;
        TriplesIteratorImpl triplesIteratorImpl = this;
        synchronized (triplesIteratorImpl) {
            if (!this.atTriple()) {
                return null;
            }
            if (part == null) {
                return null;
            }
            sb = part;
            tp = this.getPartType(partIndex);
            val = this.getPartLabel(partIndex);
            mod = this.getPartMod(partIndex);
        }
        return this.ag.newValue(sb, tp, val, mod);
    }

    @Override
    public synchronized UPI getP() {
        if (this.atTriple()) {
            return this.p;
        }
        return null;
    }

    @Override
    public synchronized String getPredicateLabel() throws AllegroGraphException {
        this.pVal = this.getPartLabel(this.p, 2, this.pType, this.pVal);
        return this.pVal;
    }

    @Override
    public ValueNode getPredicate() throws AllegroGraphException {
        return (ValueNode)this.getTripleComponent(this.p, 2);
    }

    @Override
    public synchronized UPI getO() {
        if (this.atTriple()) {
            return this.o;
        }
        return null;
    }

    @Override
    public synchronized UPI getC() {
        if (this.atTriple()) {
            return this.c;
        }
        return null;
    }

    @Override
    public synchronized String getObjectLabel() throws AllegroGraphException {
        this.oVal = this.getPartLabel(this.o, 3, this.oType, this.oVal);
        return this.oVal;
    }

    @Override
    public synchronized String getContextLabel() throws AllegroGraphException {
        this.cVal = this.getPartLabel(this.c, 4, this.cType, this.cVal);
        return this.cVal;
    }

    int queryPartType(int px) {
        switch (px) {
            case 1: {
                return this.sType;
            }
            case 2: {
                return this.pType;
            }
            case 3: {
                return this.oType;
            }
            case 4: {
                return this.cType;
            }
        }
        return 0;
    }

    String queryPartLabel(int px) {
        switch (px) {
            case 1: {
                return this.sVal;
            }
            case 2: {
                return this.pVal;
            }
            case 3: {
                return this.oVal;
            }
            case 4: {
                return this.cVal;
            }
        }
        return null;
    }

    String queryPartMod(int px) {
        switch (px) {
            case 1: {
                return this.sMod;
            }
            case 2: {
                return this.pMod;
            }
            case 3: {
                return this.oMod;
            }
            case 4: {
                return this.cMod;
            }
        }
        return null;
    }

    public synchronized String getPartLabel(int partIndex) throws AllegroGraphException {
        switch (partIndex) {
            case 1: {
                this.sVal = this.getPartLabel(this.s, partIndex, this.sType, this.sVal);
                return this.sVal;
            }
            case 2: {
                this.pVal = this.getPartLabel(this.p, partIndex, this.pType, this.pVal);
                return this.pVal;
            }
            case 3: {
                this.oVal = this.getPartLabel(this.o, partIndex, this.oType, this.oVal);
                return this.oVal;
            }
            case 4: {
                this.cVal = this.getPartLabel(this.c, partIndex, this.cType, this.cVal);
                return this.cVal;
            }
        }
        throw new IllegalArgumentException("Not a triple part index: " + partIndex);
    }

    synchronized String getPartLabel(UPI part, int partIndex, int type, String label) throws AllegroGraphException {
        if (!this.atTriple()) {
            return null;
        }
        if (part == null) {
            return null;
        }
        if (type == 0) {
            this.getCachedAll(partIndex);
            type = this.queryPartType(partIndex);
            label = this.queryPartLabel(partIndex);
        }
        if (type == 0) {
            Object[] v = this.getAll(part, partIndex);
            label = (String)v[1];
        }
        return label;
    }

    public synchronized String getPartMod(int partIndex) throws AllegroGraphException {
        switch (partIndex) {
            case 1: {
                this.sMod = this.getPartMod(this.s, partIndex, this.sType, this.sMod);
                return this.sMod;
            }
            case 2: {
                this.pMod = this.getPartMod(this.p, partIndex, this.pType, this.pMod);
                return this.pMod;
            }
            case 3: {
                this.oMod = this.getPartMod(this.o, partIndex, this.oType, this.oMod);
                return this.oMod;
            }
            case 4: {
                this.cMod = this.getPartMod(this.c, partIndex, this.cType, this.cMod);
                return this.cMod;
            }
        }
        throw new IllegalArgumentException("Not a triple part index: " + partIndex);
    }

    synchronized String getPartMod(UPI part, int partIndex, int type, String mod) throws AllegroGraphException {
        if (!this.atTriple()) {
            return null;
        }
        if (part == null) {
            return null;
        }
        if (mod != null) {
            return mod;
        }
        if (type == 0) {
            this.getCachedAll(partIndex);
            type = this.queryPartType(partIndex);
            mod = this.queryPartMod(partIndex);
        }
        if (type == 0) {
            Object[] v = this.getAll(part, partIndex);
            mod = (String)v[2];
        }
        return mod;
    }

    public synchronized int getPartType(int partIndex) throws AllegroGraphException {
        switch (partIndex) {
            case 1: {
                this.sType = this.getPartType(this.s, partIndex, this.sType);
                return this.sType;
            }
            case 2: {
                this.pType = this.getPartType(this.p, partIndex, this.pType);
                return this.pType;
            }
            case 3: {
                this.oType = this.getPartType(this.o, partIndex, this.oType);
                return this.oType;
            }
            case 4: {
                this.cType = this.getPartType(this.c, partIndex, this.cType);
                return this.cType;
            }
        }
        throw new IllegalArgumentException("Not a triple part index: " + partIndex);
    }

    synchronized int getPartType(UPI part, int partIndex, int type) throws AllegroGraphException {
        if (!this.atTriple()) {
            return 0;
        }
        if (part == null) {
            return 0;
        }
        if (type == 0) {
            this.getCachedAll(partIndex);
            type = this.queryPartType(partIndex);
        }
        if (type == 0) {
            Object[] v = this.getAll(part, partIndex);
            type = (Integer)v[0];
        }
        return type;
    }

    synchronized Object[] getAll(UPI part, int partIndex) throws AllegroGraphException {
        Object[] v = this.ag.verifyEnabled().getParts(this.ag, part);
        int type = (Integer)v[0];
        switch (partIndex) {
            case 1: {
                this.sType = type;
                this.sVal = (String)v[1];
                this.sMod = (String)v[2];
                break;
            }
            case 2: {
                this.pType = type;
                this.pVal = (String)v[1];
                this.pMod = (String)v[2];
                break;
            }
            case 3: {
                this.oType = type;
                this.oVal = (String)v[1];
                this.oMod = (String)v[2];
                break;
            }
            case 4: {
                this.cType = type;
                this.cVal = (String)v[1];
                this.cMod = (String)v[2];
            }
        }
        return v;
    }

    @Override
    public ValueNode getObject() throws AllegroGraphException {
        return (ValueNode)this.getTripleComponent(this.o, 3);
    }

    @Override
    public synchronized TripleImpl queryTriple() {
        if (!this.atTriple()) {
            return null;
        }
        TripleImpl tr = new TripleImpl(this.ag, this.id, this.s, this.p, this.o, this.c);
        tr.subject = this.sVal;
        tr.sType = this.sType;
        tr.subjMod = this.sMod;
        tr.object = this.oVal;
        tr.oType = this.oType;
        tr.objMod = this.oMod;
        tr.predicate = this.pVal;
        tr.pType = this.pType;
        tr.predMod = this.pMod;
        tr.context = this.cVal;
        tr.cType = this.cType;
        tr.cxMod = this.cMod;
        return tr;
    }

    @Override
    public synchronized Triple getTriple() throws AllegroGraphException {
        if (!this.atTriple()) {
            return null;
        }
        TripleImpl tr = new TripleImpl(this.ag, this.id, this.s, this.p, this.o, this.c);
        tr.subject = this.getSubjectLabel();
        tr.object = this.getObjectLabel();
        tr.predicate = this.getPredicateLabel();
        tr.context = this.getContextLabel();
        tr.sType = this.sType;
        tr.subjMod = this.sMod;
        tr.oType = this.oType;
        tr.objMod = this.oMod;
        tr.pType = this.pType;
        tr.predMod = this.pMod;
        tr.cType = this.cType;
        tr.cxMod = this.cMod;
        return tr;
    }

    @Override
    public synchronized Triple next() {
        if (this.nextp) {
            try {
                this.step();
            }
            catch (AllegroGraphException e) {
                throw new IllegalStateException("Cursor.next " + e);
            }
        }
        return this.queryTriple();
    }

    @Override
    public synchronized Triple getNext() {
        if (this.nextp) {
            try {
                this.step();
            }
            catch (AllegroGraphException e) {
                throw new IllegalStateException("Cursor.next " + e);
            }
        }
        return this.queryTriple();
    }

    @Override
    public boolean atTriple() {
        return this.id != -1L;
    }

    @Override
    public boolean hasNext() {
        return this.nextp;
    }

    @Override
    public boolean limitReached() {
        return this.truncated;
    }

    @Override
    public void close() {
        if (this.source == null) {
            return;
        }
        if (this.ag == null) {
            return;
        }
        try {
            this.ag.discardCursor(this.source);
        }
        catch (AllegroGraphException e) {
            throw new IllegalStateException("Cursor.close " + e);
        }
        finally {
            this.source = null;
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (this.ag == null) {
            return;
        }
        if (null == this.ag.ags) {
            return;
        }
        if (null != this.source) {
            this.ag.ags.oldTokens.add(this.source);
        }
    }

    boolean isCacheAvailable() {
        return this.nextp && this.cache != null && 0 <= this.cacheIndex && this.cacheIndex < this.cache.length - 1;
    }

    @Override
    public synchronized boolean step() throws AllegroGraphException {
        if (this.isCacheAvailable()) {
            return this.stepCache();
        }
        if (!this.nextp) {
            return false;
        }
        if (this.source == null) {
            return false;
        }
        if (this.withParts) {
            Object[] v = this.ag.verifyEnabled().nextCursorAndParts(this.ag, this.source, this.lookAhead);
            UPI[] r = (UPI[])v[0];
            String[] d = (String[])v[1];
            if (r == null) {
                this.setCache(null, true);
                return false;
            }
            this.setCache(r, d);
        } else {
            UPI[] r = this.ag.verifyEnabled().nextCursor(this.ag, this.source, this.lookAhead);
            if (r == null) {
                this.setCache(null, true);
                return false;
            }
            this.setCache(r, true);
        }
        return this.stepCache();
    }

    String stepVal() {
        if (this.cVals != null) {
            return this.cVals[this.cacheIndex];
        }
        return null;
    }

    int stepType() {
        if (this.cTypes != null) {
            return this.cTypes[this.cacheIndex];
        }
        return 0;
    }

    String stepMod() {
        if (this.cMods != null) {
            return this.cMods[this.cacheIndex];
        }
        return null;
    }

    synchronized void setTriple() {
        this.id = -1L;
        this.s = null;
        this.p = null;
        this.o = null;
        this.c = null;
        this.sVal = null;
        this.pVal = null;
        this.oVal = null;
        this.cVal = null;
        this.sType = 0;
        this.pType = 0;
        this.oType = 0;
        this.cType = 0;
        this.sMod = null;
        this.pMod = null;
        this.oMod = null;
        this.cMod = null;
    }

    UPIImpl getCache() {
        UPIImpl cupi = (UPIImpl)this.cache[this.cacheIndex];
        if (null == cupi) {
            return null;
        }
        if (null != cupi.getUpi()) {
            return cupi;
        }
        long idnum = cupi.getCode();
        if (idnum < 0L) {
            return (UPIImpl)this.cache[this.cacheIndex + (int)idnum];
        }
        return cupi;
    }

    synchronized boolean stepCache() {
        this.id = this.getCache().getCode();
        ++this.cacheIndex;
        this.s = this.getCache();
        this.sVal = this.stepVal();
        this.sType = this.stepType();
        this.sMod = this.stepMod();
        ++this.cacheIndex;
        this.p = this.getCache();
        this.pVal = this.stepVal();
        this.pType = this.stepType();
        this.pMod = this.stepMod();
        ++this.cacheIndex;
        this.o = this.getCache();
        this.oVal = this.stepVal();
        this.oType = this.stepType();
        this.oMod = this.stepMod();
        ++this.cacheIndex;
        this.c = this.getCache();
        this.cVal = this.stepVal();
        this.cType = this.stepType();
        this.cMod = this.stepMod();
        ++this.cacheIndex;
        if (this.cacheIndex == this.cache.length - 1) {
            UPIImpl ce = (UPIImpl)this.cache[this.cacheIndex];
            long cx = ce.getCode();
            if (cx > 0L && this.source != null) {
                this.nextp = true;
            } else {
                this.nextp = false;
                if (cx < 0L) {
                    this.truncated = true;
                }
            }
            this.setCache(null, false);
        } else {
            this.nextp = true;
        }
        return true;
    }

    synchronized void getTripleComponents() throws AllegroGraphException {
        if (this.cache == null) {
            return;
        }
        if (this.cTypes != null) {
            return;
        }
        int ln = this.cache.length;
        int sln = 0;
        int cc = 0;
        for (int i = 0; i < ln - 1; ++i) {
            if (cc == 0) {
                cc = 5;
            } else {
                UPIImpl cu = (UPIImpl)this.cache[i];
                if (cu != null && cu.withLabel()) {
                    ++sln;
                }
            }
            --cc;
        }
        com.franz.ag.UPI[] shortCache = new UPI[sln];
        int[] cachePos = new int[ln];
        cc = 0;
        int sx = 0;
        for (int i = 0; i < ln - 1; ++i) {
            if (cc == 0) {
                cc = 5;
                cachePos[i] = -1;
            } else {
                UPIImpl cu = (UPIImpl)this.cache[i];
                if (cu != null && cu.withLabel()) {
                    shortCache[sx] = cu;
                    ++sx;
                    cachePos[i] = -2;
                } else {
                    cachePos[i] = -1;
                }
            }
            --cc;
        }
        int[] stp = new int[sln];
        String[] svl = new String[sln];
        String[] smd = new String[sln];
        this.ag.verifyEnabled().getParts(this.ag, shortCache, stp, svl, smd);
        int[] tp = new int[ln];
        String[] vl = new String[ln];
        String[] md = new String[ln];
        sx = 0;
        block6: for (int i = 0; i < ln - 1; ++i) {
            switch (cachePos[i]) {
                case -1: {
                    continue block6;
                }
                case -2: {
                    tp[i] = stp[sx];
                    vl[i] = svl[sx];
                    md[i] = smd[sx];
                    ++sx;
                }
            }
        }
        this.cTypes = tp;
        this.cVals = vl;
        this.cMods = md;
    }

    void getCachedAll(int partIndex) throws AllegroGraphException {
        switch (partIndex) {
            case 1: {
                this.sType = this.getCachedType(partIndex);
                this.sVal = this.getCachedValue(partIndex);
                this.sMod = this.getCachedModifier(partIndex);
                break;
            }
            case 2: {
                this.pType = this.getCachedType(partIndex);
                this.pVal = this.getCachedValue(partIndex);
                this.pMod = this.getCachedModifier(partIndex);
                break;
            }
            case 3: {
                this.oType = this.getCachedType(partIndex);
                this.oVal = this.getCachedValue(partIndex);
                this.oMod = this.getCachedModifier(partIndex);
                break;
            }
            case 4: {
                this.cType = this.getCachedType(partIndex);
                this.cVal = this.getCachedValue(partIndex);
                this.cMod = this.getCachedModifier(partIndex);
            }
        }
    }

    int getCachedType(int tpart) throws AllegroGraphException {
        if (this.cache == null) {
            return 0;
        }
        if (this.cacheIndex < 0) {
            return 0;
        }
        if (this.cTypes == null) {
            this.getTripleComponents();
        }
        return this.cTypes[this.cacheIndex - 5 + tpart];
    }

    String getCachedValue(int tpart) throws AllegroGraphException {
        if (this.cache == null) {
            return null;
        }
        if (this.cacheIndex < 0) {
            return null;
        }
        if (this.cTypes == null) {
            this.getTripleComponents();
        }
        return this.cVals[this.cacheIndex - 5 + tpart];
    }

    String getCachedModifier(int tpart) throws AllegroGraphException {
        if (this.cache == null) {
            return null;
        }
        if (this.cacheIndex < 0) {
            return null;
        }
        if (this.cTypes == null) {
            this.getTripleComponents();
        }
        return this.cMods[this.cacheIndex - 5 + tpart];
    }

    @Override
    public synchronized Triple[] step(int n) throws AllegroGraphException {
        int i;
        int have = 0;
        if (this.isCacheAvailable()) {
            have = (this.cache.length - this.cacheIndex - 1) / 5;
        }
        boolean didFetch = false;
        UPIImpl[] newa = null;
        int newl = 0;
        String[] newd = null;
        if (have < n && this.cache != null && ((UPIImpl)this.cache[this.cache.length - 1]).getCode() > 0L && this.source != null) {
            UPIImpl[] ra = null;
            int get = n - have;
            if (get < this.lookAhead) {
                get = this.lookAhead;
            }
            if (this.withParts) {
                Object[] v = this.ag.verifyEnabled().nextCursorAndParts(this.ag, this.source, get);
                ra = (UPIImpl[])v[0];
                newd = (String[])v[1];
                didFetch = true;
            } else {
                ra = this.ag.verifyEnabled().nextCursor(this.ag, this.source, get);
                didFetch = true;
            }
            if (ra != null) {
                newa = ra;
                newl = (newa.length - 1) / 5;
            }
        } else if (have >= n) {
            have = n;
        }
        Triple[] r = new Triple[have + newl];
        for (i = 0; i < have; ++i) {
            this.stepCache();
            r[i] = new TripleImpl(this.ag, this.id, this.s, this.p, this.o, this.c);
        }
        if (didFetch) {
            if (newa == null) {
                this.setCache(null, true);
                return r;
            }
            if (newd == null) {
                this.setCache(newa, true);
            } else {
                this.setCache(newa, newd);
            }
            for (i = 0; i < newl; ++i) {
                this.stepCache();
                r[have + i] = new TripleImpl(this.ag, this.id, this.s, this.p, this.o, this.c);
            }
        }
        return r;
    }

    @Override
    public synchronized String toString() {
        String triple = "empty";
        if (this.atTriple()) {
            triple = "" + this.id + ": " + this.showPart(this.sVal, this.sType, this.sMod, this.s) + " " + this.showPart(this.pVal, this.pType, this.pMod, this.p) + " " + this.showPart(this.oVal, this.oType, this.oMod, this.o) + " " + this.showPart(this.cVal, this.cType, this.cMod, this.c);
        }
        String ns = this.nextp ? ", with" : ", no";
        return "<Cursor " + triple + " " + ns + " next>";
    }

    String showPart(String val, int type, String mod, UPI upi) {
        switch (type) {
            case 1: {
                return "_:blank" + val;
            }
            case 2: {
                return "<" + val + ">";
            }
            case 3: {
                return "\"" + val + "\"";
            }
            case 4: {
                return "\"" + val + "@" + mod + "\"";
            }
            case 5: {
                return "\"" + val + "^^<" + mod + ">\"";
            }
        }
        return "" + upi;
    }

    @Override
    public synchronized void remove() {
        if (!this.atTriple()) {
            throw new IllegalStateException("Nothing to remove");
        }
        this.setTriple();
    }
}

