/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.URINode;
import com.franz.agbase.impl.ResourceNodeImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGInternals;

public class URINodeImpl
extends ResourceNodeImpl
implements URINode {
    private static final long serialVersionUID = 8675791173081086903L;
    String uri = null;
    public static final URINode nullContext = new URINodeImpl(null, UPIImpl.nullUPI(), null);

    URINodeImpl(AllegroGraph ts, UPI i, String u) {
        this.owner = ts;
        this.nodeUPI = i;
        this.uri = u;
    }

    @Override
    public UPI getAGId() throws AllegroGraphException {
        UPI n = this.queryAGId();
        n = URINodeImpl.getUPI(this.owner, n, this.uri);
        this.setAGId(n);
        return n;
    }

    public static UPI getUPI(AGInternals owner, UPI n, String uri) throws AllegroGraphException {
        if (UPIImpl.canReference(n)) {
            return n;
        }
        if (uri == null) {
            throw new IllegalStateException("Cannot realize a node without a URI");
        }
        n = owner.verifyEnabled().newResource(owner, uri);
        return n;
    }

    @Override
    public String queryURI() {
        return this.uri;
    }

    @Override
    public String getLocalName() {
        this.uri = this.owner.getText(this.nodeUPI, this.uri);
        int p = this.uri.indexOf("#");
        if (p < 0) {
            return "";
        }
        return this.uri.substring(p + 1);
    }

    @Override
    public String getNamespace() {
        this.uri = this.owner.getText(this.nodeUPI, this.uri);
        int p = this.uri.indexOf("#");
        if (p < 0) {
            return this.uri;
        }
        return this.uri.substring(0, p + 1);
    }

    @Override
    public String toString() {
        this.uri = this.owner.getText(this.nodeUPI, this.uri);
        return this.uri;
    }

    @Override
    public boolean equals(Object other) {
        switch (this.sameAGId(other)) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        if (other instanceof URINode) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public TriplesIterator getPredicateStatements() throws AllegroGraphException {
        return this.owner.getStatements(null, this, null);
    }

    @Override
    public String getURI() {
        return this.toString();
    }

    @Override
    public void add() throws AllegroGraphException {
        this.getAGId();
    }
}

