/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.transport;

import com.franz.ag.UPI;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGC;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.net.Socket;

public class AGDirectLink
extends AGC {
    protected static int debugClient = 0;
    int agServerLevel = 0;
    int state = -1;
    static final int ERR_PORT_CLOSED = -101;
    static final int ERR_PORT_STATE = -102;
    static final int ERR_PROTOCOL = -104;
    static final int ERR_PORT_IO = -107;
    static final int ERR_FLUSH_IO = -108;
    static final int ERR_THROW = -109;
    static final int ERR_BUSY = -111;
    Socket socket;
    InputStream inStream;
    OutputStream outStream;
    byte[] buffer = new byte[1024];
    int endpos = 0;
    Thread softLock = null;
    int timeout = 5000;
    static boolean connectFlag = false;
    static int opIndex = 0;
    int haveCode = 1000000;

    static void throwIOErr(String where, int e) throws IOException {
        String err = "Unknown";
        switch (e) {
            case -1: {
                err = "End_of_file";
                break;
            }
            case -102: {
                err = "ERR_PORT_STATE";
                break;
            }
            case -104: {
                err = "ERR_PROTOCOL";
                break;
            }
            case -107: {
                err = "ERR_PORT_IO";
                break;
            }
            case -108: {
                err = "ERR_FLUSH_IO";
                break;
            }
            case -109: {
                err = "ERR_THROW";
                break;
            }
            case -111: {
                err = "ERR_BUSY";
                break;
            }
            case -101: {
                err = "ERR_PORT_CLOSED";
                break;
            }
            default: {
                err = "Unknown err(" + e + ")";
            }
        }
        throw new IOException(err + " in " + where);
    }

    static String debug(int cl) {
        int oldc = debugClient;
        if (cl >= 0) {
            debugClient = cl;
        }
        return "Client was " + oldc + " now " + debugClient;
    }

    AGDirectLink() {
    }

    AGDirectLink(String host, int port, int pollCount, int pollInterval) throws IOException {
        this(host, port, pollCount, pollInterval, 5000);
    }

    AGDirectLink(String host, int port, int pollCount, int pollInterval, int timeout) throws IOException {
        Socket client = null;
        IOException ee = null;
        for (int i = 0; client == null && i < pollCount; ++i) {
            try {
                if (i > 0) {
                    Thread.sleep(pollInterval);
                }
                Socket testClient = new Socket();
                InetSocketAddress addr = new InetSocketAddress(host, port);
                testClient.connect(addr, timeout);
                client = testClient;
                continue;
            }
            catch (IOException e) {
                ee = e;
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (client == null) {
            if (ee == null) {
                throw new IOException("Failed to connect to server.");
            }
            throw new IOException(ee.toString());
        }
        client.setTcpNoDelay(true);
        this.socket = client;
        this.inStream = new BufferedInputStream(client.getInputStream());
        this.outStream = new BufferedOutputStream(client.getOutputStream());
        this.state = 0;
        this.softLock = null;
        int flag = timeout / 10;
        while (flag > 0) {
            try {
                Thread.sleep(100L);
                --flag;
                if (0 >= this.inStream.available()) continue;
                flag = -1;
            }
            catch (InterruptedException e) {}
        }
        if (flag == 0) {
            this.socket.close();
            throw new IOException("Connected but timed out.");
        }
        int reply = this.inStream.read();
        switch (reply) {
            case 207: {
                this.socket.close();
                throw new IOException("Too many connections.");
            }
            case 192: {
                this.socket.close();
                throw new IOException("Connection rejected.");
            }
        }
        if (reply != 130) {
            this.socket.close();
            throw new IOException("Unexpected initial reply " + reply);
        }
    }

    boolean query() throws IOException {
        String s;
        Object r = this.sendOp1(":verify", 1, 0, 2L);
        if (r instanceof String && (s = (String)r).startsWith("AGDirect Version")) {
            String pl = "server level";
            int plx = s.indexOf(pl);
            if (plx < 0) {
                return true;
            }
            try {
                this.agServerLevel = Integer.parseInt(s.substring(plx + pl.length() + 1));
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        this.disconnect();
        return false;
    }

    synchronized boolean disconnect() throws IOException {
        switch (this.state) {
            case -1: {
                return false;
            }
            case 0: {
                this.sendOp0(":disconnect", -1, -1);
                try {
                    Thread.sleep(100L);
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            this.socket.close();
            this.state = -1;
            this.socket = null;
            this.inStream = null;
            this.outStream = null;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    synchronized String grabSoftLock(String from) {
        Thread cur = Thread.currentThread();
        if (this.softLock == null) {
            this.softLock = cur;
        } else {
            if (this.softLock == cur) {
                return "Recursive call to" + from;
            }
            while (this.softLock != null) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            this.softLock = cur;
        }
        return "";
    }

    synchronized void dropSoftLock() {
        if (this.softLock == null) {
            return;
        }
        this.softLock = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp0(String op, int style, int rx) throws IOException {
        try {
            int opix = this.sendOpHeader(op, style, 0);
            Object object = this.sendOpTail(op, opix, style, rx);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp1(String op, int style, int rx, String arg) throws IOException {
        try {
            int opix = this.sendOpHeader(op, style, 1);
            this.portOut(arg);
            Object object = this.sendOpTail(op, opix, style, rx);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp1(String op, int style, int rx, long arg) throws IOException {
        try {
            int opix = this.sendOpHeader(op, style, 1);
            this.portOut(arg);
            Object object = this.sendOpTail(op, opix, style, rx);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp2(String op, int style, int rx, String arg0, long arg1) throws IOException {
        try {
            int opix = this.sendOpHeader(op, style, 2);
            this.portOut(arg0);
            this.portOut(arg1);
            Object object = this.sendOpTail(op, opix, style, rx);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp2(String op, int style, int rx, String arg0, Object arg1) throws IOException {
        try {
            int opix = this.sendOpHeader(op, style, 2);
            this.portOut(arg0);
            this.portOutUnwrapped(arg1);
            Object object = this.sendOpTail(op, opix, style, rx);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp1n(String op, int style, int rx, String arg0, Object[] args) throws IOException {
        try {
            int opix = this.sendOpHeader(op, style, 1 + args.length);
            this.portOut(arg0);
            for (int i = 0; i < args.length; ++i) {
                this.portOutUnwrapped(args[i]);
            }
            Object object = this.sendOpTail(op, opix, style, rx);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp2n(String op, int style, int rx, String arg0, long arg1, Object[] args) throws IOException {
        try {
            int opix = this.sendOpHeader(op, style, 2 + args.length);
            this.portOut(arg0);
            this.portOut(arg1);
            for (int i = 0; i < args.length; ++i) {
                this.portOutUnwrapped(args[i]);
            }
            Object object = this.sendOpTail(op, opix, style, rx);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object sendOp3n(String op, int style, int rx, String arg0, long arg1, String arg2, Object[] args) throws IOException {
        try {
            int opix = this.sendOpHeader(op, style, 3 + args.length);
            this.portOut(arg0);
            this.portOut(arg1);
            this.portOut(arg2);
            for (int i = 0; i < args.length; ++i) {
                this.portOutUnwrapped(args[i]);
            }
            Object object = this.sendOpTail(op, opix, style, rx);
            return object;
        }
        finally {
            this.state = 0;
            this.dropSoftLock();
        }
    }

    synchronized int getOpIndex() {
        return ++opIndex;
    }

    int sendOpHeader(String op, int style, int argCount) throws IOException {
        int ret = 0;
        int opix = this.getOpIndex();
        String gv = this.grabSoftLock("sendOpHeader()");
        if (gv.length() > 0) {
            throw new IOException("sendOpHeader " + op + "cannot grab lock: " + gv);
        }
        switch (this.state) {
            case 0: {
                this.state = 1;
                ret = this.portOutTag(206);
                if (ret >= 0) {
                    ret = this.portOut(op);
                }
                if (ret < 0) {
                    return ret;
                }
                ret = style < 0 ? this.portOut(0) : (style == 0 ? this.portOut(-opix) : this.portOut(opix));
                if (ret < 0) break;
                ret = this.portOut(argCount);
                break;
            }
            case -1: {
                ret = -101;
                break;
            }
            default: {
                ret = -102;
            }
        }
        if (ret < 0) {
            AGDirectLink.throwIOErr("sendOpHeader ", ret);
        }
        return opix;
    }

    Object sendOpTail(String op, int opix, int style, int rx) throws IOException {
        int ret = 0;
        ret = this.streamOutFlush();
        if (ret < 0) {
            AGDirectLink.throwIOErr("sendOp", ret);
        }
        if (style < 0) {
            return null;
        }
        this.state = 4;
        return this.opResIn(op, opix, rx);
    }

    Object opResIn(String op, int opix, int rx) throws IOException {
        Object[] res = this.portInOp();
        if (2 > res.length) {
            throw new IOException("opResIn " + op + "[" + opix + "]" + " received " + res.length);
        }
        if (!op.equals(res[0])) {
            throw new IOException("opResIn " + op + "[" + opix + "]" + " received " + res[0]);
        }
        long rrx = (Long)res[1];
        if (rrx < 0L && -rrx == (long)opix && 3 < res.length) {
            throw new IOException("opResIn " + op + "[" + opix + "]" + " error in AllegroGraph server " + res[2] + " " + res[3]);
        }
        if (rrx < 0L) {
            throw new IOException("opResIn " + op + "[" + opix + "]" + " error in AllegroGraph server " + rrx + " " + res.length);
        }
        if (rrx != (long)opix) {
            throw new IOException("opResIn " + op + "[" + opix + "]" + " expected " + opix + " received " + rrx);
        }
        if (rx == -1) {
            return res;
        }
        if (rx == -2) {
            if (2 == res.length) {
                return null;
            }
            throw new IOException("opResIn " + op + "[" + opix + "]" + " expected zero values, received " + res.length);
        }
        if (0 <= rx && rx < res.length - 2) {
            return res[rx + 2];
        }
        throw new IOException("opResIn mismatch:" + op + "[" + opix + "]" + " expected " + (rx + 1) + " results, received " + (res.length - 2));
    }

    int streamOutFlush() {
        return this.portFlush();
    }

    int streamInCode() throws IOException {
        if (this.haveCode == 1000000) {
            return this.portIn_8();
        }
        int r = this.haveCode;
        this.haveCode = 1000000;
        return r;
    }

    int streamInCode(int code) {
        if (this.haveCode == 1000000) {
            this.haveCode = code;
            return code;
        }
        return -104;
    }

    String tagToString(int tag) {
        if (tag < 128) {
            return "NOT_A_TAG";
        }
        if (tag < 192) {
            return "INTEGER";
        }
        switch (tag) {
            case 192: {
                return "NULL";
            }
            case 193: {
                return "BYTE";
            }
            case 194: {
                return "SHORT";
            }
            case 195: {
                return "INT";
            }
            case 196: {
                return "CHAR";
            }
            case 197: {
                return "FLOAT";
            }
            case 198: {
                return "DOUBLE";
            }
            case 200: {
                return "SEQ";
            }
            case 201: {
                return "SPARSE";
            }
            case 202: {
                return "OBJECT";
            }
            case 203: {
                return "BOOLEANtrue";
            }
            case 204: {
                return "BOOLEANfalse";
            }
            case 205: {
                return "OPENd";
            }
            case 206: {
                return "OP";
            }
            case 256: {
                return "TAG_END";
            }
        }
        return "TAG_STRING";
    }

    Object streamInValue() throws IOException {
        return this.streamInValue(this.streamInCode());
    }

    Object streamInValue(int tag) throws IOException {
        Object w = null;
        if (tag < 128) {
            throw new IOException("streamInValue tag " + tag);
        }
        if (tag < 192) {
            w = new Long(this.portInLong(tag));
        } else {
            switch (tag) {
                case 192: {
                    break;
                }
                case 193: {
                    w = new Byte((byte)this.portInLong());
                    break;
                }
                case 194: {
                    w = new Short((short)this.portInLong());
                    break;
                }
                case 195: {
                    w = new Integer((int)this.portInLong());
                    break;
                }
                case 196: {
                    StringBuffer wb = new StringBuffer(2);
                    wb.append((char)this.portInLong());
                    w = new Character(wb.charAt(0));
                    break;
                }
                case 197: {
                    w = new Float(this.portInFloat(tag));
                    break;
                }
                case 198: {
                    w = new Double(this.portInDouble(tag));
                    break;
                }
                case 200: {
                    w = this.portInSequence(tag);
                    break;
                }
                case 201: {
                    w = this.portInSparse(tag);
                    break;
                }
                case 202: {
                    w = this.portInObject(tag);
                    break;
                }
                case 203: {
                    w = new Boolean(true);
                    break;
                }
                case 204: {
                    w = new Boolean(false);
                    break;
                }
                case 205: {
                    throw new IOException("streamInValue tag " + tag);
                }
                case 206: {
                    w = this.portInOp(tag);
                    break;
                }
                case 256: {
                    throw new IOException("streamInValue tag " + tag);
                }
                case 211: {
                    w = this.portInUPI(tag);
                    break;
                }
                case 210: {
                    w = this.portInBytes(tag);
                    break;
                }
                default: {
                    w = this.portInString(tag);
                }
            }
        }
        return w;
    }

    Object portInSequence() throws IOException {
        return this.portInSequence(this.streamInCode());
    }

    Object portInSequence(int tag) throws IOException {
        int len = (int)this.portInLong();
        int sub = this.portIn_8();
        return this.portInSeqBody(tag, len, sub);
    }

    boolean isIntTag(int tag) {
        if (tag < 128) {
            return false;
        }
        return tag < 192;
    }

    int portInDupRep(int next, int i, Object w, String from) throws IOException {
        if (next == 212) {
            int j = (int)this.portInLong();
            Array.set(w, i, Array.get(w, i - j));
            return i + 1;
        }
        if (next == 213) {
            int j = (int)this.portInLong();
            int n = (int)this.portInLong();
            Object v = Array.get(w, i - j);
            for (int k = 0; k < n; ++k) {
                Array.set(w, i++, v);
            }
            return i;
        }
        throw new IOException(from + " subtag " + next);
    }

    Object portInSeqLong(int len) throws IOException {
        long[] wl = new long[len];
        int i = 0;
        while (i < len) {
            int next = this.portIn_8();
            if (this.isIntTag(next)) {
                wl[i++] = this.portInLong(next);
                continue;
            }
            i = this.portInDupRep(next, i, wl, "portInSeqLong");
        }
        return wl;
    }

    Object portInSeqByte(int len) throws IOException {
        byte[] wl = new byte[len];
        int i = 0;
        while (i < len) {
            int next = this.portIn_8();
            if (this.isIntTag(next)) {
                wl[i++] = (byte)this.portInLong(next);
                continue;
            }
            i = this.portInDupRep(next, i, wl, "portInSeqByte");
        }
        return wl;
    }

    Object portInSeqShort(int len) throws IOException {
        short[] wl = new short[len];
        int i = 0;
        while (i < len) {
            int next = this.portIn_8();
            if (this.isIntTag(next)) {
                wl[i++] = (short)this.portInLong(next);
                continue;
            }
            i = this.portInDupRep(next, i, wl, "portInSeqShort");
        }
        return wl;
    }

    Object portInSeqInt(int len) throws IOException {
        int[] wl = new int[len];
        int i = 0;
        while (i < len) {
            int next = this.portIn_8();
            if (this.isIntTag(next)) {
                wl[i++] = (int)this.portInLong(next);
                continue;
            }
            i = this.portInDupRep(next, i, wl, "portInSeqInt");
        }
        return wl;
    }

    Object portInSeqFloat(int len) throws IOException {
        float[] wl = new float[len];
        int i = 0;
        while (i < len) {
            int next = this.portIn_8();
            if (next == 197) {
                wl[i++] = this.portInFloat(next);
                continue;
            }
            i = this.portInDupRep(next, i, wl, "portInSeqFloat");
        }
        return wl;
    }

    Object portInSeqDouble(int len) throws IOException {
        double[] wl = new double[len];
        int i = 0;
        while (i < len) {
            int next = this.portIn_8();
            if (next == 198) {
                wl[i++] = this.portInDouble(next);
                continue;
            }
            i = this.portInDupRep(next, i, wl, "portInSeqDouble");
        }
        return wl;
    }

    Object portInSeqString(int len) throws IOException {
        String[] wl = new String[len];
        int i = 0;
        while (i < len) {
            int next = this.portIn_8();
            if (next == 212) {
                int j = (int)this.portInLong();
                wl[i] = wl[i - j];
                ++i;
                continue;
            }
            if (next == 213) {
                int j = (int)this.portInLong();
                int n = (int)this.portInLong();
                String v = wl[i - j];
                for (int k = 0; k < n; ++k) {
                    wl[i++] = v;
                }
                continue;
            }
            CharSequence s = this.portInString(next);
            wl[i] = s == null ? null : ((Object)s).toString();
            ++i;
        }
        return wl;
    }

    Object portInSeqObject(int len) throws IOException {
        Object[] wl = new Object[len];
        int i = 0;
        while (i < len) {
            int j;
            int next = this.portIn_8();
            if (next == 212) {
                j = (int)this.portInLong();
                wl[i] = wl[i - j];
                ++i;
                continue;
            }
            if (next == 213) {
                j = (int)this.portInLong();
                int n = (int)this.portInLong();
                Object v = wl[i - j];
                for (int k = 0; k < n; ++k) {
                    wl[i++] = v;
                }
                continue;
            }
            wl[i++] = this.streamInValue(next);
        }
        return wl;
    }

    UPIImpl[] portInSeqUPI(int len) throws IOException {
        UPIImpl[] wl = new UPIImpl[len];
        int i = 0;
        while (i < len) {
            int j;
            int next = this.portIn_8();
            if (next == 212) {
                j = (int)this.portInLong();
                wl[i] = wl[i - j];
                ++i;
                continue;
            }
            if (next == 213) {
                j = (int)this.portInLong();
                int n = (int)this.portInLong();
                UPIImpl v = wl[i - j];
                for (int k = 0; k < n; ++k) {
                    wl[i++] = v;
                }
                continue;
            }
            if (next == 192) {
                wl[i++] = null;
                continue;
            }
            if (next == 211) {
                wl[i++] = this.portInUPI(next);
                continue;
            }
            wl[i++] = new UPIImpl(this.portInLong(next));
        }
        return wl;
    }

    Object portInSeqBody(int tag, int len, int sub) throws IOException {
        if (tag != 200) {
            throw new IOException("portInSequence tag " + tag);
        }
        if (sub < 128) {
            throw new IOException("portInSequence subtag " + sub);
        }
        if (sub < 192) {
            return this.portInSeqLong(len);
        }
        if (sub < 222) {
            switch (sub) {
                case 193: {
                    return this.portInSeqByte(len);
                }
                case 211: {
                    return this.portInSeqUPI(len);
                }
                case 194: {
                    return this.portInSeqShort(len);
                }
                case 195: {
                    return this.portInSeqInt(len);
                }
                case 128: {
                    return this.portInSeqLong(len);
                }
                case 196: {
                    char[] wc = new char[len];
                    for (int i = 0; i < len; ++i) {
                        wc[i] = (char)this.portInLong();
                    }
                    return wc;
                }
                case 197: {
                    return this.portInSeqFloat(len);
                }
                case 198: {
                    return this.portInSeqDouble(len);
                }
                case 203: 
                case 204: {
                    boolean[] wbl = new boolean[len];
                    block16: for (int i = 0; i < len; ++i) {
                        int b = this.portIn_8();
                        switch (b) {
                            case 203: {
                                wbl[i] = true;
                                continue block16;
                            }
                            case 204: {
                                wbl[i] = false;
                                continue block16;
                            }
                            default: {
                                throw new IOException("portInSequence boolean " + b);
                            }
                        }
                    }
                    return wbl;
                }
            }
            return this.portInSeqObject(len);
        }
        return this.portInSeqString(len);
    }

    Object portInSparse(int tag) throws IOException {
        throw new IOException("portInSparse not implemented " + tag);
    }

    Object portInObject(int tag) throws IOException {
        throw new IOException("portInObject not implemented" + tag);
    }

    Object[] portInOp() throws IOException {
        return this.portInOp(this.streamInCode());
    }

    static String stringValue(Object x) {
        if (x == null) {
            return "Null";
        }
        return x.toString();
    }

    Object[] portInOp(int tag) throws IOException {
        if (tag != 206) {
            throw new IOException("portInOp tag " + tag);
        }
        CharSequence op = this.portInString();
        long opix = this.portInLong();
        int len = (int)this.portInLong();
        Object[] w = new Object[len + 2];
        w[0] = op;
        w[1] = new Long(opix);
        for (int i = 0; i < len; ++i) {
            w[i + 2] = this.streamInValue();
        }
        String s1 = "Unknown";
        String s2 = "Unknown";
        if (len > 0) {
            s1 = AGDirectLink.stringValue(w[2]);
        }
        if (len > 1) {
            s2 = AGDirectLink.stringValue(w[3]);
        }
        if (opix < 0L) {
            throw new IllegalArgumentException("Operation " + op + "[" + -opix + "] signalled an error in server: " + s1 + " -- " + s2);
        }
        return w;
    }

    Object[] portInOpOb(int tag) throws IOException {
        if (tag != 206) {
            throw new IOException("portInOp tag " + tag);
        }
        CharSequence op = this.portInString();
        long opix = this.portInLong();
        int len = (int)this.portInLong();
        Object[] rr = new Object[len];
        Object[] ww = new Object[]{op, new Long(opix), rr};
        for (int i = 0; i < len; ++i) {
            rr[i] = this.streamInValue();
        }
        if (opix < 0L) {
            String s1 = "Unknown";
            String s2 = "Unknown";
            if (len > 0) {
                s1 = AGDirectLink.stringValue(rr[0]);
            }
            if (len > 1) {
                s2 = AGDirectLink.stringValue(rr[1]);
            }
            throw new IllegalArgumentException("Operation " + op + "[" + -opix + "] signalled an error in server: " + s1 + " -- " + s2);
        }
        return ww;
    }

    int portIn_8() throws IOException {
        int res;
        try {
            res = this.inStream.read();
        }
        catch (IOException e) {
            res = -107;
        }
        if (res < 0) {
            AGDirectLink.throwIOErr("portIn", res);
        }
        return res;
    }

    byte[] portInBytes() throws IOException {
        return this.portInBytes(this.streamInCode());
    }

    byte[] portInBytes(int tag) throws IOException {
        if (tag != 210) {
            throw new IOException("portInOp tag " + tag);
        }
        byte[] b = new byte[(int)this.portInLong()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(0xFF & this.portIn_8());
        }
        return b;
    }

    UPIImpl portInUPI() throws IOException {
        return this.portInUPI(this.streamInCode());
    }

    UPIImpl portInUPI(int tag) throws IOException {
        if (tag != 211) {
            throw new IOException("portInOp tag " + tag);
        }
        UPIImpl u = new UPIImpl();
        for (int i = 0; i < 12; ++i) {
            u.addByte(this.portIn_8());
        }
        return u;
    }

    int portOutInteger(long x) {
        int len;
        int top;
        int tag;
        long v = x;
        int sign = 0;
        if (v < 0L) {
            v = -(1L + v);
            sign = 32;
        }
        if (v < 23L) {
            tag = -1;
            top = 0;
            len = 1;
        } else if (v < 279L) {
            tag = 0;
            top = 8;
            len = 2;
            v -= 23L;
        } else if (v < 65536L) {
            tag = 1;
            top = 16;
            len = 3;
        } else if (v < 0x1000000L) {
            tag = 2;
            top = 24;
            len = 4;
        } else if (v < 0x100000000L) {
            tag = 3;
            top = 32;
            len = 5;
        } else if (v < 0x10000000000L) {
            tag = 4;
            top = 40;
            len = 6;
        } else if (v < 0x1000000000000L) {
            tag = 5;
            top = 48;
            len = 7;
        } else if (v < 0x100000000000000L) {
            tag = 6;
            top = 56;
            len = 8;
        } else {
            tag = 7;
            top = 64;
            len = 9;
        }
        int rc = this.portReserveSpace(len);
        if (rc < 0) {
            return rc;
        }
        tag = tag < 0 ? (int)v : 23 + tag;
        tag = tag | sign | 0x80;
        this.bufferOut_8(tag);
        for (int shift = 0; shift < top; shift += 8) {
            this.bufferOut_8((int)(0xFFL & v >> shift));
        }
        return this.endpos;
    }

    long portInLong() throws IOException {
        return this.portInLong(this.portIn_8());
    }

    long portInLong(int tag) throws IOException {
        if (tag < 128 || tag >= 192) {
            throw new IOException("portInLong tag " + tag);
        }
        int s = tag & 0x3F;
        int count = 0;
        boolean neg = false;
        if (s < 23) {
            return s;
        }
        if (s > 31) {
            neg = true;
            if ((s -= 32) < 23) {
                return -s - 1;
            }
        }
        count = s - 23 + 1;
        long v = 0L;
        int shift = 0;
        for (int j = 0; j < count; ++j) {
            long w = this.portIn_8();
            if (w < 0L) {
                throw new IOException("portInLong->portIn_8=" + w);
            }
            v |= w << shift;
            shift += 8;
        }
        if (count == 1) {
            v += 23L;
        }
        if (neg) {
            v = -v - 1L;
        }
        return v;
    }

    CharSequence portInString() throws IOException {
        return this.portInString(this.portIn_8());
    }

    CharSequence portInString(int tag) throws IOException {
        int len;
        if (tag == 192) {
            return null;
        }
        if (tag < 222) {
            throw new IOException("portInString tag " + tag);
        }
        if (tag == 222) {
            len = (int)this.portInLong();
        } else if (tag >= 224 && tag < 256) {
            len = tag - 224;
        } else {
            throw new IOException("portInString tag " + tag);
        }
        StringBuffer v = new StringBuffer(len);
        int run = 0;
        char runChar = '\u0000';
        for (int i = 0; i < len; ++i) {
            if (run == 0) {
                int x = this.streamInCode();
                if (x == 223) {
                    run = (int)this.portInLong();
                    runChar = (char)this.portInLong();
                    v.append(runChar);
                    --run;
                    continue;
                }
                v.append((char)this.portInLong(x));
                continue;
            }
            v.append(runChar);
            --run;
        }
        return new String(v);
    }

    double portInDouble() throws IOException {
        return this.portInDouble(this.streamInCode());
    }

    double portInDouble(int tag) throws IOException {
        if (tag != 198) {
            throw new IOException("portInDouble tag " + tag);
        }
        int s = this.portIn_8();
        if (s < 0) {
            throw new IOException("portInDouble->portIn_8=" + s);
        }
        long e0 = this.portIn_8();
        if (e0 < 0L) {
            throw new IOException("portInDouble->portIn_8=" + e0);
        }
        long e1 = this.portIn_8();
        if (e1 < 0L) {
            throw new IOException("portInDouble->portIn_8=" + e1);
        }
        long v = 0L;
        for (int shift = 0; shift < 51; shift += 8) {
            long w = this.portIn_8();
            if (w < 0L) {
                throw new IOException("portInDouble->portIn_8=" + w);
            }
            v |= w << shift;
        }
        v |= (e1 << 8 | e0) << 52;
        if (s != 0) {
            v |= Long.MIN_VALUE;
        }
        double r = Double.longBitsToDouble(v);
        return r;
    }

    float portInFloat() throws IOException {
        return this.portInFloat(this.streamInCode());
    }

    float portInFloat(int tag) throws IOException {
        if (tag != 197) {
            throw new IOException("portInFloat tag " + tag);
        }
        int s = this.portIn_8();
        if (s < 0) {
            throw new IOException("portInFloat->portIn_8=" + s);
        }
        int e0 = this.portIn_8();
        if (e0 < 0) {
            throw new IOException("portInFloat->portIn_8=" + e0);
        }
        int e1 = this.portIn_8();
        if (e1 < 0) {
            throw new IOException("portInFloat->portIn_8=" + e1);
        }
        int v = 0;
        for (int shift = 0; shift < 23; shift += 8) {
            int w = this.portIn_8();
            if (w < 0) {
                throw new IOException("portInFloat->portIn_8=" + w);
            }
            v |= w << shift;
        }
        v |= (e1 << 8 | e0) << 23;
        if (s != 0) {
            v |= Integer.MIN_VALUE;
        }
        float r = Float.intBitsToFloat(v);
        return r;
    }

    int portFlush() {
        if (this.endpos > 0) {
            try {
                this.outStream.write(this.buffer, 0, this.endpos);
                this.outStream.flush();
            }
            catch (Exception e) {
                return -108;
            }
        }
        this.endpos = 0;
        return 0;
    }

    int portReserveSpace(int size) {
        int rc = 0;
        if (this.endpos + size > this.buffer.length) {
            rc = this.portFlush();
        }
        if (rc < 0) {
            return rc;
        }
        return this.endpos + size;
    }

    int portOutTag(int tag) {
        int rc = this.portReserveSpace(1);
        if (rc < 0) {
            return rc;
        }
        rc = this.bufferOut_8(tag);
        return rc;
    }

    int portOut(int tag, long v) {
        int rc = 0;
        if (0 < tag) {
            rc = this.portOutTag(tag);
        }
        if (rc >= 0) {
            rc = this.portOutInteger(v);
        }
        return rc;
    }

    int portOut(boolean x) {
        if (x) {
            return this.portOutTag(203);
        }
        return this.portOutTag(204);
    }

    int portOut(byte x) {
        return this.portOut(193, x);
    }

    int portOut(char x) {
        return this.portOut(196, x);
    }

    int portOut(short x) {
        return this.portOut(194, x);
    }

    int portOut(int x) {
        return this.portOut(195, x);
    }

    int portOut(long x) {
        return this.portOut(0, x);
    }

    int portOutSeqHead(String from, int len, int tag) {
        int rc;
        if (from == "") {
            from = "";
        }
        if ((rc = this.portReserveSpace(1)) < 0) {
            return rc;
        }
        this.bufferOut_8(200);
        rc = this.portOutInteger(len);
        if (rc < 0) {
            return rc;
        }
        rc = this.portReserveSpace(1);
        if (rc < 0) {
            return rc;
        }
        this.bufferOut_8(tag);
        return this.endpos;
    }

    int portOut(byte[] x) {
        int rc = this.portReserveSpace(1);
        if (rc < 0) {
            return rc;
        }
        this.bufferOut_8(210);
        rc = this.portOutInteger(x.length);
        if (rc < 0) {
            return rc;
        }
        for (int i = 0; i < x.length; ++i) {
            rc = this.portReserveSpace(1);
            if (rc < 0) {
                return rc;
            }
            this.bufferOut_8(x[i]);
        }
        return this.endpos;
    }

    int portOut(UPI x) {
        return this.portOut((UPIImpl)x);
    }

    int portOut(UPIImpl x) {
        if (null == x.getUpi()) {
            return this.portOut(x.getCode());
        }
        int rc = this.portReserveSpace(1);
        if (rc < 0) {
            return rc;
        }
        this.bufferOut_8(211);
        int b = 0;
        int i = 0;
        while (b > -1) {
            if ((b = x.getByte(i++)) <= -1) continue;
            rc = this.portReserveSpace(1);
            if (rc < 0) {
                return rc;
            }
            this.bufferOut_8(b);
        }
        return this.endpos;
    }

    int portOut(UPI[] x) {
        this.portOutSeqHead("UPI", x.length, 211);
        for (int i = 0; i < x.length; ++i) {
            this.portOut(x[i]);
        }
        return this.endpos;
    }

    int portOut(short[] x) {
        this.portOutSeqHead("short", x.length, 194);
        for (int i = 0; i < x.length; ++i) {
            this.portOutInteger(x[i]);
        }
        return this.endpos;
    }

    int portOut(int[] x) {
        this.portOutSeqHead("int", x.length, 195);
        for (int i = 0; i < x.length; ++i) {
            this.portOutInteger(x[i]);
        }
        return this.endpos;
    }

    int portOut(long[] x) {
        this.portOutSeqHead("long", x.length, 128);
        for (int i = 0; i < x.length; ++i) {
            this.portOutInteger(x[i]);
        }
        return this.endpos;
    }

    int portOut(float[] x) {
        this.portOutSeqHead("float", x.length, 197);
        for (int i = 0; i < x.length; ++i) {
            this.portOut(x[i]);
        }
        return this.endpos;
    }

    int portOut(double[] x) {
        this.portOutSeqHead("double", x.length, 198);
        for (int i = 0; i < x.length; ++i) {
            this.portOut(x[i]);
        }
        return this.endpos;
    }

    int portOut(CharSequence[] x) {
        this.portOutSeqHead("String", x.length, 222);
        for (int i = 0; i < x.length; ++i) {
            this.portOut(x[i]);
        }
        return this.endpos;
    }

    int portOut(float x) {
        int rc = this.portReserveSpace(7);
        if (rc < 0) {
            return rc;
        }
        int b = Float.floatToRawIntBits(x);
        int s = 0;
        if (b < 0) {
            b ^= Integer.MIN_VALUE;
            s = 1;
        }
        int e = b >> 23;
        b |= 0x7F800000;
        b ^= 0x7F800000;
        this.bufferOut_8(197);
        this.bufferOut_8(s);
        this.bufferOut_16(e);
        for (int shift = 0; shift < 23; shift += 8) {
            this.bufferOut_8((int)(0xFFL & (long)(b >> shift)));
        }
        return this.endpos;
    }

    int portOut(double x) {
        int rc = this.portReserveSpace(11);
        if (rc < 0) {
            return rc;
        }
        long b = Double.doubleToRawLongBits(x);
        int s = 0;
        if (b < 0L) {
            b ^= Long.MIN_VALUE;
            s = 1;
        }
        int e = (int)(b >> 52);
        b |= 0x7FF0000000000000L;
        b ^= 0x7FF0000000000000L;
        this.bufferOut_8(198);
        this.bufferOut_8(s);
        this.bufferOut_16(e);
        for (int shift = 0; shift < 52; shift += 8) {
            this.bufferOut_8((int)(0xFFL & b >> shift));
        }
        return this.endpos;
    }

    int portOut(CharSequence x) {
        int rc;
        if (x == null) {
            return this.portOutNull();
        }
        int len = x.length();
        if (len < 32) {
            rc = this.portReserveSpace(1);
            if (rc < 0) {
                return rc;
            }
            this.bufferOut_8(224 + len);
            for (int i = 0; i < len; ++i) {
                this.portOutInteger(x.charAt(i));
            }
        } else {
            rc = this.portReserveSpace(1);
            if (rc < 0) {
                return rc;
            }
            this.bufferOut_8(222);
            rc = this.portOutInteger(len);
            if (rc < 0) {
                return rc;
            }
            int run = 0;
            char runChar = '\u0000';
            for (int i = 0; i < len; ++i) {
                char c = x.charAt(i);
                if (run == 0) {
                    run = 1;
                    runChar = c;
                    continue;
                }
                if (runChar == c) {
                    ++run;
                    continue;
                }
                rc = this.portOutFragment(run, runChar);
                if (rc < 0) {
                    return rc;
                }
                run = 1;
                runChar = c;
            }
            rc = this.portOutFragment(run, runChar);
        }
        return rc;
    }

    int portOutFragment(int run, int runChar) {
        int rc = this.endpos;
        if (run < 5) {
            for (int j = 0; j < run; ++j) {
                rc = this.portOutInteger(runChar);
                if (rc >= 0) continue;
                return rc;
            }
        } else {
            rc = this.portReserveSpace(1);
            if (rc >= 0) {
                this.bufferOut_8(223);
            }
            if (rc >= 0) {
                rc = this.portOutInteger(run);
            }
            if (rc >= 0) {
                rc = this.portOutInteger(runChar);
            }
        }
        return rc;
    }

    int portOutNull() {
        return this.portOutTag(192);
    }

    int portOutUnwrapped(Object arg) throws IOException {
        if (arg == null) {
            return this.portOutNull();
        }
        if (arg instanceof Boolean) {
            return this.portOut((Boolean)arg);
        }
        if (arg instanceof Byte) {
            return this.portOut((Byte)arg);
        }
        if (arg instanceof Short) {
            return this.portOut((Short)arg);
        }
        if (arg instanceof Integer) {
            return this.portOut((Integer)arg);
        }
        if (arg instanceof Long) {
            return this.portOut((Long)arg);
        }
        if (arg instanceof Float) {
            return this.portOut(((Float)arg).floatValue());
        }
        if (arg instanceof Double) {
            return this.portOut((Double)arg);
        }
        if (arg instanceof byte[]) {
            return this.portOut((byte[])arg);
        }
        if (arg instanceof UPIImpl) {
            return this.portOut((UPIImpl)arg);
        }
        if (arg instanceof UPI[]) {
            return this.portOut((UPI[])arg);
        }
        if (arg instanceof short[]) {
            return this.portOut((short[])arg);
        }
        if (arg instanceof int[]) {
            return this.portOut((int[])arg);
        }
        if (arg instanceof long[]) {
            return this.portOut((long[])arg);
        }
        if (arg instanceof float[]) {
            return this.portOut((float[])arg);
        }
        if (arg instanceof double[]) {
            return this.portOut((double[])arg);
        }
        if (arg instanceof String) {
            return this.portOut((String)arg);
        }
        if (arg instanceof String[]) {
            return this.portOut((String[])arg);
        }
        throw new IOException("Cannot unwrap " + arg);
    }

    int bufferOut_8(int x) {
        this.buffer[this.endpos] = (byte)(0xFF & x);
        ++this.endpos;
        return this.endpos;
    }

    int bufferOut_16(int x) {
        this.buffer[this.endpos] = (byte)(0xFF & x);
        ++this.endpos;
        this.buffer[this.endpos] = (byte)(0xFF & x >> 8);
        ++this.endpos;
        return this.endpos;
    }

    static class Op {
        private String op;
        private long opix;
        private Object[] vals;

        String getOp() {
            return this.op;
        }

        long getOpix() {
            return this.opix;
        }

        Object[] getVals() {
            return this.vals;
        }

        Op(String op, long opix, Object[] vals) {
            this.op = op;
            this.opix = opix;
            this.vals = vals;
        }
    }
}

