/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.transport;

import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.transport.AGDirectLink;
import java.io.IOException;

class AGDirectLinkDebug
extends AGDirectLink {
    void dp(int level, String text) {
        if (level <= debugClient) {
            String head = "";
            for (int i = 0; i < level; ++i) {
                head = head + "  ";
            }
            System.out.println(head + text);
        }
    }

    AGDirectLinkDebug() {
    }

    AGDirectLinkDebug(String host, int port, int pc, int pi) throws IOException {
        super(host, port, pc, pi);
        this.dp(1, "new " + host + ":" + port + " " + pc + "/" + pi);
    }

    AGDirectLinkDebug(String host, int port, int pc, int pi, int timeout) throws IOException {
        super(host, port, pc, pi, timeout);
        this.dp(1, "new " + host + ":" + port + " " + pc + "/" + pi + " timout " + timeout);
    }

    @Override
    int sendOpHeader(String op, int style, int argCount) throws IOException {
        this.dp(1, "opHeader: " + op + " " + style + " " + argCount);
        return super.sendOpHeader(op, style, argCount);
    }

    @Override
    Object sendOpTail(String op, int opix, int style, int rx) throws IOException {
        this.dp(1, "opTail: " + op + " " + opix);
        return super.sendOpTail(op, opix, style, rx);
    }

    @Override
    Object opResIn(String op, int opix, int rx) throws IOException {
        Object r = super.opResIn(op, opix, rx);
        this.dp(1, "opRes=" + op + " " + opix + " " + r);
        return r;
    }

    @Override
    Object streamInValue(int tag) throws IOException {
        Object w = super.streamInValue(tag);
        this.dp(2, "streamIn=" + tag + ": " + w);
        return w;
    }

    @Override
    Object portInSeqBody(int tag, int len, int sub) throws IOException {
        this.dp(2, "portInSequence:" + tag + "(" + len + ")" + sub);
        Object w = super.portInSeqBody(tag, len, sub);
        this.dp(2, "portInSequence=" + w);
        return w;
    }

    @Override
    Object[] portInOp(int tag) throws IOException {
        this.dp(2, "portInOp:0x" + Integer.toHexString(tag));
        return super.portInOp(tag);
    }

    @Override
    int portIn_8() throws IOException {
        int res = super.portIn_8();
        this.dp(5, "portIn_8=" + res + "  0x" + Integer.toHexString(res) + "  0b" + Integer.toBinaryString(res));
        return res;
    }

    @Override
    int portOutInteger(long x) {
        this.dp(4, "portOutInteger: " + x);
        return super.portOutInteger(x);
    }

    @Override
    long portInLong(int tag) throws IOException {
        this.dp(2, "portInLong: tag=0x" + Integer.toHexString(tag));
        long r = super.portInLong(tag);
        this.dp(2, "portInLong= " + r);
        return r;
    }

    @Override
    CharSequence portInString(int tag) throws IOException {
        this.dp(2, "portInString: tag 0x" + Integer.toHexString(tag));
        CharSequence v = super.portInString(tag);
        this.dp(2, "portInString= " + v);
        return v;
    }

    @Override
    double portInDouble(int tag) throws IOException {
        double r = super.portInDouble(tag);
        this.dp(2, "portInDouble= " + r);
        return r;
    }

    @Override
    float portInFloat(int tag) throws IOException {
        float r = super.portInFloat(tag);
        this.dp(2, "portInFloat= " + r);
        return r;
    }

    @Override
    byte[] portInBytes(int tag) throws IOException {
        byte[] b = super.portInBytes(tag);
        this.dp(2, "portInBytes= " + b.length);
        return b;
    }

    @Override
    UPIImpl portInUPI(int tag) throws IOException {
        UPIImpl b = super.portInUPI(tag);
        this.dp(2, "portInUPI= " + b);
        return b;
    }

    @Override
    int portFlush() {
        if (this.endpos > 0) {
            this.dp(4, "portFlush: " + this.endpos + " bytes: " + this.buffer[0] + " " + this.buffer[1] + "...");
        }
        return super.portFlush();
    }

    @Override
    int portOutTag(int tag) {
        int rc = super.portOutTag(tag);
        this.dp(4, "portOut tag= " + tag);
        return rc;
    }

    @Override
    int portOut(byte x) {
        this.dp(2, "portOut byte: " + x);
        return super.portOut(x);
    }

    @Override
    int portOut(char x) {
        this.dp(2, "portOut char: " + x);
        return super.portOut(x);
    }

    @Override
    int portOut(short x) {
        this.dp(2, "portOut short: " + x);
        return super.portOut(x);
    }

    @Override
    int portOut(int x) {
        this.dp(2, "portOut int: " + x);
        return super.portOut(x);
    }

    @Override
    int portOut(long x) {
        this.dp(2, "portOut long: " + x);
        return super.portOut(x);
    }

    @Override
    int portOutSeqHead(String from, int len, int tag) {
        this.dp(2, "portOut seq: of " + from + "[" + len + "] tag=" + Integer.toHexString(tag));
        return super.portOutSeqHead(from, len, tag);
    }

    @Override
    int portOut(float x) {
        this.dp(2, "portOut float: " + x);
        return super.portOut(x);
    }

    @Override
    int portOut(double x) {
        this.dp(2, "portOut double: " + x);
        return super.portOut(x);
    }

    @Override
    int portOut(CharSequence x) {
        this.dp(2, "portOut String: " + x);
        return super.portOut(x);
    }

    @Override
    int portOut(UPIImpl x) {
        this.dp(2, "portOut UPI: " + x);
        return super.portOut(x);
    }

    @Override
    int bufferOut_8(int x) {
        this.dp(5, "bufferOut_8: " + x + "  0x" + Integer.toHexString(x) + "  0b" + Integer.toBinaryString(x));
        return super.bufferOut_8(x);
    }

    @Override
    int bufferOut_16(int x) {
        this.dp(5, "bufferOut_16: " + x);
        return super.bufferOut_16(x);
    }
}

