/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.SPARQLQuery;
import com.franz.agbase.ValueSetIterator;
import com.franz.agsail.AGForSail;
import com.franz.agsail.AGSailCursor;
import com.knowledgereefsystems.agsail.AllegroSail;
import com.knowledgereefsystems.agsail.AllegroSailException;
import com.knowledgereefsystems.agsail.ContextIteration;
import com.knowledgereefsystems.agsail.NamespaceIteration;
import com.knowledgereefsystems.agsail.ResourceIteration;
import com.knowledgereefsystems.agsail.SailConnectionTripleSource;
import com.knowledgereefsystems.agsail.StatementIteration;
import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;

public class AllegroSailConnection
implements SailConnection {
    private final AGForSail aGraph;
    private final AllegroGraphConnection agConnection;
    private final AllegroSail sail;
    private final ValueFactory valueFactory;
    private final Collection<SailChangedListener> sailChangedListeners;
    private final Set<SailConnectionListener> sailConnectionListeners = new HashSet<SailConnectionListener>();
    private boolean open = true;
    private boolean uncommittedInsertions;
    private boolean uncommittedDeletions;

    public boolean isUncommittedInsertions() {
        return this.uncommittedInsertions;
    }

    public void setUncommittedInsertions(boolean uncommittedInsertions) {
        this.uncommittedInsertions = uncommittedInsertions;
    }

    public boolean isUncommittedDeletions() {
        return this.uncommittedDeletions;
    }

    public void setUncommittedDeletions(boolean uncommittedDeletions) {
        this.uncommittedDeletions = uncommittedDeletions;
    }

    public AllegroSailConnection(AGForSail aGraph, AllegroGraphConnection agConn, AllegroSail sail, Collection<SailChangedListener> sailChangedListeners) {
        this.aGraph = aGraph;
        this.sail = sail;
        this.valueFactory = sail.getValueFactory();
        this.agConnection = agConn;
        this.sailChangedListeners = sailChangedListeners;
        this.uncommittedDeletions = false;
        this.uncommittedInsertions = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(SailConnectionListener listener) {
        Set<SailConnectionListener> set = this.sailConnectionListeners;
        synchronized (set) {
            this.sailConnectionListeners.add(listener);
        }
    }

    public void addStatement(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        try {
            if (0 == contexts.length) {
                this.aGraph.addStatement(subject, predicate, object);
                this.statementAdded(subject, predicate, object, null);
            } else {
                for (Resource c : contexts) {
                    if (null == c) {
                        this.aGraph.addStatement(subject, predicate, object);
                        this.statementAdded(subject, predicate, object, null);
                        continue;
                    }
                    this.aGraph.addStatement(subject, predicate, object, c);
                    this.statementAdded(subject, predicate, object, c);
                }
            }
            this.uncommittedInsertions = true;
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
        if (this.sailChangedListeners.size() > 0) {
            DefaultSailChangedEvent event = new DefaultSailChangedEvent((Sail)this.sail);
            event.setStatementsAdded(true);
            for (SailChangedListener listener : this.sailChangedListeners) {
                listener.sailChanged((SailChangedEvent)event);
            }
        }
    }

    public void clear(Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            try {
                this.aGraph.clear();
                this.uncommittedDeletions = true;
            }
            catch (AllegroGraphException e) {
                throw new AllegroSailException(e);
            }
        } else {
            this.removeStatements(null, null, null, contexts);
        }
    }

    public void clearNamespaces() throws SailException {
        String[] nsArray = this.agConnection.getNamespaces();
        for (int i = 0; i < nsArray.length; i += 2) {
            this.removeNamespace(nsArray[i]);
        }
    }

    public void close() throws SailException {
        this.open = false;
    }

    public void commit() throws SailException {
        if (this.sail.isReindexOnCommit() && (this.uncommittedInsertions || this.uncommittedDeletions)) {
            try {
                if (this.sail.isIndexAllOnCommit()) {
                    this.aGraph.indexAllTriples(!this.sail.isBackgroundIndexing());
                } else {
                    this.aGraph.indexNewTriples(!this.sail.isBackgroundIndexing());
                }
            }
            catch (AllegroGraphException e) {
                throw new AllegroSailException(e);
            }
            this.uncommittedInsertions = false;
            this.uncommittedInsertions = false;
        }
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataSet, BindingSet bindings, boolean includeInferred) throws SailException {
        return this.evaluateByDecomposition(tupleExpr, dataSet, bindings, includeInferred);
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        ValueSetIterator it;
        SPARQLQuery sq = new SPARQLQuery();
        sq.setTripleStore(this.aGraph.getDirectInstance());
        sq.setQuery("SELECT DISTINCT ?g WHERE { GRAPH ?g { ?s ?p ?o }}");
        try {
            it = sq.select();
        }
        catch (AllegroGraphException e) {
            throw new SailException((Throwable)e);
        }
        return new ContextIteration(this.aGraph, it);
    }

    public String getNamespace(String prefix) throws SailException {
        String[] nsArray;
        try {
            nsArray = this.agConnection.getNamespaces();
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
        for (int i = 0; i < nsArray.length; i += 2) {
            if (!nsArray[i].equals(prefix)) continue;
            return nsArray[i + 1];
        }
        return null;
    }

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        String[] nsArray;
        try {
            nsArray = this.aGraph.getDirectInstance().getNamespaces();
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
        return new NamespaceIteration(nsArray);
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subject, URI predicate, Value object, boolean includeInferred, Resource ... contexts) throws SailException {
        AGSailCursor[] cursors;
        try {
            if (0 == contexts.length) {
                cursors = new AGSailCursor[]{this.aGraph.getStatements(includeInferred, subject, predicate, object, null)};
            } else {
                cursors = new AGSailCursor[contexts.length];
                for (int i = 0; i < contexts.length; ++i) {
                    Resource c = contexts[i];
                    cursors[i] = null == c ? this.aGraph.getStatements(includeInferred, subject, predicate, object) : this.aGraph.getStatements(includeInferred, subject, predicate, object, c);
                }
            }
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
        return new StatementIteration(cursors, this.valueFactory);
    }

    public boolean isOpen() throws SailException {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(SailConnectionListener listener) {
        Set<SailConnectionListener> set = this.sailConnectionListeners;
        synchronized (set) {
            this.sailConnectionListeners.remove(listener);
        }
    }

    public void removeNamespace(String prefix) throws SailException {
        try {
            this.agConnection.registerNamespace(prefix, null);
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
    }

    public void removeStatements(Resource subject, URI predicate, Value object, Resource ... contexts) throws SailException {
        try {
            if (0 == contexts.length) {
                this.aGraph.removeStatements(subject, predicate, object, new Resource[0]);
                this.statementRemoved(subject, predicate, object, null);
                this.uncommittedDeletions = true;
            } else {
                for (Resource c : contexts) {
                    this.aGraph.removeStatements(subject, predicate, object, c);
                    this.statementRemoved(subject, predicate, object, c);
                    this.uncommittedDeletions = true;
                }
            }
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
        if (this.sailChangedListeners.size() > 0) {
            DefaultSailChangedEvent event = new DefaultSailChangedEvent((Sail)this.sail);
            event.setStatementsRemoved(true);
            for (SailChangedListener listener : this.sailChangedListeners) {
                listener.sailChanged((SailChangedEvent)event);
            }
        }
    }

    public void rollback() throws SailException {
        this.uncommittedDeletions = false;
        this.uncommittedInsertions = false;
    }

    public void setNamespace(String prefix, String name) throws SailException {
        try {
            this.agConnection.registerNamespace(prefix, name);
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
    }

    public long size(Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            try {
                return this.aGraph.numberOfTriples();
            }
            catch (AllegroGraphException e) {
                throw new AllegroSailException(e);
            }
        }
        return 0L;
    }

    public void registerFreetextPredicate(URI predicate) throws SailException {
        try {
            this.aGraph.registerFreetextPredicate(predicate);
        }
        catch (Throwable t) {
            throw new SailException(t);
        }
    }

    public CloseableIteration<? extends Statement, SailException> getFreetextStatements(String pattern) throws SailException {
        AGSailCursor[] c = new AGSailCursor[1];
        try {
            c[0] = this.aGraph.getFreetextStatements(pattern);
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
        return new StatementIteration(c, this.valueFactory);
    }

    public CloseableIteration<? extends Resource, SailException> getFreetextUniqueSubjects(String pattern) throws SailException {
        ValueSetIterator c;
        try {
            c = this.aGraph.getFreetextUniqueSubjects(pattern);
        }
        catch (Throwable t) {
            throw new AllegroSailException(t);
        }
        return new ResourceIteration(this.aGraph, c);
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateByDecomposition(TupleExpr tupleExpr, Dataset dataSet, BindingSet bindings, boolean includeInferred) throws SailException {
        try {
            SailConnectionTripleSource tripleSource = new SailConnectionTripleSource(this, this.valueFactory, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataSet);
            return strategy.evaluate(tupleExpr, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statementAdded(Resource subject, URI predicate, Value object, Resource context) {
        if (this.sailConnectionListeners.size() > 0) {
            Statement st = null == context ? this.aGraph.createStatement(subject, predicate, object) : this.aGraph.createStatement(subject, predicate, object, context);
            Set<SailConnectionListener> set = this.sailConnectionListeners;
            synchronized (set) {
                for (SailConnectionListener l : this.sailConnectionListeners) {
                    l.statementAdded(st);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statementRemoved(Resource subject, URI predicate, Value object, Resource context) {
        if (this.sailConnectionListeners.size() > 0) {
            StatementImpl st = null == context ? new StatementImpl(subject, predicate, object) : new ContextStatementImpl(subject, predicate, object, context);
            Set<SailConnectionListener> set = this.sailConnectionListeners;
            synchronized (set) {
                for (SailConnectionListener l : this.sailConnectionListeners) {
                    l.statementRemoved((Statement)st);
                }
            }
        }
    }
}

