/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.knowledgereefsystems.agsail.AllegroSailException;
import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.sail.SailException;

public class NamespaceIteration
implements CloseableIteration<Namespace, SailException> {
    private String[] nsArray;
    private int cur;
    private int size;
    private boolean closed = false;

    public NamespaceIteration(String[] nsArray) throws SailException {
        this.nsArray = nsArray;
        this.cur = 0;
        if (null == nsArray) {
            this.close();
        } else {
            this.size = nsArray.length / 2;
        }
    }

    public void close() throws SailException {
        this.nsArray = null;
        this.closed = true;
        this.size = 0;
    }

    public boolean hasNext() throws SailException {
        return this.cur < this.size;
    }

    public Namespace next() throws SailException {
        if (this.closed) {
            throw new AllegroSailException("iterator has been closed");
        }
        String prefix = this.nsArray[this.cur * 2];
        String name = this.nsArray[this.cur * 2 + 1];
        NamespaceImpl ns = new NamespaceImpl(prefix, name);
        ++this.cur;
        return ns;
    }

    public void remove() throws SailException {
        if (this.closed) {
            throw new AllegroSailException("iterator has been closed");
        }
    }
}

