/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.franz.agbase.ValueNode;
import com.franz.agbase.ValueSetIterator;
import com.franz.agsail.AGForSail;
import com.franz.agsail.AGSailValueObject;
import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Resource;
import org.openrdf.sail.SailException;

public class ResourceIteration
implements CloseableIteration<Resource, SailException> {
    private AGSailValueObject[] values;
    private int index = 0;
    private boolean withValit = false;
    private AGForSail ags;
    private ValueSetIterator valit;

    public ResourceIteration(AGSailValueObject[] values) {
        this.values = values;
    }

    public ResourceIteration(AGForSail ags, ValueSetIterator valit) {
        if (1 != valit.width()) {
            throw new IllegalArgumentException("");
        }
        this.valit = valit;
        this.ags = ags;
        this.withValit = true;
    }

    public void close() throws SailException {
        this.values = null;
        this.valit = null;
        this.withValit = false;
    }

    public boolean hasNext() throws SailException {
        if (this.withValit) {
            return this.valit.hasNext();
        }
        return this.index < this.values.length;
    }

    public Resource next() throws SailException {
        if (this.withValit) {
            return (Resource)this.ags.coerceToSailValue((ValueNode)this.valit.next(0));
        }
        Resource r = (Resource)this.values[this.index];
        ++this.index;
        return r;
    }

    public void remove() throws SailException {
        if (this.withValit) {
            this.valit.remove();
        }
    }
}

