/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.AGErrorType;

public class AGErrorInfo {
    private AGErrorType errorType;
    private String errMSg;

    public AGErrorInfo(String errMsg) {
        assert (errMsg != null) : "errMsg must not be null";
        this.errMSg = errMsg;
    }

    public AGErrorInfo(AGErrorType errorType, String errMsg) {
        this(errMsg);
        this.errorType = errorType;
    }

    public AGErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errMSg;
    }

    public String toString() {
        if (this.errorType != null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.errorType);
            sb.append(": ");
            sb.append(this.errMSg);
            return sb.toString();
        }
        return this.errMSg;
    }

    public static AGErrorInfo parse(String errInfoString) {
        String label;
        String message = errInfoString;
        AGErrorType errorType = null;
        int colonIdx = errInfoString.indexOf(58);
        if (colonIdx >= 0 && (errorType = AGErrorType.forLabel(label = errInfoString.substring(0, colonIdx).trim())) != null) {
            message = errInfoString.substring(colonIdx + 1);
        }
        return new AGErrorInfo(errorType, message.trim());
    }
}

