/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGGraph;
import com.franz.agraph.repository.AGValueFactory;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.repository.RepositoryException;

public class AGBulkUpdateHandler
extends SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    private final AGGraph graph;

    public AGBulkUpdateHandler(AGGraph graph) {
        super((GraphWithPerform)graph);
        this.graph = graph;
    }

    protected void add(List<Triple> triples, boolean notify) {
        AGValueFactory vf = this.graph.getConnection().getValueFactory();
        ArrayList<StatementImpl> statements = new ArrayList<StatementImpl>(triples.size());
        for (Triple tr : triples) {
            statements.add(new StatementImpl(vf.asResource(tr.getSubject()), vf.asURI(tr.getPredicate()), vf.asValue(tr.getObject())));
        }
        try {
            this.graph.getConnection().add(statements, this.graph.getGraphContext());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (notify) {
            this.manager.notifyAddList((Graph)this.graph, triples);
        }
    }

    protected void delete(List<Triple> triples, boolean notify) {
        AGValueFactory vf = this.graph.getConnection().getValueFactory();
        ArrayList<StatementImpl> statements = new ArrayList<StatementImpl>(triples.size());
        for (Triple tr : triples) {
            statements.add(new StatementImpl(vf.asResource(tr.getSubject()), vf.asURI(tr.getPredicate()), vf.asValue(tr.getObject())));
        }
        try {
            this.graph.getConnection().remove(statements, this.graph.getGraphContext());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (notify) {
            this.manager.notifyDeleteList((Graph)this.graph, triples);
        }
    }

    public void removeAll() {
        try {
            this.graph.getConnection().clear(new Resource[]{this.graph.getGraphContext()});
            this.notifyRemoveAll();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

