/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import java.util.HashMap;
import java.util.Map;

public class AGErrorType {
    private static final Map<String, AGErrorType> registry = new HashMap<String, AGErrorType>();
    public static final AGErrorType MALFORMED_QUERY = AGErrorType.register("MALFORMED QUERY");
    public static final AGErrorType MALFORMED_DATA = AGErrorType.register("MALFORMED DATA");
    public static final AGErrorType UNSUPPORTED_QUERY_LANGUAGE = AGErrorType.register("UNSUPPORTED QUERY LANGUAGE");
    public static final AGErrorType UNSUPPORTED_FILE_FORMAT = AGErrorType.register("UNSUPPORTED FILE FORMAT");
    public static final AGErrorType PRECONDITION_FAILED = AGErrorType.register("PRECONDITION FAILED");
    public static final AGErrorType IO_EXCEPTION = AGErrorType.register("IO EXCEPTION");
    private String label;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AGErrorType register(String label) {
        Map<String, AGErrorType> map = registry;
        synchronized (map) {
            AGErrorType errorType = registry.get(label);
            if (errorType == null) {
                errorType = new AGErrorType(label);
                registry.put(label, errorType);
            }
            return errorType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AGErrorType forLabel(String label) {
        Map<String, AGErrorType> map = registry;
        synchronized (map) {
            return registry.get(label);
        }
    }

    protected AGErrorType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object other) {
        if (other instanceof AGErrorType) {
            return ((AGErrorType)other).getLabel().equals(this.getLabel());
        }
        return false;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toString() {
        return this.label;
    }
}

