/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpException;
import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.AGResponseHandler;
import com.franz.agraph.repository.AGQuery;
import com.franz.util.Closeable;
import info.aduna.io.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.json.JSONArray;
import org.openrdf.OpenRDFUtil;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGHttpRepoClient
implements Closeable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean usingDedicatedSession = false;
    private boolean autoCommit = true;
    private String sessionRoot;
    private String repoRoot;
    private long lifetimeInSeconds = 3600L;
    private TupleQueryResultFormat preferredTQRFormat = TupleQueryResultFormat.SPARQL;
    private BooleanQueryResultFormat preferredBQRFormat = BooleanQueryResultFormat.TEXT;
    private RDFFormat preferredRDFFormat = RDFFormat.TRIX;
    private AGHTTPClient client;
    private Repository repo;
    public ConcurrentLinkedQueue<String> savedQueryDeleteQueue;

    public AGHttpRepoClient(Repository repo, AGHTTPClient client, String repoRoot, String sessionRoot) {
        this.repo = repo;
        this.sessionRoot = sessionRoot;
        this.repoRoot = repoRoot;
        this.client = client;
        this.savedQueryDeleteQueue = new ConcurrentLinkedQueue();
    }

    public String getRoot() throws RepositoryException {
        if (this.sessionRoot != null) {
            return this.sessionRoot;
        }
        if (this.repoRoot != null) {
            return this.repoRoot;
        }
        throw new RepositoryException("This session-only connection has been closed. Re-open a new one to start using it again.");
    }

    public void setSessionLifetime(int lifetimeInSeconds) {
        this.lifetimeInSeconds = lifetimeInSeconds;
    }

    public long getSessionLifetime() {
        return this.lifetimeInSeconds;
    }

    public TupleQueryResultFormat getPreferredTQRFormat() {
        return this.preferredTQRFormat;
    }

    public void setPreferredTQRFormat(TupleQueryResultFormat preferredTQRFormat) {
        this.preferredTQRFormat = preferredTQRFormat;
    }

    public BooleanQueryResultFormat getPreferredBQRFormat() {
        return this.preferredBQRFormat;
    }

    public void setPreferredBQRFormat(BooleanQueryResultFormat preferredBQRFormat) {
        this.preferredBQRFormat = preferredBQRFormat;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.preferredRDFFormat;
    }

    public void setPreferredRDFFormat(RDFFormat preferredRDFFormat) {
        this.preferredRDFFormat = preferredRDFFormat;
    }

    public String getServerURL() {
        return this.client.getServerURL();
    }

    public AGHTTPClient getHTTPClient() {
        return this.client;
    }

    private void useDedicatedSession(boolean autoCommit) throws RepositoryException, UnauthorizedException {
        if (this.sessionRoot == null) {
            String url = AGProtocol.getSessionURL(this.getRoot());
            Header[] headers = new Header[]{};
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("lifetime", Long.toString(this.lifetimeInSeconds)), new NameValuePair("autoCommit", Boolean.toString(autoCommit))};
            AGResponseHandler handler = new AGResponseHandler("");
            try {
                this.getHTTPClient().post(url, headers, data, null, handler);
            }
            catch (RDFParseException e) {
                throw new RuntimeException(e);
            }
            catch (HttpException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("openSession: {}", (Object)this.sessionRoot);
            }
            this.sessionRoot = handler.getString();
        }
    }

    private void closeSession(String sessionRoot) throws IOException, RepositoryException, UnauthorizedException {
        if (sessionRoot != null) {
            String url = AGProtocol.getSessionCloseLocation(sessionRoot);
            Header[] headers = new Header[]{};
            NameValuePair[] params = new NameValuePair[]{};
            try {
                this.getHTTPClient().post(url, headers, params, null, null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("closeSession: {}", (Object)url);
                }
            }
            catch (RDFParseException e) {
                throw new RuntimeException(e);
            }
            finally {
                sessionRoot = null;
            }
        }
    }

    public void getStatements(Resource subj, URI pred, Value obj, String includeInferred, RDFHandler handler, Resource ... contexts) throws IOException, RDFHandlerException, RepositoryException, UnauthorizedException {
        String uri = Protocol.getStatementsLocation((String)this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        params.add(new NameValuePair("infer", includeInferred));
        try {
            this.getHTTPClient().get(uri, headers, params.toArray(new NameValuePair[params.size()]), new AGResponseHandler(this.repo, handler, this.getPreferredRDFFormat()));
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void addStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws IOException, RepositoryException, UnauthorizedException {
        String uri = Protocol.getStatementsLocation((String)this.getRoot());
        Header[] headers = new Header[]{new Header("Content-Type", RDFFormat.NTRIPLES.getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        try {
            this.getHTTPClient().post(uri, headers, params.toArray(new NameValuePair[params.size()]), null, null);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void deleteStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws RepositoryException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        try {
            this.getHTTPClient().delete(url, headers, params.toArray(new NameValuePair[params.size()]));
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        this.useDedicatedSession(autoCommit);
        String url = AGProtocol.getAutoCommitLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("on", Boolean.toString(autoCommit))};
        try {
            this.getHTTPClient().post(url, headers, params, null, null);
            this.autoCommit = autoCommit;
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isAutoCommit() throws RepositoryException {
        return this.autoCommit;
    }

    public void commit() throws RepositoryException {
        String url = this.getRoot() + "/" + "commit";
        Header[] headers = new Header[]{};
        try {
            this.getHTTPClient().post(url, headers, new NameValuePair[0], null, null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void rollback() throws RepositoryException {
        String url = this.getRoot() + "/" + "rollback";
        Header[] headers = new Header[]{};
        try {
            this.getHTTPClient().post(url, headers, new NameValuePair[0], null, null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void clearNamespaces() throws RepositoryException {
        String url = Protocol.getNamespacesLocation((String)this.getRoot());
        Header[] headers = new Header[]{};
        try {
            this.getHTTPClient().delete(url, headers, new NameValuePair[0]);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void upload(final Reader contents, String baseURI, final RDFFormat dataFormat, boolean overwrite, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        final Charset charset = dataFormat.hasCharset() ? dataFormat.getCharset() : Charset.forName("UTF-8");
        RequestEntity entity = new RequestEntity(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                return dataFormat.getDefaultMIMEType() + "; charset=" + charset.name();
            }

            public boolean isRepeatable() {
                return false;
            }

            public void writeRequest(OutputStream out) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(out, charset);
                IOUtil.transfer((Reader)contents, (Writer)writer);
                writer.flush();
            }
        };
        this.upload(entity, baseURI, overwrite, null, null, null, contexts);
    }

    public void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        InputStreamRequestEntity entity = new InputStreamRequestEntity(contents, -1L, dataFormat.getDefaultMIMEType());
        this.upload((RequestEntity)entity, baseURI, overwrite, null, null, null, contexts);
    }

    public void uploadJSON(JSONArray rows, Resource ... contexts) throws RepositoryException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        this.uploadJSON(url, rows, contexts);
    }

    public void deleteJSON(JSONArray rows, Resource ... contexts) throws RepositoryException {
        this.uploadJSON(AGProtocol.getStatementsDeleteLocation(this.getRoot()), rows, contexts);
    }

    public void uploadJSON(String url, JSONArray rows, Resource ... contexts) throws RepositoryException {
        if (rows == null) {
            return;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(rows.toString().getBytes("UTF-8"));
            InputStreamRequestEntity entity = new InputStreamRequestEntity((InputStream)in, -1L, "application/json");
            this.upload(url, (RequestEntity)entity, null, false, null, null, null, contexts);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (RDFParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void load(URI source, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        this.upload(null, baseURI, false, null, source, dataFormat, contexts);
    }

    public void load(String serverAbsolutePath, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        this.upload(null, baseURI, false, serverAbsolutePath, null, dataFormat, contexts);
    }

    public void upload(RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, URI serverSideURL, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        this.upload(url, reqEntity, baseURI, overwrite, serverSideFile, serverSideURL, dataFormat, contexts);
    }

    public void upload(String url, RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, URI serverSideURL, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException, UnauthorizedException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        ArrayList<Header> headers = new ArrayList<Header>(1);
        if (dataFormat != null) {
            headers.add(new Header("Content-Type", dataFormat.getDefaultMIMEType()));
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        if (baseURI != null && baseURI.trim().length() != 0) {
            String encodedBaseURI = Protocol.encodeValue((Value)new URIImpl(baseURI));
            params.add(new NameValuePair("baseURI", encodedBaseURI));
        }
        if (serverSideFile != null && serverSideFile.trim().length() != 0) {
            params.add(new NameValuePair("file", serverSideFile));
        }
        if (serverSideURL != null) {
            params.add(new NameValuePair("url", serverSideURL.stringValue()));
        }
        if (overwrite) {
            throw new UnsupportedOperationException();
        }
        this.getHTTPClient().post(url, headers.toArray(new Header[headers.size()]), params.toArray(new NameValuePair[params.size()]), reqEntity, null);
    }

    public TupleQueryResult getContextIDs() throws IOException, RepositoryException, UnauthorizedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getContextIDs((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getContextIDs(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException {
        String url = Protocol.getContextsLocation((String)this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredTQRFormat().getDefaultMIMEType())};
        try {
            this.getHTTPClient().get(url, headers, new NameValuePair[0], new AGResponseHandler(this.repo, handler));
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public long size(Resource ... contexts) throws IOException, RepositoryException, UnauthorizedException {
        String url = Protocol.getSizeLocation((String)this.getRoot());
        Header[] headers = new Header[]{};
        String[] encodedContexts = Protocol.encodeContexts((Resource[])contexts);
        NameValuePair[] contextParams = new NameValuePair[encodedContexts.length];
        for (int i = 0; i < encodedContexts.length; ++i) {
            contextParams[i] = new NameValuePair("context", encodedContexts[i]);
        }
        AGResponseHandler handler = new AGResponseHandler(0L);
        try {
            this.getHTTPClient().get(url, headers, contextParams, handler);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getLong();
    }

    public TupleQueryResult getNamespaces() throws IOException, RepositoryException, UnauthorizedException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getNamespaces((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getNamespaces(TupleQueryResultHandler handler) throws IOException, TupleQueryResultHandlerException, RepositoryException, UnauthorizedException {
        String url = Protocol.getNamespacesLocation((String)this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredTQRFormat().getDefaultMIMEType())};
        try {
            this.getHTTPClient().get(url, headers, new NameValuePair[0], new AGResponseHandler(this.repo, handler));
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getNamespace(String prefix) throws IOException, RepositoryException, UnauthorizedException {
        AGResponseHandler handler;
        block2: {
            String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
            Header[] headers = new Header[]{};
            handler = new AGResponseHandler("");
            try {
                this.getHTTPClient().get(url, headers, new NameValuePair[0], handler);
            }
            catch (AGHttpException e) {
                if (e.getMessage().equals("Not found.")) break block2;
                throw new RepositoryException((Throwable)e);
            }
        }
        return handler.getString();
    }

    public void setNamespacePrefix(String prefix, String name) throws RepositoryException {
        String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        try {
            this.getHTTPClient().put(url, headers, params, (RequestEntity)new StringRequestEntity(name, "text/plain", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void removeNamespacePrefix(String prefix) throws RepositoryException {
        String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
        Header[] headers = new Header[]{};
        try {
            this.getHTTPClient().delete(url, headers, new NameValuePair[0]);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void query(AGQuery q, AGResponseHandler handler) throws HttpException, RepositoryException, RDFParseException, IOException {
        String url = this.getRoot();
        if (q.isPrepared()) {
            this.processSavedQueryDeleteQueue();
            url = AGProtocol.getSavedQueryLocation(url, q.getName());
        }
        ArrayList<Header> headers = new ArrayList<Header>(5);
        headers.add(new Header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
        if (handler.getRequestMIMEType() != null) {
            headers.add(new Header("Accept", handler.getRequestMIMEType()));
        }
        List<NameValuePair> queryParams = this.getQueryMethodParameters(q);
        this.getHTTPClient().post(url, headers.toArray(new Header[headers.size()]), queryParams.toArray(new NameValuePair[queryParams.size()]), null, handler);
        if (this.sessionRoot != null && q.getName() != null) {
            q.setPrepared(true);
        }
    }

    protected List<NameValuePair> getQueryMethodParameters(AGQuery q) {
        QueryLanguage ql = q.getLanguage();
        Dataset dataset = q.getDataset();
        boolean includeInferred = q.getIncludeInferred();
        String planner = q.getPlanner();
        Binding[] bindings = q.getBindingsArray();
        String save = q.getName();
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>(bindings.length + 10);
        if (!q.isPrepared()) {
            queryParams.add(new NameValuePair("queryLn", ql.getName()));
            queryParams.add(new NameValuePair("query", q.getQueryString()));
            queryParams.add(new NameValuePair("infer", Boolean.toString(includeInferred)));
            if (planner != null) {
                queryParams.add(new NameValuePair("planner", planner));
            }
            if (this.sessionRoot != null && save != null) {
                queryParams.add(new NameValuePair("save", save));
            }
            if (ql == QueryLanguage.SPARQL && dataset != null) {
                for (URI defaultGraphURI : dataset.getDefaultGraphs()) {
                    String param = "null";
                    if (defaultGraphURI == null) {
                        queryParams.add(new NameValuePair("context", param));
                        continue;
                    }
                    param = defaultGraphURI.toString();
                    queryParams.add(new NameValuePair("default-graph-uri", param));
                }
                for (URI namedGraphURI : dataset.getNamedGraphs()) {
                    queryParams.add(new NameValuePair("named-graph-uri", namedGraphURI.toString()));
                }
            }
        }
        for (int i = 0; i < bindings.length; ++i) {
            String paramName = "$" + bindings[i].getName();
            String paramValue = Protocol.encodeValue((Value)bindings[i].getValue());
            queryParams.add(new NameValuePair(paramName, paramValue));
        }
        return queryParams;
    }

    private void processSavedQueryDeleteQueue() throws RepositoryException {
        String queryName;
        while ((queryName = this.savedQueryDeleteQueue.poll()) != null) {
            this.deleteSavedQuery(queryName);
        }
    }

    public void deleteSavedQuery(String queryName) throws RepositoryException {
        String url = AGProtocol.getSavedQueryLocation(this.getRoot(), queryName);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        try {
            this.getHTTPClient().delete(url, headers, params);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void close() throws RepositoryException {
        if (this.sessionRoot != null) {
            try {
                this.closeSession(this.sessionRoot);
                this.sessionRoot = null;
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    public void createFreetextIndex(String name, URI[] predicates) throws RepositoryException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), name);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (predicates != null) {
            for (URI predicate : predicates) {
                String pred = NTriplesUtil.toNTriplesString((URI)predicate);
                params.add(new NameValuePair("predicate", pred));
            }
        }
        try {
            this.getHTTPClient().put(url, new Header[0], params.toArray(new NameValuePair[params.size()]), null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String[] getFreetextPredicates(String index) throws RepositoryException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), index) + "/predicates";
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.getHTTPClient().get(url, new Header[0], new NameValuePair[0], handler);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getString().split("\n");
    }

    public String[] getFreetextIndices() throws RepositoryException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot());
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.getHTTPClient().get(url, new Header[0], new NameValuePair[0], handler);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getString().split("\n");
    }

    public void registerPredicateMapping(URI predicate, URI primitiveType) throws RepositoryException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        String pred_nt = NTriplesUtil.toNTriplesString((URI)predicate);
        String primtype_nt = NTriplesUtil.toNTriplesString((URI)primitiveType);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("predicate", pred_nt), new NameValuePair("encoding", primtype_nt)};
        try {
            this.getHTTPClient().post(url, headers, params, null, null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void deletePredicateMapping(URI predicate) throws RepositoryException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        String pred_nt = NTriplesUtil.toNTriplesString((URI)predicate);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("predicate", pred_nt)};
        try {
            this.getHTTPClient().delete(url, headers, params);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String[] getPredicateMappings() throws RepositoryException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.getHTTPClient().get(url, headers, params, handler);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getString().split("\n");
    }

    public void registerDatatypeMapping(URI datatype, URI primitiveType) throws RepositoryException {
        String url = AGProtocol.getDatatypeMappingLocation(this.getRoot());
        String datatype_nt = NTriplesUtil.toNTriplesString((URI)datatype);
        String primtype_nt = NTriplesUtil.toNTriplesString((URI)primitiveType);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("type", datatype_nt), new NameValuePair("encoding", primtype_nt)};
        try {
            this.getHTTPClient().post(url, headers, params, null, null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void deleteDatatypeMapping(URI datatype) throws RepositoryException {
        String url = AGProtocol.getDatatypeMappingLocation(this.getRoot());
        String datatype_nt = NTriplesUtil.toNTriplesString((URI)datatype);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("type", datatype_nt)};
        try {
            this.getHTTPClient().delete(url, headers, params);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String[] getDatatypeMappings() throws RepositoryException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.getHTTPClient().get(url, headers, params, handler);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getString().split("\n");
    }

    public void clearMappings() throws RepositoryException {
        String url = AGProtocol.getMappingLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        try {
            this.getHTTPClient().delete(url, headers, params);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void addRules(String rules) throws RepositoryException {
        try {
            ByteArrayInputStream rulestream = new ByteArrayInputStream(rules.getBytes("UTF-8"));
            this.addRules(rulestream);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void addRules(InputStream rulestream) throws RepositoryException {
        this.useDedicatedSession(this.isAutoCommit());
        String url = AGProtocol.getFunctorLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        try {
            InputStreamRequestEntity entity = new InputStreamRequestEntity(rulestream, -1L, null);
            this.getHTTPClient().post(url, headers, params, (RequestEntity)entity, null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String evalInServer(String lispForm) throws RepositoryException {
        String result;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(lispForm.getBytes("UTF-8"));
            result = this.evalInServer(stream);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return result;
    }

    public String evalInServer(InputStream stream) throws RepositoryException {
        String url = AGProtocol.getEvalLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            InputStreamRequestEntity entity = new InputStreamRequestEntity(stream, -1L, null);
            this.getHTTPClient().post(url, headers, params, (RequestEntity)entity, handler);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getString();
    }

    public void ping() throws RepositoryException {
        if (this.usingDedicatedSession) {
            String url = AGProtocol.getSessionPingLocation(this.getRoot());
            Header[] headers = new Header[]{};
            try {
                this.getHTTPClient().get(url, headers, new NameValuePair[0], null);
            }
            catch (HttpException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (AGHttpException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    public String[] getGeoTypes() throws RepositoryException {
        String url = AGProtocol.getGeoTypesLocation(this.getRoot());
        Header[] headers = new Header[]{};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.getHTTPClient().get(url, headers, new NameValuePair[0], handler);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getString().split("\n");
    }

    public String registerCartesianType(float stripWidth, float xmin, float xmax, float ymin, float ymax) throws RepositoryException {
        String url = AGProtocol.getGeoTypesCartesianLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("stripWidth", Float.toString(stripWidth)), new NameValuePair("xmin", Float.toString(xmin)), new NameValuePair("xmax", Float.toString(xmax)), new NameValuePair("ymin", Float.toString(ymin)), new NameValuePair("ymax", Float.toString(ymax))};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.getHTTPClient().post(url, headers, params, null, handler);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getString();
    }

    public String registerSphericalType(float stripWidth, String unit, float latmin, float longmin, float latmax, float longmax) throws RepositoryException {
        String url = AGProtocol.getGeoTypesSphericalLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("stripWidth", Float.toString(stripWidth)), new NameValuePair("unit", unit), new NameValuePair("latmin", Float.toString(latmin)), new NameValuePair("longmin", Float.toString(longmin)), new NameValuePair("latmax", Float.toString(latmax)), new NameValuePair("longmax", Float.toString(longmax))};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.getHTTPClient().post(url, headers, params, null, handler);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getString();
    }

    public void registerPolygon(String polygon, List<String> points) throws RepositoryException {
        if (points.size() < 3) {
            throw new IllegalArgumentException("A minimum of three points are required to register a polygon.");
        }
        String url = AGProtocol.getGeoPolygonLocation(this.getRoot());
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("resource", polygon));
        for (String point : points) {
            params.add(new NameValuePair("point", point));
        }
        try {
            this.getHTTPClient().put(url, headers, params.toArray(new NameValuePair[params.size()]), null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void getGeoBox(String type_uri, String predicate_uri, float xmin, float xmax, float ymin, float ymax, int limit, boolean infer, AGResponseHandler handler) throws RepositoryException {
        String url = AGProtocol.getGeoBoxLocation(this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("xmin", Float.toString(xmin)));
        params.add(new NameValuePair("xmax", Float.toString(xmax)));
        params.add(new NameValuePair("ymin", Float.toString(ymin)));
        params.add(new NameValuePair("ymax", Float.toString(ymax)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        try {
            this.getHTTPClient().get(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void getGeoCircle(String type_uri, String predicate_uri, float x, float y, float radius, int limit, boolean infer, AGResponseHandler handler) throws RepositoryException {
        String url = AGProtocol.getGeoCircleLocation(this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("x", Float.toString(x)));
        params.add(new NameValuePair("y", Float.toString(y)));
        params.add(new NameValuePair("radius", Float.toString(radius)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        try {
            this.getHTTPClient().get(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void getGeoHaversine(String type_uri, String predicate_uri, float lat, float lon, float radius, String unit, int limit, boolean infer, AGResponseHandler handler) throws RepositoryException {
        String url = AGProtocol.getGeoHaversineLocation(this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("lat", Float.toString(lat)));
        params.add(new NameValuePair("long", Float.toString(lon)));
        params.add(new NameValuePair("radius", Float.toString(radius)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        try {
            this.getHTTPClient().get(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void getGeoPolygon(String type_uri, String predicate_uri, String polygon, int limit, boolean infer, AGResponseHandler handler) throws RepositoryException {
        String url = AGProtocol.getGeoPolygonLocation(this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("polygon", polygon));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        try {
            this.getHTTPClient().get(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void registerSNAGenerator(String generator, List<String> objectOfs, List<String> subjectOfs, List<String> undirecteds, String query) throws RepositoryException {
        this.useDedicatedSession(this.autoCommit);
        String url = AGProtocol.getSNAGeneratorLocation(this.getRoot(), generator);
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        for (String objectOf : objectOfs) {
            params.add(new NameValuePair("objectOf", objectOf));
        }
        for (String subjectOf : subjectOfs) {
            params.add(new NameValuePair("subjectOf", subjectOf));
        }
        for (String undirected : undirecteds) {
            params.add(new NameValuePair("undirected", undirected));
        }
        if (query != null) {
            params.add(new NameValuePair("query", query));
        }
        try {
            this.getHTTPClient().put(url, headers, params.toArray(new NameValuePair[params.size()]), null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void registerSNANeighborMatrix(String matrix, String generator, List<String> group, int depth) throws RepositoryException {
        String url = AGProtocol.getSNANeighborMatrixLocation(this.getRoot(), matrix);
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("generator", generator));
        for (String node : group) {
            params.add(new NameValuePair("group", node));
        }
        params.add(new NameValuePair("depth", Integer.toString(depth)));
        try {
            this.getHTTPClient().put(url, headers, params.toArray(new NameValuePair[params.size()]), null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public List<String> listIndices(boolean listValid) throws RepositoryException {
        String url = AGProtocol.getIndicesURL(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("listValid", Boolean.toString(listValid))};
        AGResponseHandler handler = new AGResponseHandler("");
        try {
            this.getHTTPClient().get(url, headers, data, handler);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        return Arrays.asList(handler.getString().split("\n"));
    }

    public void addIndex(String index) throws RepositoryException {
        String url = AGProtocol.getIndicesURL(this.getRoot()) + "/" + index;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        try {
            this.getHTTPClient().put(url, headers, params, null);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void dropIndex(String index) throws RepositoryException {
        String url = AGProtocol.getIndicesURL(this.getRoot()) + "/" + index;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        try {
            this.getHTTPClient().delete(url, headers, params);
        }
        catch (HttpException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

