/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGBulkUpdateHandler;
import com.franz.agraph.jena.AGCapabilities;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGPrefixMapping;
import com.franz.agraph.jena.AGTransactionHandler;
import com.franz.agraph.jena.AGTripleIterator;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import java.util.ArrayList;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.StatementCollector;

public class AGGraph
extends GraphBase
implements Graph,
Closeable {
    private final AGGraphMaker maker;
    private final Node graphNode;
    private final AGRepositoryConnection conn;
    private final AGValueFactory vf;
    private final Resource context;
    protected String entailmentRegime = "false";

    AGGraph(AGGraphMaker maker, Node graphNode) {
        this.maker = maker;
        this.graphNode = graphNode;
        this.conn = maker.getRepositoryConnection();
        this.vf = this.conn.getValueFactory();
        this.context = this.vf.asResource(graphNode);
    }

    AGGraphMaker getGraphMaker() {
        return this.maker;
    }

    Node getGraphNode() {
        return this.graphNode;
    }

    public String getName() {
        if (this.graphNode == null) {
            return "default-graph";
        }
        return this.graphNode.toString();
    }

    Resource getGraphContext() {
        return this.context;
    }

    AGRepositoryConnection getConnection() {
        return this.conn;
    }

    String getEntailmentRegime() {
        return this.entailmentRegime;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return new AGBulkUpdateHandler(this);
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AGCapabilities();
        }
        return this.capabilities;
    }

    public PrefixMapping getPrefixMapping() {
        return new AGPrefixMapping(this);
    }

    public TransactionHandler getTransactionHandler() {
        return new AGTransactionHandler(this);
    }

    public String toString() {
        return AGGraph.toString(this.getName() + (this.closed ? " (closed) " : " (size: " + this.graphBaseSize() + ")."), this);
    }

    public static String toString(String prefix, Graph that) {
        StringBuffer b = new StringBuffer(prefix + " {");
        String gap = "";
        ExtendedIterator it = GraphUtil.findAll((Graph)that);
        int count = 0;
        while (it.hasNext() && count < 20) {
            b.append(gap);
            gap = "; ";
            b.append(((Triple)it.next()).toString());
        }
        b.append("}");
        return b.toString();
    }

    public Dataset getDataset() {
        DatasetImpl dataset = new DatasetImpl();
        if (this.context == null) {
            dataset.addDefaultGraph(null);
        } else if (this.context instanceof URI) {
            dataset.addDefaultGraph((URI)this.context);
            dataset.addNamedGraph((URI)this.context);
        }
        return dataset;
    }

    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        RepositoryResult result;
        try {
            Node s = m.getMatchSubject();
            Node p = m.getMatchPredicate();
            if (s != null && s.isLiteral() || p != null && (p.isLiteral() || p.isBlank())) {
                result = this.conn.createRepositoryResult(new ArrayList());
            } else {
                StatementCollector collector = new StatementCollector();
                this.conn.getHttpRepoClient().getStatements(this.vf.asResource(s), this.vf.asURI(p), this.vf.asValue(m.getMatchObject()), this.entailmentRegime, (RDFHandler)collector, this.context);
                result = this.conn.createRepositoryResult(collector.getStatements());
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new AGTripleIterator(this, result);
    }

    public void performAdd(Triple t) {
        try {
            this.conn.add(this.vf.asResource(t.getSubject()), this.vf.asURI(t.getPredicate()), this.vf.asValue(t.getObject()), new Resource[]{this.context});
        }
        catch (UnauthorizedException e) {
            throw new AddDeniedException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void performDelete(Triple t) {
        try {
            this.conn.remove(this.vf.asResource(t.getSubject()), this.vf.asURI(t.getPredicate()), this.vf.asValue(t.getObject()), new Resource[]{this.context});
        }
        catch (UnauthorizedException e) {
            throw new DeleteDeniedException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected int graphBaseSize() {
        int size;
        try {
            size = (int)this.conn.size(this.context);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return size;
    }
}

