/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGInfGraph;
import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGNodeFactory;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGResultSet;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.util.Closeable;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import org.openrdf.model.Statement;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;

public class AGQueryExecution
implements QueryExecution,
Closeable {
    private final AGQuery query;
    private final AGModel model;

    public AGQueryExecution(AGQuery query, AGModel model) {
        this.query = query;
        this.model = model;
    }

    public void abort() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    @Override
    public void close() {
    }

    public boolean execAsk() {
        boolean result;
        if (this.query.getLanguage() != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(this.query.getLanguage().getName() + " language does not support ASK queries.");
        }
        AGBooleanQuery bq = this.model.getGraph().getConnection().prepareBooleanQuery(this.query.getLanguage(), this.query.getQueryString());
        bq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        bq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        try {
            bq.setDataset(this.model.getGraph().getDataset());
            result = bq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Model execConstruct() {
        return this.execConstruct(null);
    }

    public Model execConstruct(Model m) {
        GraphQueryResult result;
        if (this.query.getLanguage() != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException(this.query.getLanguage().getName() + " language does not support CONSTRUCT queries.");
        }
        AGGraphQuery gq = this.model.getGraph().getConnection().prepareGraphQuery(this.query.getLanguage(), this.query.getQueryString());
        gq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        gq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        try {
            gq.setDataset(this.model.getGraph().getDataset());
            result = gq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        if (m == null) {
            m = ModelFactory.createDefaultModel();
        }
        try {
            m.setNsPrefixes(result.getNamespaces());
            while (result.hasNext()) {
                m.add(this.model.asStatement(AGNodeFactory.asTriple((Statement)result.next())));
            }
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return m;
    }

    public Model execDescribe() {
        return this.execDescribe(null);
    }

    public Model execDescribe(Model m) {
        return this.execConstruct(m);
    }

    public ResultSet execSelect() {
        TupleQueryResult result;
        AGTupleQuery tq = this.model.getGraph().getConnection().prepareTupleQuery(this.query.getLanguage(), this.query.getQueryString());
        tq.setIncludeInferred(this.model.getGraph() instanceof AGInfGraph);
        tq.setEntailmentRegime(this.model.getGraph().getEntailmentRegime());
        try {
            tq.setDataset(this.model.getGraph().getDataset());
            result = tq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
        return new AGResultSet(result, this.model);
    }

    public Context getContext() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    public Dataset getDataset() {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    public void setFileManager(FileManager fm) {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }

    public void setInitialBinding(QuerySolution binding) {
        throw new UnsupportedOperationException("This method is not currently supported.");
    }
}

