/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.repository.AGRepositoryConnection;
import java.util.Iterator;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.AbstractQuery;

public abstract class AGQuery
extends AbstractQuery {
    public static final String SPARQL_COVERAGE_PLANNER = "coverage";
    public static final String SPARQL_IDENTITY_PLANNER = "identity";
    public static final String RDFS_PLUS_PLUS = "rdfs++";
    public static final String RESTRICTION = "restriction";
    protected AGRepositoryConnection httpCon;
    protected QueryLanguage queryLanguage;
    protected String queryString;
    protected String baseURI;
    protected String entailmentRegime = "rdfs++";
    protected String planner;
    protected String saveName = null;
    protected boolean prepared = false;

    public AGQuery(AGRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super.setIncludeInferred(false);
        this.httpCon = con;
        this.queryLanguage = ql;
        this.queryString = queryString;
        this.baseURI = baseURI;
        this.includeInferred = false;
    }

    public void setIncludeInferred(boolean includeInferred) {
        super.setIncludeInferred(includeInferred);
    }

    public void setEntailmentRegime(String entailmentRegime) {
        this.entailmentRegime = entailmentRegime;
    }

    public String getEntailmentRegime() {
        return this.entailmentRegime;
    }

    public QueryLanguage getLanguage() {
        return this.queryLanguage;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPlanner() {
        return this.planner;
    }

    public void setPlanner(String planner) {
        this.planner = planner;
    }

    synchronized void prepare() {
    }

    public void setSaveName(String name) {
        this.saveName = name;
    }

    public String getName() {
        return this.saveName;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public Binding[] getBindingsArray() {
        BindingSet bindings = this.getBindings();
        Binding[] bindingsArray = new Binding[bindings.size()];
        Iterator iter = bindings.iterator();
        for (int i = 0; i < bindings.size(); ++i) {
            bindingsArray[i] = (Binding)iter.next();
        }
        return bindingsArray;
    }

    public String toString() {
        return this.queryString;
    }

    protected void finalize() {
        if (this.saveName != null) {
            this.httpCon.getHttpRepoClient().savedQueryDeleteQueue.add(this.saveName);
        }
    }
}

