/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import java.io.File;
import org.openrdf.model.BNode;
import org.openrdf.repository.RepositoryException;

public class AGVirtualRepository
implements AGAbstractRepository,
Closeable {
    private AGServer server;
    private AGRepository wrapped;
    private String spec;
    private AGValueFactory vf;

    public AGVirtualRepository(AGServer server, String spec, AGRepository wrapped) {
        this.server = server;
        this.spec = spec;
        this.wrapped = wrapped;
        this.vf = wrapped == null ? new AGFederatedValueFactory() : new AGValueFactory(wrapped);
    }

    public AGServer getServer() {
        return this.server;
    }

    @Override
    public AGCatalog getCatalog() {
        return null;
    }

    @Override
    public String getSpec() {
        return this.spec;
    }

    public boolean isWritable() {
        return this.wrapped != null;
    }

    @Override
    public AGValueFactory getValueFactory() {
        return this.vf;
    }

    @Override
    public AGRepositoryConnection getConnection() throws RepositoryException {
        AGHTTPClient client = this.server.getHTTPClient();
        AGHttpRepoClient repoclient = new AGHttpRepoClient(this, client, null, client.openSession(this.spec, true));
        return new AGRepositoryConnection(this, repoclient);
    }

    @Override
    public void close() throws RepositoryException {
        this.shutDown();
    }

    public void initialize() {
    }

    public void shutDown() throws RepositoryException {
    }

    public void setDataDir(File dataDir) {
        throw new RuntimeException("setDataDir is inapplicable for AG repositories");
    }

    public File getDataDir() {
        throw new RuntimeException("getDataDir is inapplicable for AG repositories");
    }

    public static String federatedSpec(String[] repoSpecs) {
        String spec = "";
        for (int i = 0; i < repoSpecs.length; ++i) {
            if (spec.length() > 0) {
                spec = spec + " + ";
            }
            spec = spec + repoSpecs[i];
        }
        return spec;
    }

    public static String reasoningSpec(String repoSpec, String reasoner) {
        return repoSpec + "[" + reasoner + "]";
    }

    public static String filteredSpec(String repoSpec, String[] graphs) {
        repoSpec = repoSpec + "{";
        for (String graph : graphs) {
            repoSpec = repoSpec + " " + graph;
        }
        return repoSpec + "}";
    }

    private class AGFederatedValueFactory
    extends AGValueFactory {
        public AGFederatedValueFactory() {
            super(null);
        }

        @Override
        public BNode createBNode(String nodeID) {
            throw new RuntimeException("Can not create a blank node for a federated store.");
        }
    }
}

