/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;
import java.math.BigInteger;

public class BigIntegerTemplate
extends AbstractTemplate<BigInteger> {
    static final BigIntegerTemplate instance = new BigIntegerTemplate();

    private BigIntegerTemplate() {
    }

    @Override
    public void write(Packer pk, BigInteger target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write(target);
    }

    @Override
    public BigInteger read(Unpacker u, BigInteger to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readBigInteger();
    }

    public static BigIntegerTemplate getInstance() {
        return instance;
    }
}

