/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class IntegerTemplate
extends AbstractTemplate<Integer> {
    static final IntegerTemplate instance = new IntegerTemplate();

    private IntegerTemplate() {
    }

    @Override
    public void write(Packer pk, Integer target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write((int)target);
    }

    @Override
    public Integer read(Unpacker u, Integer to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readInt();
    }

    public static IntegerTemplate getInstance() {
        return instance;
    }
}

