/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class LongArrayTemplate
extends AbstractTemplate<long[]> {
    static final LongArrayTemplate instance = new LongArrayTemplate();

    private LongArrayTemplate() {
    }

    @Override
    public void write(Packer pk, long[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (long a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public long[] read(Unpacker u, long[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null || to.length != n) {
            to = new long[n];
        }
        for (int i = 0; i < n; ++i) {
            to[i] = u.readLong();
        }
        u.readArrayEnd();
        return to;
    }

    public static LongArrayTemplate getInstance() {
        return instance;
    }
}

