/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template.builder;

import com.fulcrologicpro.org.msgpack.template.OrdinalEnumTemplate;
import com.fulcrologicpro.org.msgpack.template.Template;
import com.fulcrologicpro.org.msgpack.template.TemplateRegistry;
import com.fulcrologicpro.org.msgpack.template.builder.AbstractTemplateBuilder;
import com.fulcrologicpro.org.msgpack.template.builder.FieldEntry;
import com.fulcrologicpro.org.msgpack.template.builder.TemplateBuildException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrdinalEnumTemplateBuilder
extends AbstractTemplateBuilder {
    private static final Logger LOG = Logger.getLogger(OrdinalEnumTemplateBuilder.class.getName());

    public OrdinalEnumTemplateBuilder(TemplateRegistry registry) {
        super(registry);
    }

    @Override
    public boolean matchType(Type targetType, boolean hasAnnotation) {
        Class targetClass = (Class)targetType;
        boolean matched = OrdinalEnumTemplateBuilder.matchAtOrdinalEnumTemplateBuilder(targetClass, hasAnnotation);
        if (matched && LOG.isLoggable(Level.FINE)) {
            LOG.fine("matched type: " + targetClass.getName());
        }
        return matched;
    }

    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldEntry[] entries) {
        throw new UnsupportedOperationException("fatal error: " + targetClass.getName());
    }

    @Override
    public <T> Template<T> buildTemplate(Type targetType) throws TemplateBuildException {
        Class targetClass = (Class)targetType;
        this.checkOrdinalEnumValidation(targetClass);
        return new OrdinalEnumTemplate(targetClass);
    }

    protected void checkOrdinalEnumValidation(Class<?> targetClass) {
        if (!targetClass.isEnum()) {
            throw new TemplateBuildException("tried to build ordinal enum template of non-enum class: " + targetClass.getName());
        }
    }
}

