/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class CharacterTemplate
extends AbstractTemplate<Character> {
    static final CharacterTemplate instance = new CharacterTemplate();

    private CharacterTemplate() {
    }

    @Override
    public void write(Packer pk, Character target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write(target.charValue());
    }

    @Override
    public Character read(Unpacker u, Character to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return Character.valueOf((char)u.readInt());
    }

    public static CharacterTemplate getInstance() {
        return instance;
    }
}

