/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class DoubleArrayTemplate
extends AbstractTemplate<double[]> {
    static final DoubleArrayTemplate instance = new DoubleArrayTemplate();

    private DoubleArrayTemplate() {
    }

    @Override
    public void write(Packer pk, double[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (double a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public double[] read(Unpacker u, double[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        if (to == null || to.length != n) {
            to = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            to[i] = u.readDouble();
        }
        u.readArrayEnd();
        return to;
    }

    public static DoubleArrayTemplate getInstance() {
        return instance;
    }
}

