/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class IntegerArrayTemplate
extends AbstractTemplate<int[]> {
    static final IntegerArrayTemplate instance = new IntegerArrayTemplate();

    private IntegerArrayTemplate() {
    }

    @Override
    public void write(Packer pk, int[] target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.writeArrayBegin(target.length);
        for (int a : target) {
            pk.write(a);
        }
        pk.writeArrayEnd();
    }

    @Override
    public int[] read(Unpacker u, int[] to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readArrayBegin();
        int[] array = to != null && to.length == n ? to : new int[n];
        for (int i = 0; i < n; ++i) {
            array[i] = u.readInt();
        }
        u.readArrayEnd();
        return array;
    }

    public static IntegerArrayTemplate getInstance() {
        return instance;
    }
}

