/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.com.cognitect.transit.impl;

import com.fulcrologicpro.com.cognitect.transit.ArrayReadHandler;
import com.fulcrologicpro.com.cognitect.transit.ArrayReader;
import com.fulcrologicpro.com.cognitect.transit.DefaultReadHandler;
import com.fulcrologicpro.com.cognitect.transit.MapReadHandler;
import com.fulcrologicpro.com.cognitect.transit.MapReader;
import com.fulcrologicpro.com.cognitect.transit.ReadHandler;
import com.fulcrologicpro.com.cognitect.transit.impl.AbstractParser;
import com.fulcrologicpro.com.cognitect.transit.impl.ReadCache;
import com.fulcrologicpro.com.cognitect.transit.impl.Tag;
import com.fulcrologicpro.org.msgpack.type.Value;
import com.fulcrologicpro.org.msgpack.type.ValueType;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class MsgpackParser
extends AbstractParser {
    private final Unpacker mp;

    public MsgpackParser(Unpacker mp, Map<String, ReadHandler<?, ?>> handlers, DefaultReadHandler defaultHandler, MapReader<?, Map<Object, Object>, Object, Object> mapBuilder, ArrayReader<?, List<Object>, Object> listBuilder) {
        super(handlers, defaultHandler, mapBuilder, listBuilder);
        this.mp = mp;
    }

    private Object parseLong() throws IOException {
        Value val = this.mp.readValue();
        try {
            return val.asIntegerValue().getLong();
        }
        catch (Exception ex) {
            BigInteger bigInteger = new BigInteger(val.asRawValue().getString());
            return val;
        }
    }

    @Override
    public Object parse(ReadCache cache) throws IOException {
        return this.parseVal(false, cache);
    }

    @Override
    public Object parseVal(boolean asMapKey, ReadCache cache) throws IOException {
        switch (this.mp.getNextType()) {
            case MAP: {
                return this.parseMap(asMapKey, cache, null);
            }
            case ARRAY: {
                return this.parseArray(asMapKey, cache, null);
            }
            case RAW: {
                return cache.cacheRead(this.mp.readValue().asRawValue().getString(), asMapKey, this);
            }
            case INTEGER: {
                return this.parseLong();
            }
            case FLOAT: {
                return this.mp.readValue().asFloatValue().getDouble();
            }
            case BOOLEAN: {
                return this.mp.readValue().asBooleanValue().getBoolean();
            }
            case NIL: {
                this.mp.readNil();
            }
        }
        return null;
    }

    @Override
    public Object parseMap(boolean ignored, ReadCache cache, MapReadHandler<Object, ?, Object, Object, ?> handler) throws IOException {
        int sz = this.mp.readMapBegin();
        MapReader mr = handler != null ? handler.mapReader() : this.mapBuilder;
        Object mb = mr.init(sz);
        for (int remainder = sz; remainder > 0; --remainder) {
            Object key = this.parseVal(true, cache);
            if (key instanceof Tag) {
                String tag = ((Tag)key).getValue();
                ReadHandler<Object, Object> val_handler = this.getHandler(tag);
                Object val = val_handler != null ? (this.mp.getNextType() == ValueType.MAP && val_handler instanceof MapReadHandler ? this.parseMap(false, cache, (MapReadHandler)val_handler) : (this.mp.getNextType() == ValueType.ARRAY && val_handler instanceof ArrayReadHandler ? this.parseArray(false, cache, (ArrayReadHandler)val_handler) : val_handler.fromRep(this.parseVal(false, cache)))) : this.decode(tag, this.parseVal(false, cache));
                this.mp.readMapEnd(true);
                return val;
            }
            mb = mr.add(mb, key, this.parseVal(false, cache));
        }
        this.mp.readMapEnd(true);
        return mr.complete(mb);
    }

    @Override
    public Object parseArray(boolean ignored, ReadCache cache, ArrayReadHandler<Object, ?, Object, ?> handler) throws IOException {
        int sz = this.mp.readArrayBegin();
        ArrayReader ar = handler != null ? handler.arrayReader() : this.listBuilder;
        Object ab = ar.init(sz);
        for (int remainder = sz; remainder > 0; --remainder) {
            Object val = this.parseVal(false, cache);
            if (val != null && val instanceof Tag) {
                String tag = ((Tag)val).getValue();
                ReadHandler<Object, Object> val_handler = this.getHandler(tag);
                val = val_handler != null ? (this.mp.getNextType() == ValueType.MAP && val_handler instanceof MapReadHandler ? this.parseMap(false, cache, (MapReadHandler)val_handler) : (this.mp.getNextType() == ValueType.ARRAY && val_handler instanceof ArrayReadHandler ? this.parseArray(false, cache, (ArrayReadHandler)val_handler) : val_handler.fromRep(this.parseVal(false, cache)))) : this.decode(tag, this.parseVal(false, cache));
                this.mp.readArrayEnd();
                return val;
            }
            ab = ar.add(ab, val);
        }
        this.mp.readArrayEnd();
        return ar.complete(ab);
    }
}

