/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class BooleanTemplate
extends AbstractTemplate<Boolean> {
    static final BooleanTemplate instance = new BooleanTemplate();

    private BooleanTemplate() {
    }

    @Override
    public void write(Packer pk, Boolean target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write((boolean)target);
    }

    @Override
    public Boolean read(Unpacker u, Boolean to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return u.readBoolean();
    }

    public static BooleanTemplate getInstance() {
        return instance;
    }
}

