/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.type;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.type.IntegerValue;
import com.fulcrologicpro.org.msgpack.type.Value;
import java.io.IOException;
import java.math.BigInteger;

class IntValueImpl
extends IntegerValue {
    private int value;
    private static int BYTE_MAX = 127;
    private static int SHORT_MAX = Short.MAX_VALUE;
    private static int BYTE_MIN = -128;
    private static int SHORT_MIN = Short.MIN_VALUE;

    IntValueImpl(int value) {
        this.value = value;
    }

    @Override
    public byte getByte() {
        if (this.value > BYTE_MAX || this.value < BYTE_MIN) {
            throw new MessageTypeException();
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() {
        if (this.value > SHORT_MAX || this.value < SHORT_MIN) {
            throw new MessageTypeException();
        }
        return (short)this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.write(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isIntegerValue()) {
            return false;
        }
        try {
            return this.value == v.asIntegerValue().getInt();
        }
        catch (MessageTypeException ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        return sb.append(Integer.toString(this.value));
    }
}

