/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.unpacker;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.unpacker.Accept;

final class IntAccept
extends Accept {
    int value;

    IntAccept() {
        super("integer");
    }

    @Override
    void acceptInteger(byte v) {
        this.value = v;
    }

    @Override
    void acceptInteger(short v) {
        this.value = v;
    }

    @Override
    void acceptInteger(int v) {
        this.value = v;
    }

    @Override
    void acceptInteger(long v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new MessageTypeException();
        }
        this.value = (int)v;
    }

    @Override
    void acceptUnsignedInteger(byte v) {
        this.value = v & 0xFF;
    }

    @Override
    void acceptUnsignedInteger(short v) {
        this.value = v & 0xFFFF;
    }

    @Override
    void acceptUnsignedInteger(int v) {
        if (v < 0) {
            throw new MessageTypeException();
        }
        this.value = v;
    }

    @Override
    void acceptUnsignedInteger(long v) {
        if (v < 0L || v > Integer.MAX_VALUE) {
            throw new MessageTypeException();
        }
        this.value = (int)v;
    }
}

