/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.type;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.type.AbstractRawValue;
import com.fulcrologicpro.org.msgpack.type.RawValue;
import com.fulcrologicpro.org.msgpack.type.Value;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

class ByteArrayRawValueImpl
extends AbstractRawValue {
    private static ByteArrayRawValueImpl emptyInstance = new ByteArrayRawValueImpl(new byte[0], true);
    private static final ThreadLocal<CharsetDecoder> decoderStore = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    };
    private byte[] bytes;

    public static RawValue getEmptyInstance() {
        return emptyInstance;
    }

    ByteArrayRawValueImpl(byte[] bytes, boolean gift) {
        if (gift) {
            this.bytes = bytes;
        } else {
            this.bytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
        }
    }

    ByteArrayRawValueImpl(byte[] b, int off, int len) {
        this.bytes = new byte[len];
        System.arraycopy(b, off, this.bytes, 0, len);
    }

    @Override
    public byte[] getByteArray() {
        return this.bytes;
    }

    @Override
    public String getString() {
        CharsetDecoder decoder = decoderStore.get();
        try {
            return decoder.decode(ByteBuffer.wrap(this.bytes)).toString();
        }
        catch (CharacterCodingException ex) {
            throw new MessageTypeException(ex);
        }
    }

    @Override
    public void writeTo(Packer pk) throws IOException {
        pk.write(this.bytes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value v = (Value)o;
        if (!v.isRawValue()) {
            return false;
        }
        return Arrays.equals(this.bytes, v.asRawValue().getByteArray());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

