/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.unpacker;

import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.unpacker.Accept;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

final class StringAccept
extends Accept {
    String value;
    private CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);

    public StringAccept() {
        super("raw value");
    }

    @Override
    void acceptRaw(byte[] raw) {
        try {
            this.value = this.decoder.decode(ByteBuffer.wrap(raw)).toString();
        }
        catch (CharacterCodingException ex) {
            throw new MessageTypeException(ex);
        }
    }

    @Override
    void acceptEmptyRaw() {
        this.value = "";
    }

    @Override
    public void refer(ByteBuffer bb, boolean gift) throws IOException {
        try {
            this.value = this.decoder.decode(bb).toString();
        }
        catch (CharacterCodingException ex) {
            throw new MessageTypeException(ex);
        }
    }
}

