/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.unpacker;

import com.fulcrologicpro.org.msgpack.packer.Unconverter;
import com.fulcrologicpro.org.msgpack.type.ValueFactory;
import com.fulcrologicpro.org.msgpack.unpacker.Accept;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;

final class ValueAccept
extends Accept {
    private Unconverter uc = null;

    ValueAccept() {
        super(null);
    }

    void setUnconverter(Unconverter uc) throws IOException {
        this.uc = uc;
    }

    @Override
    void acceptBoolean(boolean v) throws IOException {
        this.uc.write(ValueFactory.createBooleanValue(v));
    }

    @Override
    void acceptInteger(byte v) throws IOException {
        this.uc.write(ValueFactory.createIntegerValue(v));
    }

    @Override
    void acceptInteger(short v) throws IOException {
        this.uc.write(ValueFactory.createIntegerValue(v));
    }

    @Override
    void acceptInteger(int v) throws IOException {
        this.uc.write(ValueFactory.createIntegerValue(v));
    }

    @Override
    void acceptInteger(long v) throws IOException {
        this.uc.write(ValueFactory.createIntegerValue(v));
    }

    @Override
    void acceptUnsignedInteger(byte v) throws IOException {
        this.uc.write(ValueFactory.createIntegerValue(v & 0xFF));
    }

    @Override
    void acceptUnsignedInteger(short v) throws IOException {
        this.uc.write(ValueFactory.createIntegerValue(v & 0xFFFF));
    }

    @Override
    void acceptUnsignedInteger(int v) throws IOException {
        if (v < 0) {
            long value = (long)(v & Integer.MAX_VALUE) + 0x80000000L;
            this.uc.write(ValueFactory.createIntegerValue(value));
        } else {
            this.uc.write(ValueFactory.createIntegerValue(v));
        }
    }

    @Override
    void acceptUnsignedInteger(long v) throws IOException {
        if (v < 0L) {
            BigInteger value = BigInteger.valueOf(v + Long.MAX_VALUE + 1L).setBit(63);
            this.uc.write(ValueFactory.createIntegerValue(value));
        } else {
            this.uc.write(ValueFactory.createIntegerValue(v));
        }
    }

    @Override
    void acceptRaw(byte[] raw) throws IOException {
        this.uc.write(ValueFactory.createRawValue(raw));
    }

    @Override
    void acceptEmptyRaw() throws IOException {
        this.uc.write(ValueFactory.createRawValue());
    }

    @Override
    public void refer(ByteBuffer bb, boolean gift) throws IOException {
        byte[] raw = new byte[bb.remaining()];
        bb.get(raw);
        this.uc.write(ValueFactory.createRawValue(raw, true));
    }

    @Override
    void acceptArray(int size) throws IOException {
        this.uc.writeArrayBegin(size);
    }

    @Override
    void acceptMap(int size) throws IOException {
        this.uc.writeMapBegin(size);
    }

    @Override
    void acceptNil() throws IOException {
        this.uc.write(ValueFactory.createNilValue());
    }

    @Override
    void acceptFloat(float v) throws IOException {
        this.uc.write(ValueFactory.createFloatValue(v));
    }

    @Override
    void acceptDouble(double v) throws IOException {
        this.uc.write(ValueFactory.createFloatValue(v));
    }
}

