// Copyright 2014 Cognitect. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.fulcrologicpro.com.cognitect.transit;

/** Converts a transit representation to an instance of a type; if type
 *  implements ArrayReadHandler or MapReadHandler to support incremental
 *  parsing of representation, that interface will be used instead
 */
public interface ReadHandler <T, Rep>{
    /**
     * Converts a transit value to an instance of a type
     * @param rep the transit value
     * @return the converted object
     */
    T fromRep(Rep rep);
}
