/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.com.cognitect.transit.impl;

import com.fulcrologicpro.com.cognitect.transit.ArrayReader;
import com.fulcrologicpro.com.cognitect.transit.DefaultReadHandler;
import com.fulcrologicpro.com.cognitect.transit.MapReader;
import com.fulcrologicpro.com.cognitect.transit.ReadHandler;
import com.fulcrologicpro.com.cognitect.transit.impl.Parser;
import com.fulcrologicpro.com.cognitect.transit.impl.Tag;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public abstract class AbstractParser
implements Parser {
    private static final ThreadLocal<SimpleDateFormat> dateTimeFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf;
        }
    };
    protected final Map<String, ReadHandler<?, ?>> handlers;
    private final DefaultReadHandler<?> defaultHandler;
    protected MapReader<Object, Map<Object, Object>, Object, Object> mapBuilder;
    protected ArrayReader<Object, List<Object>, Object> listBuilder;

    public static SimpleDateFormat getDateTimeFormat() {
        return dateTimeFormat.get();
    }

    protected AbstractParser(Map<String, ReadHandler<?, ?>> handlers, DefaultReadHandler<?> defaultHandler, MapReader<?, Map<Object, Object>, Object, Object> mapBuilder, ArrayReader<?, List<Object>, Object> listBuilder) {
        this.handlers = handlers;
        this.defaultHandler = defaultHandler;
        this.mapBuilder = mapBuilder;
        this.listBuilder = listBuilder;
    }

    protected ReadHandler<Object, Object> getHandler(String tag) {
        return this.handlers.get(tag);
    }

    protected Object decode(String tag, Object rep) {
        ReadHandler<Object, Object> d = this.getHandler(tag);
        if (d != null) {
            return d.fromRep(rep);
        }
        if (this.defaultHandler != null) {
            return this.defaultHandler.fromRep(tag, rep);
        }
        throw new RuntimeException("Cannot fromRep " + tag + ": " + rep.toString());
    }

    protected Object parseString(Object o) {
        String s;
        if (o instanceof String && (s = (String)o).length() > 1) {
            switch (s.charAt(0)) {
                case '~': {
                    switch (s.charAt(1)) {
                        case '^': 
                        case '`': 
                        case '~': {
                            return s.substring(1);
                        }
                        case '#': {
                            return new Tag(s.substring(2));
                        }
                    }
                    return this.decode(s.substring(1, 2), s.substring(2));
                }
                case '^': {
                    if (s.charAt(1) != ' ') break;
                    return "^ ";
                }
            }
        }
        return o;
    }
}

