/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.com.cognitect.transit.impl;

import com.fulcrologicpro.com.cognitect.transit.ArrayReadHandler;
import com.fulcrologicpro.com.cognitect.transit.ArrayReader;
import com.fulcrologicpro.com.cognitect.transit.DefaultReadHandler;
import com.fulcrologicpro.com.cognitect.transit.MapReadHandler;
import com.fulcrologicpro.com.cognitect.transit.MapReader;
import com.fulcrologicpro.com.cognitect.transit.ReadHandler;
import com.fulcrologicpro.com.cognitect.transit.impl.AbstractParser;
import com.fulcrologicpro.com.cognitect.transit.impl.ReadCache;
import com.fulcrologicpro.com.cognitect.transit.impl.Tag;
import com.fulcrologicpro.com.fasterxml.jackson.core.JsonToken;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class JsonParser
extends AbstractParser {
    private final com.fulcrologicpro.com.fasterxml.jackson.core.JsonParser jp;

    public JsonParser(com.fulcrologicpro.com.fasterxml.jackson.core.JsonParser jp, Map<String, ReadHandler<?, ?>> handlers, DefaultReadHandler<?> defaultHandler, MapReader<?, Map<Object, Object>, Object, Object> mapBuilder, ArrayReader<?, List<Object>, Object> listBuilder) {
        super(handlers, defaultHandler, mapBuilder, listBuilder);
        this.jp = jp;
    }

    private Object parseLong() throws IOException {
        Number val;
        try {
            val = this.jp.getLongValue();
        }
        catch (IOException e) {
            val = new BigInteger(this.jp.getText());
        }
        return val;
    }

    @Override
    public Object parse(ReadCache cache) throws IOException {
        if (this.jp.nextToken() == null) {
            throw new EOFException();
        }
        return this.parseVal(false, cache);
    }

    @Override
    public Object parseVal(boolean asMapKey, ReadCache cache) throws IOException {
        switch (this.jp.getCurrentToken()) {
            case START_OBJECT: {
                return this.parseMap(asMapKey, cache, null);
            }
            case START_ARRAY: {
                return this.parseArray(asMapKey, cache, null);
            }
            case FIELD_NAME: {
                return cache.cacheRead(this.jp.getText(), asMapKey, this);
            }
            case VALUE_STRING: {
                return cache.cacheRead(this.jp.getText(), asMapKey, this);
            }
            case VALUE_NUMBER_INT: {
                return this.parseLong();
            }
            case VALUE_NUMBER_FLOAT: {
                return this.jp.getDoubleValue();
            }
            case VALUE_TRUE: {
                return true;
            }
            case VALUE_FALSE: {
                return false;
            }
            case VALUE_NULL: {
                return null;
            }
        }
        return null;
    }

    @Override
    public Object parseMap(boolean ignored, ReadCache cache, MapReadHandler<Object, ?, Object, Object, ?> handler) throws IOException {
        return this.parseMap(ignored, cache, handler, JsonToken.END_OBJECT);
    }

    public Object parseMap(boolean ignored, ReadCache cache, MapReadHandler<Object, ?, Object, Object, ?> handler, JsonToken endToken) throws IOException {
        MapReader mr = handler != null ? handler.mapReader() : this.mapBuilder;
        Object mb = mr.init();
        while (this.jp.nextToken() != endToken) {
            Object key = this.parseVal(true, cache);
            if (key instanceof Tag) {
                String tag = ((Tag)key).getValue();
                ReadHandler<Object, Object> val_handler = this.getHandler(tag);
                this.jp.nextToken();
                Object val = val_handler != null ? (this.jp.getCurrentToken() == JsonToken.START_OBJECT && val_handler instanceof MapReadHandler ? this.parseMap(false, cache, (MapReadHandler)val_handler) : (this.jp.getCurrentToken() == JsonToken.START_ARRAY && val_handler instanceof ArrayReadHandler ? this.parseArray(false, cache, (ArrayReadHandler)val_handler) : val_handler.fromRep(this.parseVal(false, cache)))) : this.decode(tag, this.parseVal(false, cache));
                this.jp.nextToken();
                return val;
            }
            this.jp.nextToken();
            mb = mr.add(mb, key, this.parseVal(false, cache));
        }
        return mr.complete(mb);
    }

    @Override
    public Object parseArray(boolean ignored, ReadCache cache, ArrayReadHandler<Object, ?, Object, ?> handler) throws IOException {
        if (this.jp.nextToken() != JsonToken.END_ARRAY) {
            Object firstVal = this.parseVal(false, cache);
            if (firstVal != null) {
                if (firstVal == "^ ") {
                    return this.parseMap(false, cache, null, JsonToken.END_ARRAY);
                }
                if (firstVal instanceof Tag) {
                    String tag = ((Tag)firstVal).getValue();
                    ReadHandler<Object, Object> val_handler = this.getHandler(tag);
                    this.jp.nextToken();
                    Object val = val_handler != null ? (this.jp.getCurrentToken() == JsonToken.START_OBJECT && val_handler instanceof MapReadHandler ? this.parseMap(false, cache, (MapReadHandler)val_handler) : (this.jp.getCurrentToken() == JsonToken.START_ARRAY && val_handler instanceof ArrayReadHandler ? this.parseArray(false, cache, (ArrayReadHandler)val_handler) : val_handler.fromRep(this.parseVal(false, cache)))) : this.decode(tag, this.parseVal(false, cache));
                    this.jp.nextToken();
                    return val;
                }
            }
            ArrayReader ar = handler != null ? handler.arrayReader() : this.listBuilder;
            Object ab = ar.init();
            ab = ar.add(ab, firstVal);
            while (this.jp.nextToken() != JsonToken.END_ARRAY) {
                ab = ar.add(ab, this.parseVal(false, cache));
            }
            return ar.complete(ab);
        }
        ArrayReader ar = handler != null ? handler.arrayReader() : this.listBuilder;
        return ar.complete(ar.init(0));
    }
}

