/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.io;

import com.fulcrologicpro.org.msgpack.io.AbstractInput;
import com.fulcrologicpro.org.msgpack.io.BufferReferer;
import com.fulcrologicpro.org.msgpack.io.EndOfBufferException;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class LinkedBufferInput
extends AbstractInput {
    LinkedList<ByteBuffer> link = new LinkedList();
    int writable = -1;
    private int nextAdvance;
    private byte[] tmpBuffer = new byte[8];
    private ByteBuffer tmpByteBuffer = ByteBuffer.wrap(this.tmpBuffer);
    private final int bufferSize;

    public LinkedBufferInput(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int read(byte[] b, int off, int len) throws EOFException {
        ByteBuffer bb;
        if (this.link.isEmpty()) {
            return 0;
        }
        int olen = len;
        do {
            if (len < (bb = this.link.getFirst()).remaining()) {
                bb.get(b, off, len);
                this.incrReadByteCount(len);
                return olen;
            }
            int rem = bb.remaining();
            bb.get(b, off, rem);
            this.incrReadByteCount(rem);
            len -= rem;
            off += rem;
        } while (this.removeFirstLink(bb));
        return olen - len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRefer(BufferReferer ref, int len) throws IOException {
        ByteBuffer bb = null;
        try {
            bb = this.link.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (bb == null) {
            throw new EndOfBufferException();
        }
        if (bb.remaining() < len) {
            return false;
        }
        boolean success = false;
        int pos = bb.position();
        int lim = bb.limit();
        try {
            bb.limit(pos + len);
            ref.refer(bb, true);
            this.incrReadByteCount(len);
            success = true;
        }
        finally {
            bb.limit(lim);
            if (success) {
                bb.position(pos + len);
            } else {
                bb.position(pos);
            }
            if (bb.remaining() == 0) {
                this.removeFirstLink(bb);
            }
        }
        return true;
    }

    @Override
    public byte readByte() throws EOFException {
        ByteBuffer bb = null;
        try {
            bb = this.link.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (bb == null || bb.remaining() == 0) {
            throw new EndOfBufferException();
        }
        byte result = bb.get();
        this.incrReadOneByteCount();
        if (bb.remaining() == 0) {
            this.removeFirstLink(bb);
        }
        return result;
    }

    @Override
    public void advance() {
        ByteBuffer bb;
        if (this.link.isEmpty()) {
            return;
        }
        int len = this.nextAdvance;
        do {
            if (len < (bb = this.link.getFirst()).remaining()) {
                bb.position(bb.position() + len);
                break;
            }
            len -= bb.remaining();
            bb.position(bb.position() + bb.remaining());
        } while (this.removeFirstLink(bb));
        this.incrReadByteCount(this.nextAdvance);
        this.nextAdvance = 0;
    }

    private boolean removeFirstLink(ByteBuffer first) {
        if (this.link.size() == 1) {
            if (this.writable >= 0) {
                first.position(0);
                first.limit(0);
                this.writable = first.capacity();
                return false;
            }
            this.link.removeFirst();
            return false;
        }
        this.link.removeFirst();
        return true;
    }

    private void requireMore(int n) throws EOFException {
        int off = 0;
        for (ByteBuffer bb : this.link) {
            if (n <= bb.remaining()) {
                int pos = bb.position();
                bb.get(this.tmpBuffer, off, n);
                bb.position(pos);
                return;
            }
            int rem = bb.remaining();
            int pos = bb.position();
            bb.get(this.tmpBuffer, off, rem);
            bb.position(pos);
            n -= rem;
            off += rem;
        }
        throw new EndOfBufferException();
    }

    private ByteBuffer require(int n) throws EOFException {
        ByteBuffer bb = null;
        try {
            bb = this.link.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (bb == null) {
            throw new EndOfBufferException();
        }
        if (n <= bb.remaining()) {
            this.nextAdvance = n;
            return bb;
        }
        this.requireMore(n);
        this.nextAdvance = n;
        return this.tmpByteBuffer;
    }

    @Override
    public byte getByte() throws EOFException {
        ByteBuffer bb = this.require(1);
        return bb.get(bb.position());
    }

    @Override
    public short getShort() throws EOFException {
        ByteBuffer bb = this.require(2);
        return bb.getShort(bb.position());
    }

    @Override
    public int getInt() throws EOFException {
        ByteBuffer bb = this.require(4);
        return bb.getInt(bb.position());
    }

    @Override
    public long getLong() throws EOFException {
        ByteBuffer bb = this.require(8);
        return bb.getLong(bb.position());
    }

    @Override
    public float getFloat() throws EOFException {
        ByteBuffer bb = this.require(4);
        return bb.getFloat(bb.position());
    }

    @Override
    public double getDouble() throws EOFException {
        ByteBuffer bb = this.require(8);
        return bb.getDouble(bb.position());
    }

    public void feed(byte[] b) {
        this.feed(b, 0, b.length, false);
    }

    public void feed(byte[] b, boolean reference) {
        this.feed(b, 0, b.length, reference);
    }

    public void feed(byte[] b, int off, int len) {
        this.feed(b, off, len, false);
    }

    public void feed(byte[] b, int off, int len, boolean reference) {
        if (reference) {
            if (this.writable > 0 && this.link.getLast().remaining() == 0) {
                this.link.add(this.link.size() - 1, ByteBuffer.wrap(b, off, len));
                return;
            }
            this.link.addLast(ByteBuffer.wrap(b, off, len));
            this.writable = -1;
            return;
        }
        ByteBuffer bb = null;
        try {
            bb = this.link.getLast();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (len <= this.writable) {
            int pos = bb.position();
            bb.position(bb.limit());
            bb.limit(bb.limit() + len);
            bb.put(b, off, len);
            bb.position(pos);
            this.writable = bb.capacity() - bb.limit();
            return;
        }
        if (this.writable > 0) {
            int pos = bb.position();
            bb.position(bb.limit());
            bb.limit(bb.limit() + this.writable);
            bb.put(b, off, this.writable);
            bb.position(pos);
            off += this.writable;
            len -= this.writable;
            this.writable = 0;
        }
        int sz = Math.max(len, this.bufferSize);
        ByteBuffer nb = ByteBuffer.allocate(sz);
        nb.put(b, off, len);
        nb.limit(len);
        nb.position(0);
        this.link.addLast(nb);
        this.writable = sz - len;
    }

    public void feed(ByteBuffer b) {
        this.feed(b, false);
    }

    public void feed(ByteBuffer buf, boolean reference) {
        if (reference) {
            if (this.writable > 0 && this.link.getLast().remaining() == 0) {
                this.link.add(this.link.size() - 1, buf);
                return;
            }
            this.link.addLast(buf);
            this.writable = -1;
            return;
        }
        int rem = buf.remaining();
        ByteBuffer bb = null;
        try {
            bb = this.link.getLast();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (rem <= this.writable) {
            int pos = bb.position();
            bb.position(bb.limit());
            bb.limit(bb.limit() + rem);
            bb.put(buf);
            bb.position(pos);
            this.writable = bb.capacity() - bb.limit();
            return;
        }
        if (this.writable > 0) {
            int pos = bb.position();
            bb.position(bb.limit());
            bb.limit(bb.limit() + this.writable);
            buf.limit(this.writable);
            bb.put(buf);
            bb.position(pos);
            buf.limit(buf.limit() + (rem -= this.writable));
            this.writable = 0;
        }
        int sz = Math.max(rem, this.bufferSize);
        ByteBuffer nb = ByteBuffer.allocate(sz);
        nb.put(buf);
        nb.limit(rem);
        nb.position(0);
        this.link.addLast(nb);
        this.writable = sz - rem;
    }

    public void clear() {
        if (this.writable >= 0) {
            ByteBuffer bb = this.link.getLast();
            this.link.clear();
            bb.position(0);
            bb.limit(0);
            this.link.addLast(bb);
            this.writable = bb.capacity();
        } else {
            this.link.clear();
            this.writable = -1;
        }
    }

    public void copyReferencedBuffer() {
        if (this.link.isEmpty()) {
            return;
        }
        int size = 0;
        for (ByteBuffer bb : this.link) {
            size += bb.remaining();
        }
        if (size == 0) {
            return;
        }
        if (this.writable >= 0) {
            ByteBuffer last = this.link.removeLast();
            byte[] copy = new byte[size - last.remaining()];
            int off = 0;
            for (ByteBuffer bb : this.link) {
                int len = bb.remaining();
                bb.get(copy, off, len);
                off += len;
            }
            this.link.clear();
            this.link.add(ByteBuffer.wrap(copy));
            this.link.add(last);
        } else {
            byte[] copy = new byte[size];
            int off = 0;
            for (ByteBuffer bb : this.link) {
                int len = bb.remaining();
                bb.get(copy, off, len);
                off += len;
            }
            this.link.clear();
            this.link.add(ByteBuffer.wrap(copy));
            this.writable = 0;
        }
    }

    public int getSize() {
        int size = 0;
        for (ByteBuffer bb : this.link) {
            size += bb.remaining();
        }
        return size;
    }

    @Override
    public void close() {
    }
}

