/*
 * Decompiled with CFR 0.152.
 */
package com.fulcrologicpro.org.msgpack.template;

import com.fulcrologicpro.org.msgpack.MessagePackable;
import com.fulcrologicpro.org.msgpack.MessageTypeException;
import com.fulcrologicpro.org.msgpack.packer.Packer;
import com.fulcrologicpro.org.msgpack.template.AbstractTemplate;
import com.fulcrologicpro.org.msgpack.unpacker.Unpacker;
import java.io.IOException;

public class MessagePackableTemplate
extends AbstractTemplate<MessagePackable> {
    private Class<?> targetClass;

    MessagePackableTemplate(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public void write(Packer pk, MessagePackable target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        target.writeTo(pk);
    }

    @Override
    public MessagePackable read(Unpacker u, MessagePackable to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        if (to == null) {
            try {
                to = (MessagePackable)this.targetClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MessageTypeException(e);
            }
            catch (IllegalAccessException e) {
                throw new MessageTypeException(e);
            }
        }
        to.readFrom(u);
        return to;
    }
}

