(ns com.fulcrologic.fulcro.dom2
  "Identical to dom, but does *no wrapping* on inputs. MUST be used with the `:synchronous? true` option of
   `transact!` to prevent things like cursor jumping.
  "
  (:refer-clojure :exclude [map meta time mask select use set symbol filter])
  (:require
    [com.fulcrologic.fulcro.algorithms.do-not-use :as util]
    [com.fulcrologic.fulcro.components :as comp]
    [com.fulcrologic.fulcro.dom-common :as cdom]
    [com.fulcrologic.fulcro.dom :as legacy-dom])
  (:import (cljs.tagged_literals JSValue)))

(defn emit-tag
  "PRIVATE.  DO NOT USE.

  Helper function for generating CLJS DOM macros. is public for code gen problems."
  [str-tag-name args]
  (let [conformed-args      (util/conform! ::legacy-dom/dom-macro-args args)
        {attrs    :attrs
         children :children
         css      :css} conformed-args
        css-props           (cdom/add-kwprops-to-props {} css)
        raw-children        (mapv second children)
        children            (mapv (fn [[_ c]]
                                    (if (or (nil? c) (string? c))
                                      c
                                      `(comp/force-children ~c))) children)
        attrs-type          (or (first attrs) :nil)         ; attrs omitted == nil
        attrs-value         (or (second attrs) {})
        create-element      'com.fulcrologic.fulcro.dom2/macro-create-element*
        classes-expression? (and (= attrs-type :map) (contains? attrs-value :classes))
        attrs-type          (if classes-expression? :runtime-map attrs-type)]
    (case attrs-type
      :js-object                                            ; kw combos not supported
      (if css
        (let [attr-expr `(cdom/add-kwprops-to-props ~attrs-value ~css)]
          `(~create-element ~(JSValue. (into [str-tag-name attr-expr] children))))
        `(~create-element ~(JSValue. (into [str-tag-name attrs-value] children))))

      :map
      `(~create-element ~(JSValue. (into [str-tag-name (-> attrs-value
                                                         (cdom/add-kwprops-to-props css)
                                                         (legacy-dom/clj-map->js-object))]
                                     children)))

      :runtime-map
      `(com.fulcrologic.fulcro.dom2/macro-create-element ~str-tag-name ~(into [attrs-value] raw-children) ~css)


      (:symbol :expression)
      `(com.fulcrologic.fulcro.dom2/macro-create-element
         ~str-tag-name ~(into [attrs-value] raw-children) ~css)

      :nil
      `(~create-element
         ~(JSValue. (into [str-tag-name (JSValue. css-props)] children)))

      ;; pure children
      `(com.fulcrologic.fulcro.dom2/macro-create-element
         ~str-tag-name ~(JSValue. (into [attrs-value] raw-children)) ~css))))

(defn- gen-client-dom-fn [create-element-symbol tag]
  `(defn ~tag ~(cdom/gen-docstring tag true)
     [& ~'args]
     (let [conformed-args# (com.fulcrologic.fulcro.dom2/parse-args ~'args) ; see CLJS file for spec
           {attrs#    :attrs
            children# :children
            css#      :css} conformed-args#
           children#       (mapv second children#)
           attrs-value#    (or (second attrs#) {})]
       (~create-element-symbol ~(name tag) (into [attrs-value#] children#) css#))))

(defmacro gen-client-dom-fns [create-element-sym]
  `(do ~@(clojure.core/map (partial gen-client-dom-fn create-element-sym) cdom/tags)))

(legacy-dom/gen-dom-macros com.fulcrologic.fulcro.dom2/emit-tag)
