/*
 * Decompiled with CFR 0.152.
 */
package com.gabber;

import com.gabber.RequestModel;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.uri.UriTemplate;

public class ReflectionUtils {
    public static RequestModel generateModel(Method thisMethod, Object[] args) {
        Path path = thisMethod.getAnnotation(Path.class);
        UriTemplate tmpl = new UriTemplate(path.value());
        RequestModel model = new RequestModel();
        ArrayList<String> paths = new ArrayList<String>();
        HashMap<String, String> queries = new HashMap<String, String>();
        ArrayList<Object> noAnnotation = new ArrayList<Object>();
        for (int i = 0; i < thisMethod.getParameterAnnotations().length; ++i) {
            if (Arrays.asList(thisMethod.getParameterAnnotations()[i]).stream().filter(ann -> ann.annotationType().equals(PathParam.class)).findAny().isPresent()) {
                paths.add((String)args[i]);
            }
            if (Arrays.asList(thisMethod.getParameterAnnotations()[i]).stream().filter(ann -> ann.annotationType().equals(QueryParam.class)).findAny().isPresent()) {
                String key = ((QueryParam)Arrays.asList(thisMethod.getParameterAnnotations()[i]).stream().filter(ann -> ann.annotationType().equals(QueryParam.class)).findAny().get()).value();
                queries.put(key, (String)args[i]);
            }
            if (thisMethod.getParameterAnnotations().length != 0) continue;
            noAnnotation.add(args[i]);
        }
        model.setPaths(paths);
        model.setQueries(queries);
        model.setNoAnnotation(noAnnotation);
        model.setPath(tmpl.createURI(paths.toArray(new String[0])));
        Consumes consumes = thisMethod.getAnnotation(Consumes.class);
        if (consumes != null) {
            model.setConsumes(Sets.newHashSet((Object[])consumes.value()));
        }
        return model;
    }

    public static String getMethod(Method thisMethod) {
        if (thisMethod.getAnnotation(POST.class) != null) {
            return "POST";
        }
        if (thisMethod.getAnnotation(PUT.class) != null) {
            return "PUT";
        }
        if (thisMethod.getAnnotation(DELETE.class) != null) {
            return "DELETE";
        }
        if (thisMethod.getAnnotation(OPTIONS.class) != null) {
            return "OPTIONS";
        }
        if (thisMethod.getAnnotation(HEAD.class) != null) {
            return "HEAD";
        }
        return "GET";
    }
}

