/*
 * Decompiled with CFR 0.152.
 */
package com.gabber;

import com.flipkart.ranger.model.ServiceNode;
import com.gabber.BroadcastIt;
import com.gabber.HttpUtils;
import io.dropwizard.discovery.bundle.ServiceDiscoveryBundle;
import io.dropwizard.discovery.common.ShardInfo;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BroadcastIt
public class ShouldBroadcastFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ShouldBroadcastFilter.class);
    private ServiceDiscoveryBundle bundle;

    public ShouldBroadcastFilter(ServiceDiscoveryBundle bundle) {
        this.bundle = bundle;
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        if (containerRequestContext.getHeaderString("X-BROADCASTED") != null) {
            return;
        }
        Client client = ClientBuilder.newClient();
        InputStream in = containerRequestContext.getEntityStream();
        MultivaluedHashMap headers = new MultivaluedHashMap();
        containerRequestContext.getHeaders().entrySet().forEach(entry -> headers.put(entry.getKey(), ((List)entry.getValue()).stream().map(x -> x).collect(Collectors.toList())));
        UriInfo url = containerRequestContext.getUriInfo();
        String path = url.getRequestUri().toString().replaceAll(url.getBaseUri().toString(), "/");
        String method = containerRequestContext.getMethod();
        String selfHost = System.getenv("HOST");
        List ans = this.bundle.getServiceDiscoveryClient().getAllNodes().stream().map(node -> {
            String hostPort = HttpUtils.hostPortString((ServiceNode<ShardInfo>)node);
            if (node.getHost().equals(selfHost)) {
                return Data.builder().status(containerResponseContext.getStatus()).host(hostPort).data(containerResponseContext.getEntity()).build();
            }
            String urlPath = String.format("%s%s", hostPort, path);
            log.info("URLS being called {}", (Object)urlPath);
            try {
                headers.putSingle((Object)"Host", (Object)node.getHost());
                headers.putSingle((Object)"Accept-Encoding", (Object)"UTF-8");
                headers.putSingle((Object)"X-BROADCASTED", (Object)"true");
                Response res = HttpUtils.sendRequest(client, urlPath, method, (MultivaluedHashMap<String, Object>)headers, containerRequestContext.hasEntity(), containerRequestContext.getMediaType(), IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
                Object retData = HttpUtils.readResponseObject(res);
                return Data.builder().data(retData).host(hostPort).status(res.getStatus()).build();
            }
            catch (Exception e) {
                log.error("Error Calling Url {}", (Object)urlPath, (Object)e);
                return Data.builder().status(400).host(hostPort).data(e.getMessage()).build();
            }
        }).collect(Collectors.toList());
        log.info("Responses {}", ans);
        containerResponseContext.setEntity(ans, new Annotation[0], MediaType.APPLICATION_JSON_TYPE);
    }

    public static class Data {
        private int status;
        private String host;
        private Object data;

        public static DataBuilder builder() {
            return new DataBuilder();
        }

        public int getStatus() {
            return this.status;
        }

        public String getHost() {
            return this.host;
        }

        public Object getData() {
            return this.data;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatus() != other.getStatus()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatus();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "ShouldBroadcastFilter.Data(status=" + this.getStatus() + ", host=" + this.getHost() + ", data=" + this.getData() + ")";
        }

        @ConstructorProperties(value={"status", "host", "data"})
        public Data(int status, String host, Object data) {
            this.status = status;
            this.host = host;
            this.data = data;
        }

        public Data() {
        }

        public static class DataBuilder {
            private int status;
            private String host;
            private Object data;

            DataBuilder() {
            }

            public DataBuilder status(int status) {
                this.status = status;
                return this;
            }

            public DataBuilder host(String host) {
                this.host = host;
                return this;
            }

            public DataBuilder data(Object data) {
                this.data = data;
                return this;
            }

            public Data build() {
                return new Data(this.status, this.host, this.data);
            }

            public String toString() {
                return "ShouldBroadcastFilter.Data.DataBuilder(status=" + this.status + ", host=" + this.host + ", data=" + this.data + ")";
            }
        }
    }
}

